/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.naming;

import java.util.Locale;
import java.util.Objects;
import org.hibernate.boot.model.naming.IllegalIdentifierException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;

public class Identifier
implements Comparable<Identifier> {
    private final String text;
    private final boolean isQuoted;

    public static Identifier toIdentifier(String text) {
        return Identifier.toIdentifier(text, false);
    }

    public static Identifier toIdentifier(String text, boolean quote) {
        return Identifier.toIdentifier(text, quote, true);
    }

    public static Identifier toIdentifier(String text, boolean quote, boolean autoquote) {
        int start;
        if (StringHelper.isBlank(text)) {
            return null;
        }
        int end = text.length();
        for (start = 0; start < end && Character.isWhitespace(text.charAt(start)); ++start) {
        }
        while (start < end && Character.isWhitespace(text.charAt(end - 1))) {
            --end;
        }
        if (Identifier.isQuoted(text, start, end)) {
            ++start;
            --end;
            quote = true;
        } else if (autoquote && !quote) {
            quote = Identifier.autoquote(text, start, end);
        }
        return new Identifier(text.substring(start, end), quote);
    }

    private static boolean autoquote(String text, int start, int end) {
        if (!Identifier.isLegalFirstChar(text.charAt(start))) {
            return true;
        }
        for (int i = start + 1; i < end; ++i) {
            if (Identifier.isLegalChar(text.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isLegalChar(char current) {
        return Character.isLetterOrDigit(current) || current == '_' || current == '$';
    }

    private static boolean isLegalFirstChar(char first) {
        return Character.isLetter(first) || first == '_';
    }

    public static boolean isQuoted(String name) {
        return Identifier.isQuoted(name, 0, name.length());
    }

    public static boolean isQuoted(String name, int start, int end) {
        if (start + 2 < end) {
            char first = name.charAt(start);
            char last = name.charAt(end - 1);
            return switch (first) {
                case '`' -> {
                    if (last == '`') {
                        yield true;
                    }
                    yield false;
                }
                case '[' -> {
                    if (last == ']') {
                        yield true;
                    }
                    yield false;
                }
                case '\"' -> {
                    if (last == '\"') {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public static String unQuote(String name) {
        assert (Identifier.isQuoted(name));
        return name.substring(1, name.length() - 1);
    }

    public Identifier(String text, boolean quoted) {
        if (StringHelper.isEmpty(text)) {
            throw new IllegalIdentifierException("Identifier text cannot be null");
        }
        if (Identifier.isQuoted(text)) {
            throw new IllegalIdentifierException("Identifier text should not contain quote markers (` or \")");
        }
        this.text = text;
        this.isQuoted = quoted;
    }

    protected Identifier(String text) {
        this.text = text;
        this.isQuoted = false;
    }

    public String getText() {
        return this.text;
    }

    public boolean isQuoted() {
        return this.isQuoted;
    }

    public Identifier quoted() {
        return this.isQuoted ? this : Identifier.toIdentifier(this.text, true);
    }

    public String render(Dialect dialect) {
        return this.isQuoted ? dialect.toQuotedIdentifier(this.getText()) : this.getText();
    }

    public String render() {
        return this.isQuoted ? "`" + this.getText() + "`" : this.getText();
    }

    public String getCanonicalName() {
        return this.isQuoted ? this.text : this.text.toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return this.render();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof Identifier)) return false;
        Identifier that = (Identifier)object;
        if (!this.getCanonicalName().equals(that.getCanonicalName())) return false;
        return true;
    }

    public boolean matches(String name) {
        return this.isQuoted() ? this.text.equals(name) : this.text.equalsIgnoreCase(name);
    }

    public int hashCode() {
        return this.isQuoted ? this.text.hashCode() : this.text.toLowerCase(Locale.ENGLISH).hashCode();
    }

    @Override
    public int compareTo(Identifier identifier) {
        return this.getCanonicalName().compareTo(identifier.getCanonicalName());
    }

    public static boolean areEqual(Identifier id1, Identifier id2) {
        return Objects.equals(id1, id2);
    }

    @Deprecated(since="7.1", forRemoval=true)
    public static Identifier quote(Identifier identifier) {
        return identifier.quoted();
    }
}

