/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal;

import jakarta.persistence.metamodel.Attribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.graph.CannotContainSubGraphException;
import org.hibernate.graph.internal.AbstractGraphNode;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AttributeNodeImpl<J, E, K>
extends AbstractGraphNode<J>
implements AttributeNodeImplementor<J, E, K> {
    protected final PersistentAttribute<?, J> attribute;
    protected final DomainType<E> valueGraphType;
    protected final SimpleDomainType<K> keyGraphType;
    protected SubGraphImplementor<E> valueSubgraph;
    protected SubGraphImplementor<K> keySubgraph;

    static <J> AttributeNodeImpl<J, ?, ?> create(PersistentAttribute<?, J> attribute, boolean mutable) {
        if (attribute instanceof PluralPersistentAttribute) {
            PluralPersistentAttribute pluralAttribute = (PluralPersistentAttribute)attribute;
            return AttributeNodeImpl.create(pluralAttribute, mutable);
        }
        if (attribute instanceof SingularPersistentAttribute) {
            SingularPersistentAttribute singularAttribute = (SingularPersistentAttribute)attribute;
            return new SingularAttributeNodeImpl(singularAttribute, mutable, singularAttribute.getValueGraphType());
        }
        throw new AssertionFailure("Unrecognized attribute type: " + String.valueOf(attribute));
    }

    static <J, E> AttributeNodeImpl<J, E, ?> create(PluralPersistentAttribute<?, J, E> attribute, boolean mutable) {
        if (attribute instanceof MapPersistentAttribute) {
            MapPersistentAttribute mapAttribute = (MapPersistentAttribute)attribute;
            return AttributeNodeImpl.create(attribute, mapAttribute, mutable);
        }
        return new PluralAttributeNodeImpl<J, E>(attribute, mutable, attribute.getValueGraphType());
    }

    static <K, V> AttributeNodeImpl<Map<K, V>, V, K> create(MapPersistentAttribute<?, K, V> attribute, boolean mutable) {
        return new MapAttributeNodeImpl<K, K, V>(attribute, attribute, mutable, attribute.getValueGraphType(), attribute.getKeyGraphType());
    }

    private static <J, K, V> AttributeNodeImpl<J, V, K> create(PluralPersistentAttribute<?, J, V> plural, MapPersistentAttribute<?, K, ?> attribute, boolean mutable) {
        return new MapAttributeNodeImpl<J, K, V>(plural, attribute, mutable, plural.getValueGraphType(), attribute.getKeyGraphType());
    }

    AttributeNodeImpl(PersistentAttribute<?, J> attribute, boolean mutable, DomainType<E> valueGraphType, SimpleDomainType<K> keyGraphType) {
        super(mutable);
        this.attribute = attribute;
        this.valueGraphType = valueGraphType;
        this.keyGraphType = keyGraphType;
    }

    private AttributeNodeImpl(AttributeNodeImpl<J, E, K> that, boolean mutable) {
        super(mutable);
        this.attribute = that.attribute;
        this.valueGraphType = that.valueGraphType;
        this.keyGraphType = that.keyGraphType;
        this.valueSubgraph = that.valueSubgraph == null ? null : that.valueSubgraph.makeCopy(mutable);
        this.keySubgraph = that.keySubgraph == null ? null : that.keySubgraph.makeCopy(mutable);
    }

    public String getAttributeName() {
        return this.getAttributeDescriptor().getName();
    }

    @Override
    public PersistentAttribute<?, J> getAttributeDescriptor() {
        return this.attribute;
    }

    @Override
    public SubGraphImplementor<E> addValueSubgraph() {
        this.verifyMutability();
        if (this.valueSubgraph == null) {
            this.valueSubgraph = new SubGraphImpl<E>(this.asManagedType(this.valueGraphType), true);
        }
        return this.valueSubgraph;
    }

    @Override
    public SubGraphImplementor<J> addSingularSubgraph() {
        throw new UnsupportedOperationException("Not a singular attribute node");
    }

    @Override
    public SubGraphImplementor<E> addElementSubgraph() {
        throw new UnsupportedOperationException("Not a collection-valued attribute node");
    }

    @Override
    public SubGraphImplementor<K> addKeySubgraph() {
        throw new UnsupportedOperationException("Not a Map-valued attribute node");
    }

    protected void checkToOne() {
        Attribute.PersistentAttributeType attributeType = this.attribute.getPersistentAttributeType();
        if (attributeType != Attribute.PersistentAttributeType.MANY_TO_ONE && attributeType != Attribute.PersistentAttributeType.ONE_TO_ONE && attributeType != Attribute.PersistentAttributeType.EMBEDDED) {
            throw new CannotContainSubGraphException("Attribute '" + this.attribute.getName() + "' is not a to-one association");
        }
    }

    protected void checkToMany() {
        Attribute.PersistentAttributeType attributeType = this.attribute.getPersistentAttributeType();
        if (attributeType != Attribute.PersistentAttributeType.MANY_TO_MANY && attributeType != Attribute.PersistentAttributeType.ONE_TO_MANY) {
            throw new CannotContainSubGraphException("Attribute '" + this.attribute.getName() + "' is not a to-many association");
        }
    }

    @Override
    @Deprecated
    public SubGraphImplementor<E> makeSubGraph() {
        this.verifyMutability();
        if (this.valueSubgraph == null) {
            this.valueSubgraph = new SubGraphImpl<E>(this.asManagedType(this.valueGraphType), true);
        }
        return this.valueSubgraph;
    }

    @Override
    @Deprecated
    public <S> SubGraphImplementor<S> makeSubGraph(Class<S> subtype) {
        ManagedDomainType<E> managedType = this.asManagedType(this.valueGraphType);
        if (!managedType.getJavaType().isAssignableFrom(subtype)) {
            throw new IllegalArgumentException("Not a subtype: " + subtype.getName());
        }
        Class<S> castSuptype = subtype;
        SubGraphImplementor result = this.makeSubGraph().addTreatedSubgraph(castSuptype);
        return result;
    }

    @Override
    @Deprecated
    public SubGraphImplementor<K> makeKeySubGraph() {
        this.verifyMutability();
        this.checkMap();
        if (this.keySubgraph == null) {
            this.keySubgraph = new SubGraphImpl<K>(this.asManagedType(this.keyGraphType), true);
        }
        return this.keySubgraph;
    }

    @Override
    @Deprecated
    public <S> SubGraphImplementor<S> makeKeySubGraph(Class<S> subtype) {
        this.checkMap();
        ManagedDomainType<K> type = this.asManagedType(this.keyGraphType);
        if (!type.getJavaType().isAssignableFrom(subtype)) {
            throw new IllegalArgumentException("Not a key subtype: " + subtype.getName());
        }
        Class<S> castType = subtype;
        SubGraphImplementor result = this.makeKeySubGraph().addTreatedSubgraph(castType);
        return result;
    }

    private void checkMap() {
        if (this.keyGraphType == null) {
            throw new CannotContainSubGraphException("Attribute '" + this.description() + "' is not a Map");
        }
    }

    protected <T> ManagedDomainType<T> asManagedType(DomainType<T> domainType) {
        if (domainType instanceof ManagedDomainType) {
            ManagedDomainType managedDomainType = (ManagedDomainType)domainType;
            return managedDomainType;
        }
        throw new CannotContainSubGraphException("Attribute '" + this.description() + "' is of type '" + domainType.getTypeName() + "' which is not a managed type");
    }

    private String description() {
        return this.attribute.getDeclaringType().getTypeName() + "." + this.attribute.getName();
    }

    public String toString() {
        return "AttributeNode[" + this.description() + "]";
    }

    @Override
    public void merge(AttributeNodeImplementor<J, E, K> that) {
        SubGraphImplementor<K> otherKeySubgraph;
        assert (that.isMutable() == this.isMutable());
        assert (that.getAttributeDescriptor() == this.attribute);
        SubGraphImplementor<E> otherValueSubgraph = that.getValueSubgraph();
        if (otherValueSubgraph != null) {
            if (this.valueSubgraph == null) {
                this.valueSubgraph = otherValueSubgraph.makeCopy(this.isMutable());
            } else {
                this.valueSubgraph.mergeInternal(otherValueSubgraph);
            }
        }
        if ((otherKeySubgraph = that.getKeySubgraph()) != null) {
            if (this.keySubgraph == null) {
                this.keySubgraph = otherKeySubgraph.makeCopy(this.isMutable());
            } else {
                this.keySubgraph.mergeInternal(otherKeySubgraph);
            }
        }
    }

    @Override
    public Map<Class<?>, SubGraphImplementor<?>> getSubGraphs() {
        if (this.valueSubgraph == null) {
            return Collections.emptyMap();
        }
        HashMap map = new HashMap(this.valueSubgraph.getTreatedSubgraphs());
        map.put(this.attribute.getValueGraphType().getJavaType(), this.valueSubgraph);
        return map;
    }

    @Override
    public Map<Class<?>, SubGraphImplementor<?>> getKeySubGraphs() {
        if (this.keySubgraph == null) {
            return Collections.emptyMap();
        }
        HashMap map = new HashMap(this.keySubgraph.getTreatedSubgraphs());
        map.put(this.attribute.getKeyGraphType().getJavaType(), this.keySubgraph);
        return map;
    }

    @Override
    public SubGraphImplementor<E> getValueSubgraph() {
        return this.valueSubgraph;
    }

    @Override
    public SubGraphImplementor<K> getKeySubgraph() {
        return this.keySubgraph;
    }

    static final class SingularAttributeNodeImpl<J>
    extends AttributeNodeImpl<J, J, Void> {
        private SingularAttributeNodeImpl(SingularPersistentAttribute<?, J> attribute, boolean mutable, DomainType<J> valueGraphType) {
            super(attribute, mutable, valueGraphType, null);
        }

        private SingularAttributeNodeImpl(AttributeNodeImpl<J, J, Void> that, boolean mutable) {
            super(that, mutable);
        }

        @Override
        public SubGraphImplementor<J> addSingularSubgraph() {
            this.checkToOne();
            this.verifyMutability();
            if (this.valueSubgraph == null) {
                this.valueSubgraph = new SubGraphImpl(this.asManagedType(this.valueGraphType), true);
            }
            return this.valueSubgraph;
        }

        @Override
        public AttributeNodeImplementor<J, J, Void> makeCopy(boolean mutable) {
            return !mutable && !this.isMutable() ? this : new SingularAttributeNodeImpl<J>(this, mutable);
        }
    }

    static final class PluralAttributeNodeImpl<J, E>
    extends AttributeNodeImpl<J, E, Void> {
        private PluralAttributeNodeImpl(PluralPersistentAttribute<?, J, E> attribute, boolean mutable, DomainType<E> valueGraphType) {
            super(attribute, mutable, valueGraphType, null);
        }

        private PluralAttributeNodeImpl(AttributeNodeImpl<J, E, Void> that, boolean mutable) {
            super(that, mutable);
        }

        @Override
        public SubGraphImplementor<E> addElementSubgraph() {
            this.checkToMany();
            this.verifyMutability();
            if (this.valueSubgraph == null) {
                this.valueSubgraph = new SubGraphImpl(this.asManagedType(this.valueGraphType), true);
            }
            return this.valueSubgraph;
        }

        @Override
        public AttributeNodeImplementor<J, E, Void> makeCopy(boolean mutable) {
            return !mutable && !this.isMutable() ? this : new PluralAttributeNodeImpl<J, E>(this, mutable);
        }
    }

    static final class MapAttributeNodeImpl<J, K, V>
    extends AttributeNodeImpl<J, V, K> {
        private MapAttributeNodeImpl(PluralPersistentAttribute<?, J, V> pluralAttribute, MapPersistentAttribute<?, K, ?> attribute, boolean mutable, DomainType<V> valueGraphType, SimpleDomainType<K> keyGraphType) {
            super(pluralAttribute, mutable, valueGraphType, keyGraphType);
        }

        private MapAttributeNodeImpl(AttributeNodeImpl<J, V, K> that, boolean mutable) {
            super(that, mutable);
        }

        @Override
        public SubGraphImplementor<K> addKeySubgraph() {
            this.verifyMutability();
            if (this.keySubgraph == null) {
                this.keySubgraph = new SubGraphImpl(this.asManagedType(this.keyGraphType), true);
            }
            return this.keySubgraph;
        }

        @Override
        public SubGraphImplementor<V> addElementSubgraph() {
            this.checkToMany();
            this.verifyMutability();
            if (this.valueSubgraph == null) {
                this.valueSubgraph = new SubGraphImpl(this.asManagedType(this.valueGraphType), true);
            }
            return this.valueSubgraph;
        }

        @Override
        public AttributeNodeImplementor<J, V, K> makeCopy(boolean mutable) {
            return !mutable && !this.isMutable() ? this : new MapAttributeNodeImpl<J, K, V>(this, mutable);
        }
    }
}

