/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.community.dialect.DB2LegacySqlAstTranslator;
import org.hibernate.community.dialect.DB2zLegacyDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2zLegacySqlAstTranslator<T extends JdbcOperation>
extends DB2LegacySqlAstTranslator<T> {
    private final DatabaseVersion version;

    public DB2zLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement, DatabaseVersion version) {
        super(sessionFactory, statement);
        this.version = version;
    }

    @Override
    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && (this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart) || this.version.isBefore(12) && queryPart.isRoot() && this.hasLimit() || this.version.isBefore(12) && queryPart.getFetchClauseExpression() != null && !(queryPart.getFetchClauseExpression() instanceof Literal));
    }

    @Override
    protected boolean supportsOffsetClause() {
        return this.version.isSameOrAfter(12);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.append("table ");
        super.visitQueryPartTableReference(tableReference);
    }

    @Override
    protected String getNewTableChangeModifier() {
        return "final";
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2zLegacyDialect.DB2_LUW_VERSION9;
    }
}

