/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.tree.ParseTree;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.ResourceTypeSelector;
import org.keycloak.models.workflow.Workflow;
import org.keycloak.models.workflow.WorkflowStateEntity;
import org.keycloak.models.workflow.conditions.expression.BooleanConditionParser;
import org.keycloak.models.workflow.conditions.expression.EvaluatorUtils;
import org.keycloak.models.workflow.conditions.expression.PredicateEvaluator;
import org.keycloak.utils.StringUtil;

public class UserResourceTypeWorkflowProvider
implements ResourceTypeSelector {
    private final EntityManager em;
    private final KeycloakSession session;

    public UserResourceTypeWorkflowProvider(KeycloakSession session) {
        this.session = session;
        this.em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
    }

    public List<String> getResourceIds(Workflow workflow) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(String.class);
        Root userRoot = query.from(UserEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Subquery subquery = query.subquery(Integer.class);
        Root stateRoot = subquery.from(WorkflowStateEntity.class);
        subquery.select(cb.literal((Object)1));
        subquery.where((Expression)cb.and((Expression)cb.equal((Expression)stateRoot.get("resourceId"), (Expression)userRoot.get("id")), (Expression)cb.equal((Expression)stateRoot.get("workflowId"), (Object)workflow.getId())));
        RealmModel realm = this.session.getContext().getRealm();
        predicates.add(cb.equal((Expression)userRoot.get("realmId"), (Object)realm.getId()));
        Predicate notExistsPredicate = cb.not((Expression)cb.exists(subquery));
        predicates.add(notExistsPredicate);
        predicates.add(this.getConditionsPredicate(workflow, cb, (CriteriaQuery<String>)query, (Root<UserEntity>)userRoot));
        query.select((Selection)userRoot.get("id")).where(predicates);
        int batchSize = Integer.parseInt((String)workflow.getConfig().getFirstOrDefault((Object)"schedule.batch-size", (Object)"100"));
        return this.em.createQuery(query).setMaxResults(batchSize).getResultList();
    }

    public Object resolveResource(String resourceId) {
        Objects.requireNonNull(resourceId, "resourceId");
        return ResourceType.USERS.resolveResource(this.session, resourceId);
    }

    private Predicate getConditionsPredicate(Workflow workflow, CriteriaBuilder cb, CriteriaQuery<String> query, Root<UserEntity> path) {
        MultivaluedHashMap config = workflow.getConfig();
        String conditions = (String)config.getFirst((Object)"conditions");
        if (StringUtil.isBlank((String)conditions)) {
            return cb.conjunction();
        }
        BooleanConditionParser.EvaluatorContext context = EvaluatorUtils.createEvaluatorContext((String)conditions);
        PredicateEvaluator evaluator = new PredicateEvaluator(this.session, cb, query, path);
        return (Predicate)evaluator.visit((ParseTree)context);
    }
}

