/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.NClob;
import java.util.Arrays;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.engine.jdbc.internal.CharacterStreamImpl;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.java.DataHelper;
import org.hibernate.type.descriptor.java.ImmutableObjectArrayMutabilityPlan;
import org.hibernate.type.descriptor.java.IncomparableComparator;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class CharacterArrayJavaType
extends AbstractClassJavaType<Character[]> {
    public static final CharacterArrayJavaType INSTANCE = new CharacterArrayJavaType();

    public CharacterArrayJavaType() {
        super(Character[].class, ImmutableObjectArrayMutabilityPlan.get(), IncomparableComparator.INSTANCE);
    }

    @Override
    public boolean isInstance(Object value) {
        return value instanceof Character[];
    }

    @Override
    public String toString(Character[] value) {
        return new String(this.unwrapChars(value));
    }

    @Override
    public Character[] fromString(CharSequence string) {
        return this.wrapChars(string.toString().toCharArray());
    }

    @Override
    public boolean areEqual(Character[] one, Character[] another) {
        return one == another || one != null && another != null && Arrays.equals((Object[])one, (Object[])another);
    }

    @Override
    public int extractHashCode(Character[] chars) {
        int hashCode = 1;
        for (Character aChar : chars) {
            hashCode = 31 * hashCode + aChar.charValue();
        }
        return hashCode;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators indicators) {
        JdbcType descriptor = indicators.getJdbcType(indicators.resolveJdbcTypeCode(12));
        return descriptor instanceof AdjustableJdbcType ? ((AdjustableJdbcType)descriptor).resolveIndicatedType(indicators, this) : descriptor;
    }

    @Override
    public <X> X unwrap(Character[] value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Character[].class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)new String(this.unwrapChars(value));
        }
        if (NClob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createNClob(new String(this.unwrapChars(value)));
        }
        if (Clob.class.isAssignableFrom(type)) {
            return (X)options.getLobCreator().createClob(new String(this.unwrapChars(value)));
        }
        if (Reader.class.isAssignableFrom(type)) {
            return (X)new StringReader(new String(this.unwrapChars(value)));
        }
        if (CharacterStream.class.isAssignableFrom(type)) {
            return (X)new CharacterStreamImpl(new String(this.unwrapChars(value)));
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Character[] wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character[]) {
            Character[] characters = (Character[])value;
            return characters;
        }
        if (value instanceof String) {
            String string = (String)value;
            return this.wrapChars(string.toCharArray());
        }
        if (value instanceof Clob) {
            Clob clob = (Clob)value;
            return this.wrapChars(DataHelper.extractString(clob).toCharArray());
        }
        if (value instanceof Reader) {
            Reader reader = (Reader)value;
            return this.wrapChars(DataHelper.extractString(reader).toCharArray());
        }
        throw this.unknownWrap(value.getClass());
    }

    private Character[] wrapChars(char[] chars) {
        if (chars == null) {
            return null;
        }
        Character[] result = new Character[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = Character.valueOf(chars[i]);
        }
        return result;
    }

    private char[] unwrapChars(Character[] chars) {
        if (chars == null) {
            return null;
        }
        char[] result = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = chars[i].charValue();
        }
        return result;
    }
}

