/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.deserialization;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.deserialization.FirConstDeserializerKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer;", "", "protocol", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "<init>", "(Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;)V", "constantCache", "", "Lorg/jetbrains/kotlin/name/CallableId;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "getConstantCache", "()Ljava/util/Map;", "loadConstant", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "propertyProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "callableId", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "isUnsigned", "", "fir-deserialization"})
@SourceDebugExtension(value={"SMAP\nFirConstDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConstDeserializer.kt\norg/jetbrains/kotlin/fir/deserialization/FirConstDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public class FirConstDeserializer {
    @NotNull
    private final SerializerExtensionProtocol protocol;
    @NotNull
    private final Map<CallableId, FirLiteralExpression> constantCache;

    public FirConstDeserializer(@NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        this.protocol = protocol;
        this.constantCache = new HashMap();
    }

    @NotNull
    protected final Map<CallableId, FirLiteralExpression> getConstantCache() {
        return this.constantCache;
    }

    @Nullable
    public FirExpression loadConstant(@NotNull ProtoBuf.Property propertyProto, @NotNull CallableId callableId, @NotNull NameResolver nameResolver, boolean isUnsigned) {
        FirLiteralExpression firLiteralExpression;
        Intrinsics.checkNotNullParameter(propertyProto, "propertyProto");
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        if (!Flags.HAS_CONSTANT.get(propertyProto.getFlags()).booleanValue()) {
            return null;
        }
        FirLiteralExpression firLiteralExpression2 = this.constantCache.get(callableId);
        if (firLiteralExpression2 != null) {
            FirLiteralExpression it = firLiteralExpression2;
            boolean bl = false;
            return it;
        }
        ProtoBuf.Annotation.Argument.Value value2 = ProtoBufUtilKt.getExtensionOrNull(propertyProto, this.protocol.getCompileTimeValue());
        if (value2 == null) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value3 = value2;
        FirLiteralExpression firLiteralExpression3 = FirConstDeserializerKt.buildFirConstant(value3, null, value3.getType().name(), nameResolver, isUnsigned);
        if (firLiteralExpression3 != null) {
            FirLiteralExpression firLiteralExpression4;
            FirLiteralExpression it = firLiteralExpression4 = firLiteralExpression3;
            boolean bl = false;
            this.constantCache.put(callableId, it);
            firLiteralExpression = firLiteralExpression4;
        } else {
            firLiteralExpression = null;
        }
        return firLiteralExpression;
    }
}

