/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.SerializationPluginMetadataExtensions;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.ProtoBufUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BitEncoding;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ClassMapperLite;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmFlags;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMemberSignature;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.serialization.JvmStringTable;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.protobuf.MessageLite;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J/\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0015J5\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J/\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0015J5\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u001a\u001a\u00020\r*\u00020\u001b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\n $*\u0004\u0018\u00010\u00140\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J \u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J \u0010,\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020-2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J*\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010'\u001a\u0002002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u00101\u001a\u000202J\u001a\u00103\u001a\u0004\u0018\u00010\t2\u0006\u00104\u001a\u0002052\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u00106\u001a\u0002022\u0006\u0010'\u001a\u000200H\u0007J\u0010\u00107\u001a\u0002022\u0006\u0010'\u001a\u00020\u000eH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmProtoBufUtil;", "", "<init>", "()V", "EXTENSION_REGISTRY", "Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "getEXTENSION_REGISTRY", "()Lorg/jetbrains/kotlin/protobuf/ExtensionRegistryLite;", "PLATFORM_TYPE_ID", "", "DEFAULT_MODULE_NAME", "readClassDataFrom", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "data", "", "strings", "([Ljava/lang/String;[Ljava/lang/String;)Lkotlin/Pair;", "bytes", "", "([B[Ljava/lang/String;)Lkotlin/Pair;", "readPackageDataFrom", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "readFunctionDataFrom", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "readNameResolver", "Ljava/io/InputStream;", "(Ljava/io/InputStream;[Ljava/lang/String;)Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "writeData", "message", "Lorg/jetbrains/kotlin/protobuf/MessageLite;", "stringTable", "Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "(Lorg/jetbrains/kotlin/protobuf/MessageLite;Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;)[Ljava/lang/String;", "writeDataBytes", "kotlin.jvm.PlatformType", "getJvmMethodSignature", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMemberSignature$Method;", "proto", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "getJvmConstructorSignature", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "getJvmFieldSignature", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmMemberSignature$Field;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "requireHasFieldFlag", "", "mapTypeDefault", "type", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type;", "isMovedFromInterfaceCompanion", "isNewPlaceForBodyGeneration", "metadata.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmProtoBufUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmProtoBufUtil.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/JvmProtoBufUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1586#2:147\n1661#2,3:148\n1586#2:151\n1661#2,3:152\n1586#2:155\n1661#2,3:156\n*S KotlinDebug\n*F\n+ 1 JvmProtoBufUtil.kt\norg/jetbrains/kotlin/metadata/jvm/deserialization/JvmProtoBufUtil\n*L\n84#1:147\n84#1:148,3\n86#1:151\n86#1:152,3\n108#1:155\n108#1:156,3\n*E\n"})
public final class JvmProtoBufUtil {
    @NotNull
    public static final JvmProtoBufUtil INSTANCE;
    @NotNull
    private static final ExtensionRegistryLite EXTENSION_REGISTRY;
    @NotNull
    public static final String PLATFORM_TYPE_ID = "kotlin.jvm.PlatformType";
    @NotNull
    public static final String DEFAULT_MODULE_NAME = "main";

    private JvmProtoBufUtil() {
    }

    @NotNull
    public final ExtensionRegistryLite getEXTENSION_REGISTRY() {
        return EXTENSION_REGISTRY;
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(@NotNull String[] data, @NotNull String[] strings2) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(strings2, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data);
        Intrinsics.checkNotNullExpressionValue(byArray, "decodeBytes(...)");
        return JvmProtoBufUtil.readClassDataFrom(byArray, strings2);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Class> readClassDataFrom(@NotNull byte[] bytes, @NotNull String[] strings2) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Intrinsics.checkNotNullParameter(strings2, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new Pair<JvmNameResolver, ProtoBuf.Class>(INSTANCE.readNameResolver(input, strings2), ProtoBuf.Class.parseFrom(input, EXTENSION_REGISTRY));
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(@NotNull String[] data, @NotNull String[] strings2) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(strings2, "strings");
        byte[] byArray = BitEncoding.decodeBytes(data);
        Intrinsics.checkNotNullExpressionValue(byArray, "decodeBytes(...)");
        return JvmProtoBufUtil.readPackageDataFrom(byArray, strings2);
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Package> readPackageDataFrom(@NotNull byte[] bytes, @NotNull String[] strings2) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Intrinsics.checkNotNullParameter(strings2, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        return new Pair<JvmNameResolver, ProtoBuf.Package>(INSTANCE.readNameResolver(input, strings2), ProtoBuf.Package.parseFrom(input, EXTENSION_REGISTRY));
    }

    @JvmStatic
    @NotNull
    public static final Pair<JvmNameResolver, ProtoBuf.Function> readFunctionDataFrom(@NotNull String[] data, @NotNull String[] strings2) {
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(strings2, "strings");
        ByteArrayInputStream input = new ByteArrayInputStream(BitEncoding.decodeBytes(data));
        return new Pair<JvmNameResolver, ProtoBuf.Function>(INSTANCE.readNameResolver(input, strings2), ProtoBuf.Function.parseFrom(input, EXTENSION_REGISTRY));
    }

    private final JvmNameResolver readNameResolver(InputStream $this$readNameResolver, String[] strings2) {
        JvmProtoBuf.StringTableTypes stringTableTypes = JvmProtoBuf.StringTableTypes.parseDelimitedFrom($this$readNameResolver, EXTENSION_REGISTRY);
        Intrinsics.checkNotNullExpressionValue(stringTableTypes, "parseDelimitedFrom(...)");
        return new JvmNameResolver(stringTableTypes, strings2);
    }

    @JvmStatic
    @NotNull
    public static final String[] writeData(@NotNull MessageLite message2, @NotNull JvmStringTable stringTable2) {
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        String[] stringArray = BitEncoding.encodeBytes(JvmProtoBufUtil.writeDataBytes(stringTable2, message2));
        Intrinsics.checkNotNullExpressionValue(stringArray, "encodeBytes(...)");
        return stringArray;
    }

    @JvmStatic
    public static final byte[] writeDataBytes(@NotNull JvmStringTable stringTable2, @NotNull MessageLite message2) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        Intrinsics.checkNotNullParameter(message2, "message");
        ByteArrayOutputStream $this$writeDataBytes_u24lambda_u240 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        stringTable2.serializeTo($this$writeDataBytes_u24lambda_u240);
        message2.writeTo($this$writeDataBytes_u24lambda_u240);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JvmMemberSignature.Method getJvmMethodSignature(@NotNull ProtoBuf.Function proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        int name2;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Function, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.methodSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "methodSignature");
        JvmProtoBuf.JvmMethodSignature signature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        int n2 = name2 = signature != null && signature.hasName() ? signature.getName() : proto.getName();
        if (signature != null && signature.hasDesc()) {
            string = nameResolver.getString(signature.getDesc());
        } else {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            Collection collection = CollectionsKt.listOfNotNull(ProtoTypeTableUtilKt.receiverType(proto, typeTable));
            List<ProtoBuf.ValueParameter> list = proto.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameterList(...)");
            Iterable iterable = list;
            Collection collection2 = collection;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                ProtoBuf.ValueParameter valueParameter2 = (ProtoBuf.ValueParameter)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                collection3.add(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable));
            }
            List parameterTypes = CollectionsKt.plus(collection2, (Iterable)((List)destination$iv$iv));
            Iterable $this$map$iv2 = parameterTypes;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.Type bl = (ProtoBuf.Type)item$iv$iv;
                collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string2 = INSTANCE.mapTypeDefault((ProtoBuf.Type)it, nameResolver);
                if (string2 == null) {
                    return null;
                }
                collection2.add(string2);
            }
            List parametersDesc = (List)destination$iv$iv2;
            String string3 = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string3 == null) {
                return null;
            }
            String returnTypeDesc = string3;
            string = CollectionsKt.joinToString$default(parametersDesc, "", "(", ")", 0, null, null, 56, null) + returnTypeDesc;
        }
        String desc = string;
        return new JvmMemberSignature.Method(nameResolver.getString(name2), desc);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final JvmMemberSignature.Method getJvmConstructorSignature(@NotNull ProtoBuf.Constructor proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        String string;
        String name2;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Constructor, JvmProtoBuf.JvmMethodSignature> generatedExtension = JvmProtoBuf.constructorSignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "constructorSignature");
        JvmProtoBuf.JvmMethodSignature signature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        String string2 = name2 = signature != null && signature.hasName() ? nameResolver.getString(signature.getName()) : "<init>";
        if (signature != null && signature.hasDesc()) {
            string = nameResolver.getString(signature.getDesc());
        } else {
            void $this$mapTo$iv$iv;
            List<ProtoBuf.ValueParameter> list = proto.getValueParameterList();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameterList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtoBuf.ValueParameter valueParameter2 = (ProtoBuf.ValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                String string3 = INSTANCE.mapTypeDefault(ProtoTypeTableUtilKt.type((ProtoBuf.ValueParameter)it, typeTable), nameResolver);
                if (string3 == null) {
                    return null;
                }
                collection.add(string3);
            }
            string = CollectionsKt.joinToString$default((List)destination$iv$iv, "", "(", ")V", 0, null, null, 56, null);
        }
        String desc = string;
        return new JvmMemberSignature.Method(name2, desc);
    }

    @Nullable
    public final JvmMemberSignature.Field getJvmFieldSignature(@NotNull ProtoBuf.Property proto, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable, boolean requireHasFieldFlag) {
        String string;
        int name2;
        JvmProtoBuf.JvmFieldSignature field;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        GeneratedMessageLite.ExtendableMessage extendableMessage = proto;
        GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
        Intrinsics.checkNotNullExpressionValue(generatedExtension, "propertySignature");
        JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
        if (jvmPropertySignature == null) {
            return null;
        }
        JvmProtoBuf.JvmPropertySignature signature = jvmPropertySignature;
        JvmProtoBuf.JvmFieldSignature jvmFieldSignature = field = signature.hasField() ? signature.getField() : null;
        if (field == null && requireHasFieldFlag) {
            return null;
        }
        int n2 = name2 = field != null && field.hasName() ? field.getName() : proto.getName();
        if (field != null && field.hasDesc()) {
            string = nameResolver.getString(field.getDesc());
        } else {
            string = this.mapTypeDefault(ProtoTypeTableUtilKt.returnType(proto, typeTable), nameResolver);
            if (string == null) {
                return null;
            }
        }
        String desc = string;
        return new JvmMemberSignature.Field(nameResolver.getString(name2), desc);
    }

    public static /* synthetic */ JvmMemberSignature.Field getJvmFieldSignature$default(JvmProtoBufUtil jvmProtoBufUtil, ProtoBuf.Property property2, NameResolver nameResolver, TypeTable typeTable, boolean bl, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        return jvmProtoBufUtil.getJvmFieldSignature(property2, nameResolver, typeTable, bl);
    }

    private final String mapTypeDefault(ProtoBuf.Type type, NameResolver nameResolver) {
        return type.hasClassName() ? ClassMapperLite.mapClass(nameResolver.getQualifiedClassName(type.getClassName())) : null;
    }

    @JvmStatic
    public static final boolean isMovedFromInterfaceCompanion(@NotNull ProtoBuf.Property proto) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Flags.BooleanFlagField booleanFlagField = JvmFlags.INSTANCE.getIS_MOVED_FROM_INTERFACE_COMPANION();
        Integer n2 = proto.getExtension(JvmProtoBuf.flags);
        Intrinsics.checkNotNullExpressionValue(n2, "getExtension(...)");
        Boolean bl = booleanFlagField.get(((Number)n2).intValue());
        Intrinsics.checkNotNullExpressionValue(bl, "get(...)");
        return bl;
    }

    @JvmStatic
    public static final boolean isNewPlaceForBodyGeneration(@NotNull ProtoBuf.Class proto) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Flags.BooleanFlagField booleanFlagField = JvmFlags.INSTANCE.getIS_COMPILED_IN_JVM_DEFAULT_MODE();
        Integer n2 = proto.getExtension(JvmProtoBuf.jvmClassFlags);
        Intrinsics.checkNotNullExpressionValue(n2, "getExtension(...)");
        Boolean bl = booleanFlagField.get(((Number)n2).intValue());
        Intrinsics.checkNotNullExpressionValue(bl, "get(...)");
        return bl;
    }

    static {
        ExtensionRegistryLite extensionRegistryLite;
        INSTANCE = new JvmProtoBufUtil();
        ExtensionRegistryLite $this$EXTENSION_REGISTRY_u24lambda_u240 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
        boolean bl = false;
        JvmProtoBuf.registerAllExtensions($this$EXTENSION_REGISTRY_u24lambda_u240);
        SerializationPluginMetadataExtensions.registerAllExtensions($this$EXTENSION_REGISTRY_u24lambda_u240);
        ExtensionRegistryLite extensionRegistryLite2 = extensionRegistryLite;
        Intrinsics.checkNotNullExpressionValue(extensionRegistryLite2, "apply(...)");
        EXTENSION_REGISTRY = extensionRegistryLite2;
    }
}

