/*
 * Copyright (c) 2014, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * Defines the Java Naming and Directory Interface (JNDI) API.
 * <p>
 * Common standard JNDI environment properties that may be supported
 * by JNDI providers are defined and documented in
 * {@link javax.naming.Context}. Specific JNDI provider implementations
 * may also support other environment properties, which are specific
 * to their implementation.
 *
 * @implNote
 * The following implementation specific properties are supported by the
 * default LDAP Naming Service Provider implementation in the JDK:
 * <ul>
 *     <li>{@code java.naming.ldap.factory.socket}:
 *         <br>The value of this environment property specifies the fully
 *         qualified class name of the socket factory used by the LDAP provider.
 *         This class must implement the {@link javax.net.SocketFactory} abstract class
 *         and provide an implementation of the static "getDefault()" method that
 *         returns an instance of the socket factory. By default the environment
 *         property is not set.
 *     </li>
 *     <li>{@code com.sun.jndi.ldap.connect.timeout}:
 *         <br>The value of this environment property is the string representation
 *         of an integer specifying the connection timeout in milliseconds.
 *         If the LDAP provider cannot establish a connection within that period,
 *         it aborts the connection attempt.
 *         The integer should be greater than zero. An integer less than
 *         or equal to zero means to use the network protocol's (i.e., TCP's)
 *         timeout value.
 *         <br> If this property is not specified, the default is to wait
 *         for the connection to be established or until the underlying
 *         network times out.
 *         <br> If a custom socket factory is provided via environment property
 *         {@code java.naming.ldap.factory.socket} and unconnected sockets
 *         are not supported, the specified timeout is ignored
 *         and the provider behaves as if no connection timeout was set.
 *     </li>
 *     <li>{@code com.sun.jndi.ldap.read.timeout}:
 *         <br>The value of this property is the string representation
 *         of an integer specifying the read timeout in milliseconds
 *         for LDAP operations. If the LDAP provider cannot get a LDAP
 *         response within that period, it aborts the read attempt. The
 *         integer should be greater than zero. An integer less than or
 *         equal to zero means no read timeout is specified which is equivalent
 *         to waiting for the response infinitely until it is received.
 *         <br>If this property is not specified, the default is to wait
 *         for the response until it is received.
 *     </li>
 *     <li>{@code com.sun.jndi.ldap.tls.cbtype}:
 *         <br>The value of this property is the string representing the TLS
 *         Channel Binding type required for an LDAP connection over SSL/TLS.
 *         Possible value is :
 *         <ul>
 *             <li>"tls-server-end-point" - Channel Binding data is created on
 *                 the basis of the TLS server certificate.
 *             </li>
 *         </ul>
 *         <br>"tls-unique" TLS Channel Binding type is specified in RFC-5929
 *         but not supported.
 *         <br>If this property is not specified, the client does not send
 *         channel binding information to the server.
 *     </li>
 * </ul>
 *
 * @moduleGraph
 * @since 9
 */
module java.naming {
    requires java.security.sasl;

    exports javax.naming;
    exports javax.naming.directory;
    exports javax.naming.event;
    exports javax.naming.ldap;
    exports javax.naming.spi;

    exports com.sun.jndi.toolkit.ctx to
        jdk.naming.dns;
    exports com.sun.jndi.toolkit.url to
        jdk.naming.dns,
        jdk.naming.rmi;
    exports com.sun.jndi.ldap to
        jdk.naming.ldap;

    uses javax.naming.ldap.StartTlsResponse;
    uses javax.naming.spi.InitialContextFactory;

    provides java.security.Provider with
        sun.security.provider.certpath.ldap.JdkLDAP;
}
