/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpamComplianceStatus {
    COMPLIANT("compliant"),
    NONCOMPLIANT("noncompliant"),
    UNMANAGED("unmanaged"),
    IGNORED("ignored"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpamComplianceStatus> VALUE_MAP;
    private final String value;

    private IpamComplianceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpamComplianceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpamComplianceStatus> knownValues() {
        EnumSet<IpamComplianceStatus> knownValues = EnumSet.allOf(IpamComplianceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpamComplianceStatus.class, IpamComplianceStatus::toString);
    }
}

