/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats.otel.counters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.stats.otel.metrics.MetricType;
import org.opensearch.telemetry.metrics.Counter;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public abstract class AbstractMLMetricsCounter<T extends Enum<T>> {
    @Generated
    private static final Logger log = LogManager.getLogger(AbstractMLMetricsCounter.class);
    private static final String PREFIX = "ml.commons.";
    private static final String UNIT = "1";
    private static final String CLUSTER_NAME_TAG = "cluster_name";
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    protected final String clusterName;
    protected final MetricsRegistry metricsRegistry;
    protected final Map<T, Counter> metricCounterMap;
    protected final Map<T, Histogram> metricHistogramMap;

    protected AbstractMLMetricsCounter(String clusterName, MetricsRegistry metricsRegistry, Class<T> metricClass, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterName = clusterName;
        this.metricsRegistry = metricsRegistry;
        this.metricCounterMap = new ConcurrentHashMap<T, Counter>();
        this.metricHistogramMap = new ConcurrentHashMap<T, Histogram>();
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        Stream.of((Enum[])metricClass.getEnumConstants()).forEach(metric -> {
            if (this.getMetricType(metric) == MetricType.COUNTER) {
                this.metricCounterMap.computeIfAbsent(metric, this::createMetricCounter);
            } else if (this.getMetricType(metric) == MetricType.HISTOGRAM) {
                this.metricHistogramMap.computeIfAbsent(metric, this::createMetricHistogram);
            }
        });
    }

    public void incrementCounter(T metric) {
        this.incrementCounter(metric, null);
    }

    public void incrementCounter(T metric, Tags customTags) {
        if (!this.mlFeatureEnabledSetting.isMetricCollectionEnabled()) {
            return;
        }
        Counter counter = this.metricCounterMap.computeIfAbsent(metric, this::createMetricCounter);
        Tags metricsTags = (customTags == null ? Tags.create() : customTags).addTag(CLUSTER_NAME_TAG, this.clusterName);
        counter.add(1.0, metricsTags);
    }

    public void recordHistogram(T metric, double value) {
        this.recordHistogram(metric, value, null);
    }

    public void recordHistogram(T metric, double value, Tags customTags) {
        if (!this.mlFeatureEnabledSetting.isMetricCollectionEnabled()) {
            return;
        }
        Histogram histogram = this.metricHistogramMap.computeIfAbsent(metric, this::createMetricHistogram);
        Tags metricsTags = (customTags == null ? Tags.create() : customTags).addTag(CLUSTER_NAME_TAG, this.clusterName);
        histogram.record(value, metricsTags);
    }

    private Counter createMetricCounter(T metric) {
        return this.metricsRegistry.createCounter(PREFIX + ((Enum)metric).name(), this.getMetricDescription(metric), UNIT);
    }

    private Histogram createMetricHistogram(T metric) {
        return this.metricsRegistry.createHistogram(PREFIX + ((Enum)metric).name(), this.getMetricDescription(metric), UNIT);
    }

    protected abstract String getMetricDescription(T var1);

    protected abstract MetricType getMetricType(T var1);
}

