/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FieldMapping
implements PlainJsonSerializable {
    private final String fullName;
    private final Map<String, Property> mapping;
    public static final JsonpDeserializer<FieldMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldMapping::setupFieldMappingDeserializer);

    private FieldMapping(Builder builder) {
        this.fullName = ApiTypeHelper.requireNonNull(builder.fullName, this, "fullName");
        this.mapping = ApiTypeHelper.unmodifiableRequired(builder.mapping, (Object)this, "mapping");
    }

    public static FieldMapping of(Function<Builder, ObjectBuilder<FieldMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String fullName() {
        return this.fullName;
    }

    public final Map<String, Property> mapping() {
        return this.mapping;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("full_name");
        generator.write(this.fullName);
        if (ApiTypeHelper.isDefined(this.mapping)) {
            generator.writeKey("mapping");
            generator.writeStartObject();
            for (Map.Entry<String, Property> item0 : this.mapping.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupFieldMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(Builder::mapping, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "mapping");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldMapping> {
        private String fullName;
        private Map<String, Property> mapping;

        public final Builder fullName(String value) {
            this.fullName = value;
            return this;
        }

        public final Builder mapping(Map<String, Property> map) {
            this.mapping = Builder._mapPutAll(this.mapping, map);
            return this;
        }

        public final Builder mapping(String key, Property value) {
            this.mapping = Builder._mapPut(this.mapping, key, value);
            return this;
        }

        public final Builder mapping(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.mapping(key, fn.apply(new Property.Builder()).build());
        }

        @Override
        public FieldMapping build() {
            this._checkSingleUse();
            return new FieldMapping(this);
        }
    }
}

