/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.csv;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import com.oracle.labs.mlrg.olcut.provenance.primitives.CharProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.HashProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.URLProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.tribuo.DataSource;
import org.tribuo.MutableDataset;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.data.columnar.FieldProcessor;
import org.tribuo.data.columnar.RowProcessor;
import org.tribuo.data.columnar.processors.field.DoubleFieldProcessor;
import org.tribuo.data.columnar.processors.response.FieldResponseProcessor;
import org.tribuo.data.csv.CSVDataSource;
import org.tribuo.data.csv.CSVIterator;
import org.tribuo.provenance.DataSourceProvenance;
import org.tribuo.provenance.OutputFactoryProvenance;

public class CSVLoader<T extends Output<T>> {
    private static final Logger logger = Logger.getLogger(CSVLoader.class.getName());
    private final char separator;
    private final char quote;
    private final OutputFactory<T> outputFactory;

    public CSVLoader(char separator, char quote, OutputFactory<T> outputFactory) {
        this.separator = separator;
        this.quote = quote;
        this.outputFactory = outputFactory;
    }

    public CSVLoader(char separator, OutputFactory<T> outputFactory) {
        this(separator, '\"', outputFactory);
    }

    public CSVLoader(OutputFactory<T> outputFactory) {
        this(',', '\"', outputFactory);
    }

    public MutableDataset<T> load(Path csvPath, String responseName) throws IOException {
        return new MutableDataset(this.loadDataSource(csvPath, responseName));
    }

    public MutableDataset<T> load(Path csvPath, String responseName, String[] header) throws IOException {
        return new MutableDataset(this.loadDataSource(csvPath, responseName, header));
    }

    public MutableDataset<T> load(Path csvPath, Set<String> responseNames) throws IOException {
        return new MutableDataset(this.loadDataSource(csvPath, responseNames));
    }

    public MutableDataset<T> load(Path csvPath, Set<String> responseNames, String[] header) throws IOException {
        return new MutableDataset(this.loadDataSource(csvPath, responseNames, header));
    }

    public DataSource<T> loadDataSource(Path csvPath, String responseName) throws IOException {
        return this.loadDataSource(csvPath, Collections.singleton(responseName));
    }

    public DataSource<T> loadDataSource(URL csvPath, String responseName) throws IOException {
        return this.loadDataSource(csvPath, Collections.singleton(responseName));
    }

    public DataSource<T> loadDataSource(Path csvPath, String responseName, String[] header) throws IOException {
        return this.loadDataSource(csvPath, Collections.singleton(responseName), header);
    }

    public DataSource<T> loadDataSource(URL csvPath, String responseName, String[] header) throws IOException {
        return this.loadDataSource(csvPath, Collections.singleton(responseName), header);
    }

    public DataSource<T> loadDataSource(Path csvPath, Set<String> responseNames) throws IOException {
        return this.loadDataSource(csvPath, responseNames, null);
    }

    public DataSource<T> loadDataSource(URL csvPath, Set<String> responseNames) throws IOException {
        return this.loadDataSource(csvPath, responseNames, null);
    }

    public DataSource<T> loadDataSource(Path csvPath, Set<String> responseNames, String[] header) throws IOException {
        return this.loadDataSource(csvPath.toUri().toURL(), responseNames, header);
    }

    public DataSource<T> loadDataSource(URL csvPath, Set<String> responseNames, String[] header) throws IOException {
        URI csvURI;
        List<Object> headers = header == null || header.length == 0 ? Collections.emptyList() : Arrays.asList(header);
        try {
            Throwable throwable = null;
            try (CSVIterator itr = new CSVIterator(csvPath.toURI(), this.separator, this.quote);){
                List<String> list = itr.getFields();
                if (list.isEmpty() && headers.isEmpty()) {
                    throw new IllegalArgumentException("Failed to read headers from CSV, and none were supplied.");
                }
                if (headers.size() != 0) {
                    if (list.size() != headers.size()) {
                        throw new IllegalArgumentException("The csv contains " + list.size() + " fields, but only " + headers.size() + " headers were supplied.");
                    }
                } else {
                    headers = list;
                }
                csvURI = csvPath.toURI();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (URISyntaxException e) {
            throw new FileNotFoundException("Failed to read from URL '" + csvPath + "' as it could not be converted to a URI");
        }
        if (responseNames.isEmpty()) {
            throw new IllegalArgumentException("At least one response name must be specified, but responseNames is empty.");
        }
        if (!headers.containsAll(responseNames)) {
            for (String string : responseNames) {
                if (headers.contains(string)) continue;
                throw new IllegalArgumentException(String.format("Response %s not found in file %s", string, csvPath));
            }
        }
        HashMap<String, FieldProcessor> fieldProcessors = new HashMap<String, FieldProcessor>();
        for (String string : headers) {
            if (responseNames.contains(string)) continue;
            fieldProcessors.put(string, new DoubleFieldProcessor(string, true, true));
        }
        boolean bl = responseNames.size() > 1;
        FieldResponseProcessor<T> fieldResponseProcessor = new FieldResponseProcessor<T>(new ArrayList<String>(responseNames), Collections.nCopies(responseNames.size(), ""), this.outputFactory, bl, false);
        RowProcessor<T> rowProcessor = new RowProcessor<T>(fieldResponseProcessor, fieldProcessors);
        if (header != null) {
            return new CSVDataSource<T>(csvURI, rowProcessor, true, this.separator, this.quote, headers);
        }
        return new CSVDataSource<T>(csvURI, rowProcessor, true, this.separator, this.quote);
    }

    @Deprecated
    public static final class CSVLoaderProvenance
    implements DataSourceProvenance {
        private static final long serialVersionUID = 1L;
        private static final String RESPONSE_NAME = "response-name";
        private static final String SEP_PROV = "separator";
        private static final String QUOTE_PROV = "quote";
        private static final String PATH = "path";
        private final StringProvenance className;
        private final OutputFactoryProvenance factoryProvenance;
        private final StringProvenance responseName;
        private final CharProvenance separator;
        private final CharProvenance quote;
        private final URLProvenance path;
        private final DateTimeProvenance fileModifiedTime;
        private final HashProvenance sha256Hash;

        CSVLoaderProvenance(URL path, OutputFactoryProvenance factoryProvenance, String responseName, char separator, char quote) {
            this.className = new StringProvenance("class-name", CSVLoader.class.getName());
            this.factoryProvenance = factoryProvenance;
            this.responseName = new StringProvenance(RESPONSE_NAME, responseName);
            this.separator = new CharProvenance(SEP_PROV, separator);
            this.quote = new CharProvenance(QUOTE_PROV, quote);
            this.path = new URLProvenance(PATH, path);
            Optional time = ProvenanceUtil.getModifiedTime((URL)path);
            this.fileModifiedTime = time.map(offsetDateTime -> new DateTimeProvenance("file-modified-time", offsetDateTime)).orElseGet(() -> new DateTimeProvenance("file-modified-time", OffsetDateTime.MIN));
            this.sha256Hash = new HashProvenance(DEFAULT_HASH_TYPE, "resource-hash", ProvenanceUtil.hashResource((ProvenanceUtil.HashType)DEFAULT_HASH_TYPE, (URL)path));
        }

        public CSVLoaderProvenance(Map<String, Provenance> map) {
            this.className = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"class-name", StringProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.factoryProvenance = (OutputFactoryProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"outputFactory", OutputFactoryProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.responseName = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)RESPONSE_NAME, StringProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.separator = (CharProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)SEP_PROV, CharProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.quote = (CharProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)QUOTE_PROV, CharProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.path = (URLProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)PATH, URLProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.fileModifiedTime = (DateTimeProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"file-modified-time", DateTimeProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
            this.sha256Hash = (HashProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"resource-hash", HashProvenance.class, (String)CSVLoaderProvenance.class.getSimpleName());
        }

        public String getClassName() {
            return this.className.getValue();
        }

        public Iterator<Pair<String, Provenance>> iterator() {
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(new Pair((Object)"class-name", (Object)this.className));
            list.add(new Pair((Object)"outputFactory", (Object)this.factoryProvenance));
            list.add(new Pair((Object)RESPONSE_NAME, (Object)this.responseName));
            list.add(new Pair((Object)SEP_PROV, (Object)this.separator));
            list.add(new Pair((Object)QUOTE_PROV, (Object)this.quote));
            list.add(new Pair((Object)PATH, (Object)this.path));
            list.add(new Pair((Object)"file-modified-time", (Object)this.fileModifiedTime));
            list.add(new Pair((Object)"resource-hash", (Object)this.sha256Hash));
            return list.iterator();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CSVLoaderProvenance)) {
                return false;
            }
            CSVLoaderProvenance pairs = (CSVLoaderProvenance)o;
            return this.className.equals((Object)pairs.className) && this.factoryProvenance.equals(pairs.factoryProvenance) && this.responseName.equals((Object)pairs.responseName) && this.separator.equals((Object)pairs.separator) && this.quote.equals((Object)pairs.quote) && this.path.equals((Object)pairs.path) && this.fileModifiedTime.equals((Object)pairs.fileModifiedTime) && this.sha256Hash.equals((Object)pairs.sha256Hash);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.factoryProvenance, this.responseName, this.separator, this.quote, this.path, this.fileModifiedTime, this.sha256Hash);
        }

        public String toString() {
            return this.generateString("CSV");
        }
    }
}

