/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.syntax;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH$J&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u0005J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0014J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0005H\u0004J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0004J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J(\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0002J \u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0014H\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/testFramework/syntax/LexerTestCase;", "Lcom/intellij/testFramework/UsefulTestCase;", "<init>", "()V", "dirPath", "", "getDirPath", "()Ljava/lang/String;", "expectedFileExtension", "getExpectedFileExtension", "createLexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "doTest", "", "text", "expected", "lexer", "printTokens", "", "start", "", "getPathToTestDataFile", "extension", "doFileTest", "fileExt", "loadTestDataFile", "printSingleToken", "fileText", "tokenType", "Lcom/intellij/platform/syntax/SyntaxElementType;", "end", "getTokenText", "sequence", "Token", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nLexerTestCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LexerTestCase.kt\ncom/intellij/testFramework/syntax/LexerTestCase\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,80:1\n106#2:81\n78#2,22:82\n*S KotlinDebug\n*F\n+ 1 LexerTestCase.kt\ncom/intellij/testFramework/syntax/LexerTestCase\n*L\n53#1:81\n53#1:82,22\n*E\n"})
public abstract class LexerTestCase
extends UsefulTestCase {
    @NotNull
    protected abstract String getDirPath();

    @NotNull
    protected final String getExpectedFileExtension() {
        return ".txt";
    }

    @NotNull
    protected abstract Lexer createLexer();

    @JvmOverloads
    protected final void doTest(@NotNull String text, @Nullable String expected, @NotNull Lexer lexer) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        String result = this.printTokens(lexer, text, 0);
        if (expected != null) {
            UsefulTestCase.assertSameLines(expected, result);
        } else {
            UsefulTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result);
        }
    }

    public static /* synthetic */ void doTest$default(LexerTestCase lexerTestCase, String string, String string2, Lexer lexer, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTest");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            lexer = lexerTestCase.createLexer();
        }
        lexerTestCase.doTest(string, string2, lexer);
    }

    @NotNull
    protected final String printTokens(@NotNull Lexer lexer, @NotNull CharSequence text, int start) {
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.printTokens(text, start, lexer);
    }

    @NotNull
    protected String getPathToTestDataFile(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return IdeaTestExecutionPolicy.getHomePathWithPolicy() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
    }

    @NotNull
    protected final String printTokens(@NotNull String text, int start) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.printTokens(text, start, this.createLexer());
    }

    protected final void doFileTest(@NotNull String fileExt) {
        Intrinsics.checkNotNullParameter((Object)fileExt, (String)"fileExt");
        LexerTestCase.doTest$default(this, this.loadTestDataFile("." + fileExt), null, null, 6, null);
    }

    @NotNull
    protected final String loadTestDataFile(@NotNull String fileExt) {
        Intrinsics.checkNotNullParameter((Object)fileExt, (String)"fileExt");
        String fileName = this.getPathToTestDataFile(fileExt);
        try {
            String fileText;
            String string = FileUtil.loadFile((File)new File(fileName));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(...)");
            String $this$trim$iv = fileText = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = StringUtil.convertLineSeparators((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(...)");
            return string2;
        }
        catch (IOException e) {
            throw new IllegalStateException(("can't load file " + fileName + ": " + e.getMessage()).toString());
        }
    }

    private final String printTokens(CharSequence text, int start, Lexer lexer) {
        lexer.start(text, start, text.length());
        StringBuilder result = new StringBuilder();
        while (lexer.getTokenType() != null) {
            SyntaxElementType tokenType;
            result.append(this.printSingleToken(text, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String printSingleToken(CharSequence fileText, SyntaxElementType tokenType, int start, int end) {
        return tokenType + " ('" + this.getTokenText(fileText, start, end) + "')\n";
    }

    private final String getTokenText(CharSequence sequence, int start, int end) {
        String string = StringUtil.replace((String)((Object)sequence.subSequence(start, end)).toString(), (String)"\n", (String)"\\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        return string;
    }

    @JvmOverloads
    protected final void doTest(@NotNull String text, @Nullable String expected) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LexerTestCase.doTest$default(this, text, expected, null, 4, null);
    }

    @JvmOverloads
    protected final void doTest(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LexerTestCase.doTest$default(this, text, null, null, 6, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/testFramework/syntax/LexerTestCase$Token;", "", "type", "Lcom/intellij/platform/syntax/SyntaxElementType;", "start", "", "end", "<init>", "(Lcom/intellij/platform/syntax/SyntaxElementType;II)V", "getType", "()Lcom/intellij/platform/syntax/SyntaxElementType;", "getStart", "()I", "getEnd", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.testFramework"})
    public static final class Token {
        @NotNull
        private final SyntaxElementType type;
        private final int start;
        private final int end;

        public Token(@NotNull SyntaxElementType type, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.type = type;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final SyntaxElementType getType() {
            return this.type;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        @NotNull
        public final SyntaxElementType component1() {
            return this.type;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final Token copy(@NotNull SyntaxElementType type, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new Token(type, start, end);
        }

        public static /* synthetic */ Token copy$default(Token token, SyntaxElementType syntaxElementType, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                syntaxElementType = token.type;
            }
            if ((n3 & 2) != 0) {
                n = token.start;
            }
            if ((n3 & 4) != 0) {
                n2 = token.end;
            }
            return token.copy(syntaxElementType, n, n2);
        }

        @NotNull
        public String toString() {
            return "Token(type=" + this.type + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.end);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.type, (Object)token.type)) {
                return false;
            }
            if (this.start != token.start) {
                return false;
            }
            return this.end == token.end;
        }
    }
}

