/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.jetbrains.python.PyBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/packaging/ui/PyChooseRequirementsDialog;", "T", "", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "requirements", "", "presenter", "Lkotlin/Function1;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "myRequirementsChooser", "Lcom/intellij/ide/util/ElementsChooser;", "createCenterPanel", "Ljavax/swing/JComponent;", "markedElements", "getMarkedElements", "()Ljava/util/List;", "intellij.python.community.impl"})
public final class PyChooseRequirementsDialog<T>
extends DialogWrapper {
    @NotNull
    private final ElementsChooser<T> myRequirementsChooser;

    public PyChooseRequirementsDialog(@NotNull Project project, @NotNull List<? extends T> requirements, final @NotNull Function1<? super T, String> presenter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(requirements, (String)"requirements");
        Intrinsics.checkNotNullParameter(presenter, (String)"presenter");
        super(project, false);
        this.setTitle(PyBundle.message("python.packaging.choose.packages.to.install", new Object[0]));
        this.setOKButtonText(PyBundle.message("python.packaging.install", new Object[0]));
        this.myRequirementsChooser = new ElementsChooser<T>(){

            public String getItemText(T requirement) {
                Intrinsics.checkNotNullParameter(requirement, (String)"requirement");
                return (String)presenter.invoke(requirement);
            }
        };
        (this.myRequirementsChooser).setElements(requirements, true);
        (this.myRequirementsChooser).addElementsMarkListener(new ElementsChooser.ElementsMarkListener<T>(){

            public void elementMarkChanged(T element, boolean isMarked) {
                Intrinsics.checkNotNullParameter(element, (String)"element");
                this.setOKActionEnabled(!(myRequirementsChooser).getMarkedElements().isEmpty());
            }
        });
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setPreferredSize(new Dimension(400, 300));
        JBLabel label = new JBLabel(PyBundle.message("choose.packages.to.install", new Object[0]));
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        panel2.add((Component)label, "North");
        panel2.add((Component)this.myRequirementsChooser, "Center");
        return panel2;
    }

    @NotNull
    public final List<T> getMarkedElements() {
        List list = this.myRequirementsChooser.getMarkedElements();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMarkedElements(...)");
        return list;
    }
}

