/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import org.assertj.core.util.Preconditions;

public class ArrayWrapperList
extends AbstractList<Object> {
    final Object array;

    public static ArrayWrapperList wrap(Object array) {
        if (array == null) {
            return null;
        }
        Preconditions.checkArgument(array.getClass().isArray(), "The object to wrap should be an array", new Object[0]);
        return new ArrayWrapperList(array);
    }

    ArrayWrapperList(Object array) {
        this.array = array;
    }

    @Override
    public Object get(int index) {
        this.checkIsInRange(index);
        return Array.get(this.array, index);
    }

    private void checkIsInRange(int index) {
        int size = this.size();
        if (index >= 0 && index < this.size()) {
            return;
        }
        String message = "Index should be between 0 and %d (inclusive) but was %d".formatted(size - 1, index);
        throw new IndexOutOfBoundsException(message);
    }

    @Override
    public int size() {
        return Array.getLength(this.array);
    }

    public Class<?> getComponentType() {
        return this.array.getClass().getComponentType();
    }
}

