/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang3.tuple.MutablePair;
import org.parosproxy.paros.Constant;

class AlertTagsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private List<MutablePair<String, String>> tags = new ArrayList<MutablePair<String, String>>();

    AlertTagsTableModel() {
    }

    public Map<String, String> getTags() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.tags.forEach(e -> result.put((String)e.getKey(), (String)e.getValue()));
        return result;
    }

    public void setTags(Map<String, String> tagsMap) {
        if (tagsMap != null) {
            this.tags = new ArrayList<MutablePair<String, String>>();
            tagsMap.forEach((key, value) -> this.tags.add((MutablePair<String, String>)MutablePair.of((Object)key, (Object)value)));
            this.fireTableDataChanged();
        }
    }

    public void addTag(String key, String value) {
        this.tags.add((MutablePair<String, String>)MutablePair.of((Object)key.trim(), (Object)value.trim()));
        this.fireTableRowsInserted(this.tags.size() - 1, this.tags.size() - 1);
    }

    public void deleteTags(int[] rows) {
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            this.tags.remove(rows[i]);
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.tags.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int col) {
        return col == 0 ? Constant.messages.getString("alert.tags.table.key") : Constant.messages.getString("alert.tags.table.value");
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0 || col < 0 || row >= this.tags.size()) {
            return null;
        }
        return col == 0 ? this.tags.get(row).getKey() : this.tags.get(row).getValue();
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        String valStr = val.toString().trim();
        if (row >= 0 && col >= 0 && row < this.tags.size()) {
            if (col == 0) {
                this.tags.get(row).setLeft((Object)valStr);
            } else {
                this.tags.get(row).setValue((Object)valStr);
            }
            this.fireTableCellUpdated(row, col);
        }
    }
}

