#!/bin/bash

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3 or later of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, see
# https://www.gnu.org/licenses/licenses/gpl-3.0.en.html.

if [ "$1" = "-h" ] || [ "$1" = "--help" ] ; then cat << EOF
usage  $(basename "$0") <file> ..
  Creates (if needed) a subdirectory "smd" and downloads smd there.
  If the project is already there, just updates it.
EOF
exit
fi

cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null || exit 1
WHERE="https://codeberg.org/api/v1/repos/johann1764/smd/raw/"
mkdir -p smd

wget -nv -P "smd" "${WHERE}smd.sh"
if [ -f smd/smd.sh.1 ] ; then
   if diff smd/smd.sh smd/smd.sh.1; then
      rm -f smd/smd.sh.1
   else
      mv -fv smd/smd.sh.1 smd/smd.sh
   fi
fi

wget -nv -P "smd" "${WHERE}smd.md"
if [ -f smd/smd.md.1 ] ; then
   if diff smd/smd.md smd/smd.md.1; then
      rm -f smd/smd.md.1
   else
      mv -fv smd/smd.md.1 smd/smd.md
   fi
fi

if [ ! -L smd/Readme.md ] ; then ln -s smd/smd.md smd/Readme.md; fi

chmod +x smd/smd.sh
