#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Bubbles the Cat
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250630.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='bubbles-the-cat'
GAME_NAME='Bubbles the Cat'

ARCHIVE_BASE_0_NAME='BubblesTheCat._v1016_Standalone.zip'
ARCHIVE_BASE_0_MD5='75c5130b47cd1bb4cf3f9f9d8239ba31'
ARCHIVE_BASE_0_SIZE='160000'
ARCHIVE_BASE_0_VERSION='1016-itch'
ARCHIVE_BASE_0_URL='https://teamcatsandbears.itch.io/bubbles-the-cat'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
BubblesTheCat.exe'
CONTENT_GAME_DATA_FILES='
data.win'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Local/BubblesTheCat'

APP_MAIN_EXE='BubblesTheCat.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

## Generate smaller icons from the provided 1024×1024 one
icon_source="$(package_path 'PKG_DATA')$(path_icons)/1024x1024/apps/$(game_id).png"
icon_destination_512="$(package_path 'PKG_DATA')$(path_icons)/512x512/apps/$(game_id).png"
icon_destination_256="$(package_path 'PKG_DATA')$(path_icons)/256x256/apps/$(game_id).png"
icon_destination_128="$(package_path 'PKG_DATA')$(path_icons)/128x128/apps/$(game_id).png"
icon_destination_64="$(package_path 'PKG_DATA')$(path_icons)/64x64/apps/$(game_id).png"
mkdir --parents \
	"$(dirname "$icon_destination_512")" \
	"$(dirname "$icon_destination_256")" \
	"$(dirname "$icon_destination_128")" \
	"$(dirname "$icon_destination_64")"
### -filter Point is used to preserve the pixel-art style.
convert "$icon_source" -resize 512 -filter Point "$icon_destination_512"
convert "$icon_source" -resize 256 -filter Point "$icon_destination_256"
convert "$icon_source" -resize 128 -filter Point "$icon_destination_128"
convert "$icon_source" -resize 64 -filter Point "$icon_destination_64"

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
