#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Lake Ridden
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240929.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='lake-ridden'
GAME_NAME='Lake Ridden'

ARCHIVE_BASE_1_NAME='setup_lake_ridden_1.7.1853_(64bit)_(45634).exe'
ARCHIVE_BASE_1_MD5='e5629cee62ab9e90c59a079697674fa4'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_SIZE='2700000'
ARCHIVE_BASE_1_VERSION='1.7.1853-gog45634'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/lake_ridden'

ARCHIVE_BASE_0_NAME='setup_lake_ridden_1.6.1526_(64bit)_(25884).exe'
ARCHIVE_BASE_0_MD5='12b62c3399e51b27b5f91d9276d1aabe'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='2100000'
ARCHIVE_BASE_0_VERSION='1.6.1526-gog25884'

UNITY3D_NAME='lakeridden'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/LocalLow/Midnight Hub/Lake Ridden'
WINE_REGEDIT_PERSISTENT_KEYS='
HKEY_CURRENT_USER\Software\Midnight Hub\Lake Ridden'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
