from __future__ import absolute_import, division, print_function
from wx.lib.embeddedimage import PyEmbeddedImage

# most of these are copied or derived from the Crystal Icons set
#   http://www.everaldo.com/crystal/
#   license: LGPL

advancedsettings = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAALK0lEQVRYhX2Xe3RV1Z3HP7/z"
    "uDfJzb03z5tAQl4QQgDRSCrUJSoPLSgtBkatwQKlPhYFfMy0nela43QGqbXSzlS0oyNaYXUq"
    "UwfFKRgEASkEURBmeBheEkISktwbQh735uZx79l7/rjhaelZa5+z1jn77N9nf3/f3z77yMN/"
    "8yDTZ8xY3tTYmD5y5MgVv3rpJS50dKC0RpRGG4JoDQgut4vHnnwCpRRaa+LxOEo5xB0H0aDR"
    "jCodjYrHicfj84pLih/xeX2jXW5XyFGyw3Fir6B1RGmFN9VLdiCAJSKF1fPnr7ZdNuv/8M73"
    "NNyltGpBg0KD0mhAa4WIICIYhoFSCtOyEGUAgtYax3GoP/PV9Nn3f3t7cUkxLreblJQU+qN9"
    "bNu2dXrp6NFHg8Hg5pbm8+Tl55ORkYk5fty47nC4Z8JtkyaV54/IzxAxnvr000+f145CoVBK"
    "gdYopbBtFxWVE9FodIIKrTWZWVl4UjyEwz23VVfP36MRLl68gGmZbPjjBtauffu5UCg0/dD+"
    "A6daW1rJycnB7/eRmZWFtaWmhi01NfPGjB3bWVk5MW3R9xfZpmm+OmrkyGXx2CBKaQwBjYFG"
    "Ee2NcvjIEZTWgCIajdLeFmIwNsDU6dO3jikvZ0tNDT6fj75oHxs2bHjugaoHVionzmf7Pp+l"
    "Rb4HVBvGkJoAIrCgen7Bu//17p/EMJk1c9bSc42N7yvHQZOYvVYOWunErNEICtC4XS6SU5Lo"
    "6Q4/9N1HHklLTk6muKgIyzDZW7uX9HRvd3NTEy0tbf+xcPHCmpKRJfNMy8TlduNy2Vjp/jQQ"
    "ECQMzKm6b/bjr77+2zem3HFH1e7du98HmSuGkNAc+vv7ifZGQQANtstGRPD6vKUu2wVA+bhx"
    "HDx4kMpJ3yASCa/2+fyrZ86aSXuonb179uzu6uzkeF0dH324BQMBSDiYhNnXPL10+eNahClT"
    "plQh1AwVAQDuJDelpaWkpfnxp/nx+7z4vKmkZaTlX+7jdlNUWExmZhbeVC9tbW1EIhH21tYy"
    "oqB4dv6IQgqLiigoLkqkAIYCiB5SgzefXrLkCQSmT5s6C/THWl+qBo1pCD5PKmleD9mZmWRl"
    "ZuJPTc0HON/czAvPr2Tlin/B40nmnm/dg6McLNPi0MFDGw1hQGuFUhqt9BUAYUhlffnOmuWP"
    "P/lkd08PM+6ZNgPkYxnqaMYUnScVrx5IYcUem9qDpygsLr7z9MmT7Pj4Y/bs2kWkN0Ltrt3k"
    "5Y/gwYce5oWf//z3pmXOFTEwjEQTMa5S4BLFVQwi8sYPF/9gdntbiHtnTJuhtd6KTpjWcITu"
    "uJ/OWAaRHjVroAdfOBKhZNQo7rj7TjoudDCisAgN5OfnE8jNuSUnJ4f6s2c4e7aehnMNNDY2"
    "YF2KrfXXOACNiHz4tz9c8sBr69Z9MG3a1Ht37Njx/oU+e66h4qBjOCHX8D/nfbcmvaOPstYQ"
    "wR4oLipi0eLH8Hg8rP/9f/YblqWr5y84I3IllkZjir7aA4JcFfpqFMH4nx8tXbpYOYq775pS"
    "le5XfxiWqelrVmWu9MD5aKebTa3lPL9Fk+2z6ejoGnhq2fLnFz766Ey3250cCARS4vF4VSwW"
    "IxaLEY/H0E4cUc5VHrjWAJcrQ4ZcKcjbS5/4/nxDhJnT76w+erh93s/Gd51osH/JkqZFuArz"
    "2NNWyuIVH6252HkxyWVb/2S77K2IEI+ra8Y2DbBNOBqUa6tA62vlT5zVkEAagXfmPfzU3Q3t"
    "8PK/Prph2Tc9nDp0koWDfWw4sQjnQuxYbp7xhG2aoKFgRAFaKbR2rpmYIcKxoMUzW11Y6d/5"
    "x8sPXjkYg4oFiGjcSS5ctk0KoLEIY9Klk+jaduRs/MWXcG16i96abbQohQ+oaGsiP759gs9f"
    "zO76bry2zaCAsl04tgvtdiN6SFMBV/Qs/R+9glQseZ3rjysAFnEEwaIfg9MN7m+sih3YP6eg"
    "n7MfbmZkVRVWYQFOMMiht35HNBa/238h+OckpYkDlmXQG1dYFgwfFeDSemaaQgPJzHbKrivD"
    "a72XeEGDFmg9pytzysr3f/XJOvavX8+pnm7Of7KD1HlzkdRUBrTmAmrXmezA1D7TxAH00EDK"
    "stC2BXbi6hgGRcYg2+0TNwDQV3EItDToyltvrzhwZscXrMpZyY6eXnwYBEpHsf22yfR//jm3"
    "P7WckWlpuDQ767OyPhg0TRzLTARQ15tbcIAcYn8dQAPnG/TE+2dPPrBr02Gclh5kXAWfrayn"
    "4a5n2bZ9p44O9FOzZw+qs5PKVasYl5+P1nrOicwMfS4jozImxtAacz0EKPjrKTjfoGc+OHfK"
    "F++9d4Tw8SakvIKy8VmkeS2e9Ve15F7sNpRh3OI3DXatW4fTFmTMql9yU04OpobgoHOgPjvr"
    "KwdQhnk9A/qGAIngk6dMn7zlj+9/Seu+OmT0RPLGBCgrTOWzfafRTXWVVYvXkxcKHY4o/dMB"
    "rfnkn3+GEwwx4bXXmJibS4pAv9Yjv0zL0O3JfkOuX+duBNDaoNNH3zxh357ac5zb/hmU3Iy/"
    "IJPK8Rkcrmujt7H+GavIaFVDI5aEgi+GtabNcaj9h78H2+am3/wb49LTSBKIa83R+nan7Vgr"
    "4YZudCSOLRa2WF8HaG3QRk7pmKazTf2c2X4AiifiyQswaWIO55q6aa2r2+IplpcRjdZCm6O4"
    "CHQ4TkmSCOcHBtn3SDVmIIdbf/vv3JIdIFkMokrxVSDQkthUXcmFEUvJI5aSh+kdhjdrOBkF"
    "xfUxK81zZts+CJSRlD+MiluH0d8X49T+I63+IrnvcgJF0JIYbGxHx1kD/jvLtjkZ6WHfnAew"
    "i0uoePddKnNzSBahU6lh9T7/5humoLlB77TS8gu/3FQL3hG4Rwyn/OZheJJs/vfTY6iulvHS"
    "HSKpr5OscBtZ4Vbk0idEoDgUfOhEfz9l/jSOh8Ps/dY9OF3dTFj7NpW5ubhFCMVi9zd6fEu/"
    "BtDaoN/MH1cxFWXgLR6NmZdH6fjh5Od6OLDvBIPB+mn+Irl4qX/0T88Q3vwjFvp9NIrQiHAI"
    "g3ODg8bx7m7GZ2VyKhxh58MPJYz5xhom5eZiIDS3R15tSkodDiDj/24TwQY9Z9io0g86LsRR"
    "jsPYsVmEo4r09CQO7j9D+Oyxn/oL4y8ahkF043LEMNBypSkEjfCLnu6Ekn6/jHa7VXl6Oic6"
    "Oxnuspny8mrM7CyOLVvO/tYWRvvSGNUXFan88WZaG/S+WHLB5NCx5m+/sfW+zb/+TYsOeODU"
    "6RCdp+vW+wv6qnveeQzTBst2/UUANbRRjzkOr0TCNKelU+Z26RKvl6ZIhEy3m9t/8QJGqpcz"
    "K1aQlp1NZl+fGD0dIaIdoQ5nYICC+7+5tG1A/2RUmZ/jJ7tpP7jzvdQiqe5+57G/VK03PJa5"
    "k3gx2sfwYFD2dnWtzTJNOgYGqP3xT9CxGDft3Yup1K/QGnHljCHeq8f4K545njVpFsWlGZz+"
    "v2Zadr5VG+h4fQqGTTDUZQpYpo1t2S5LDMPSYhhaDBlSQCnEURCPOU5cx2IxNPH0QLaOa5jW"
    "0f6DhRkZb3oMg4oFCxisqzsxdnNNOYBkumHAwSPJ2fc6/jueVlZGltF79AtX5NA2w3T5PCmu"
    "VAwjBTGTQJLFMEzEMBExNCJahMR/tCgFjgJHC31K6T6ldX9cEx1sa20tF7l1WWbGs4d6e9eu"
    "6e1dLRgXk0zzggXgNuk1k2WjBGSjShIICX09jiGq37zY3W9qLTYipohhI0P7aRESO4fEqpD4"
    "aUOpRItrkRgaB5G4TkrWw/v7NuYEg88VmCZuw8SQRAH+P6SkFWFFBULWAAAAAElFTkSuQmCC")

save_all = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAHmUlEQVRYhZ2XTYglVxXHf+dW"
    "1et+rz+ne/I9CdEoZqVonAgiiBoQJIuMC9GFK90oEiNuBiNGEzFCliGoqOBCxI0TYxwJ6Foi"
    "fgQTNMwIxsmM08nYrz+m+9WrqnvOuS5u9UcmY+LkwOXdV/Wqzrn/8z/nf57ccuzYu+/5+Cf/"
    "evbMGR588CT3fOyDjNfHmDnXaqPREAklD3z1QepJzerqCutrL91cVtVaQjBTVDsoV5gbJs68"
    "+DfKixcvynhjk63tLRaWFpmpBtx8003X7Pyw1XXD9vY2IoFTTz4pyACSAZETn/rcweESlCDt"
    "kSPL3HDDjWhUAMwTZnZNTkWgKksAipDfXpSBamYUi6KkaVu+8uX7+ee5MSRI/XNlUUjaubzD"
    "5uY2e6Cr2VtKQZX9Y+bEqGg0YjuxSOJb33yItUvrqClBCkhCSlCSwJMDTrIcV+winhJlOWBm"
    "Jr+17RRT5yD215s5hAC7kwmbm1uklIBUP/LIw2yMN6jrKRqVqgqAZAQQwVQxM7oe9i46RVnS"
    "ReU/G1vgiZSctmsx8/7FV6ZAGAwqiqKABEGgaRve/o47b3353Pl/7O7uVtOuC23nEopyCNJK"
    "kLqUlHB3zBw3wwBPiSPzM/zwxz/l5Mmvc9Mtxzh9+hTvuuM2duv6qgGAIEGYHQx45tc/P3zj"
    "7N7mlfVtvvDFBxjNzTGsCqqqlDIhqBnJDFVjGqHpOgxYH4+ZX5inEFhZXgZgfjR6czL8D5ud"
    "GTAejwEY1xP+8OzvKSUlVA2zmMmnCTUnGpRVxdGj1zG3sIDupaeznjNXN0H20ntwTYRBVdA0"
    "LaYZ6bIoQErKJIJb5oCqEbuIdo5FwIXtrS2qmRnMs1NLV+fAgaXX8VREgALViHv2Ze4ggRIB"
    "UyO5E81o1GhixzRGomkucHdUnQS0bXyTAF5vQYThTEUXM5nNHe8PVJLA3LCUmB3Oc2x1yPzc"
    "MZZnYX5pEcxwd1SNNia6qCS/xgCCEA1UI2aGm+GuSHJKESG5U1UVzzx1io31i7TTmrm5BV74"
    "y3PMjka4Z55Ec6LbtSPgQvREVMvwm2LuJAmUCbCkzM/P87vfPsNTvzyVYU/OyuoKR5ZXiG50"
    "asQYiZ2+pRTEqGiPpEUFEpISpQCqjidjefkIi8tLtE1EVQmhRPdSYEYX8/I+AHlDt9lSH0Db"
    "ZZK7W64oSaSUCAlwjZg76kpd1ywuzvPkL37Cifs+wXi8iUUjaiaimePquOW9mWN6xf7Qdz90"
    "PWrE+67r7iBCCVn5LEYS0LQdkHjnHW9jYWFE00yZG80SVWm7SNPFTELhjWSBwxCJSG5ufftQ"
    "NULI+5JEhtUyuSwqbdswHo+pdxvMEpYSS0sr3HZsgd3pSk5BYv8TnD1ayF5eJAtOkFwFS0PY"
    "nkz70yskEEm5CtwV1X4WMEXVmExqutgSCkFj5LHvPMz1N1xH27b7pwpFSRUKpAiIBISsrCkl"
    "3CLuWdoDwsxwhgvnLyAiiEiuAqBMJDR2mCkp0ZMkMpns0sUWEZiZGfCbp5+ma1tSyg0rhEAR"
    "CkIIhBAQERKJ1A8zKWWSiSSKUFEUOYjl5WU8pX0USpEgboapkoCoGQFVQ6PhyRCEI6tHsmRH"
    "ZVBUlFXB0tISIQTaLrK7s5PTIILgvXNBpCDGlrIsSeJ4gpSy+JESJcggM9Z66AxXo207TC2z"
    "2PMUs7m1xT0f/TCPPfoNXnzxLH/803NUVcHS4iLH776LelLjnoeBAIxGI7Z3dvnMZz9P6HtL"
    "SrC6epTYi1sZu+b5nZ0NpJzBY2RaT9gZlLRtR2eZ8apKcKdpGoogLC0v8fczZzl58iGK2Vnu"
    "et97+MDd76eeTlE1yjKQPCGAkChDSVlVVIOKne3NvrcYIJQAl7fWHwK+BJwD2q1xvfHEE48v"
    "nP/3+p0pcWNGJ4vWdFpzeXMLjcpgbsRoNKIsCrYvX2YymeTad0dEcvtWpeu6jExycKFru17S"
    "lQAwHA4ffvncv65fW1s7fuHC+Q9duvTKp5/61emP3HvvvT/b2ljvpTpiqmin7E5ruq7LM6ST"
    "lbTrmE4bJpMJdV3vr2Y6zc+64mp4P/q67qkhMJ1OufTqJe46fhwgAAawsrJckmosKlIK7kYb"
    "I9PJlKZpcFeiRmKMdF2H7p/WKYoCmxmg/ZwhogTJwQ4GFarxIACApmn2tg60AKdPn95ARpgr"
    "EgVzxSwSNVJPa6ybMgWapmZST5hOp/v/J1SVqiyRkPlgqljR60LbsNe59gO4sqvmKYbB6vW3"
    "4WYgoe/pSj2ZErsION5FohqTerqPgrsTQqAbVCSBGFtSKgmBXJ51jaq9NoBirzm/1n7UdfXX"
    "kgtdjKS4w8b6mLVX1rj99lt59LvfzsEivPrqpcyL/mQhhDxtuzHZ2chtuZwlhCJXlVyBQFVV"
    "h0++Zy/tbK0/DrwXuAB0z7/wZ/ve939wVBAdDodSVkWSHh0OKXRKKRUiNG07GM2NStyTaiRq"
    "I7guOzx74sR9BwGEorgaAgD3Hx5AUkpzKaUyhLAILAELwAgYAhUHOhmBBpj26zKwDey4e5NS"
    "oiiKgwD+n+ECqCRb1TtpyKRteuehXwDaB9GRSb332zKEUPX3+C/o5pPFQkg1SgAAAABJRU5E"
    "rkJggg==")

hkl_file = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAAXNSR0IArs4c6QAAAvpQTFRF"
    "Hh79////+Pj49fX19vb2+/v7/Pz88/Pz+fn5+vr68vLy/f398fHx9PT09/f3/v7+8PDw7+/v"
    "7u7u7e3t7Ozs6+vr0dHRycnJ2NjY6urqPT09/g8PPj4+PDw8/wAAurq6AAD/t7e3/h8f5+fn"
    "6enpubm5tra24ODgtLS0uLi4/S4uu7u7Pz8//u7utbW1vb290tLS/i8v5OTk6OjovLy85ubm"
    "9+fn39/f/R4e5eXl4eHh/T4+t7f3Dw/+4uLie3v64+Pj2dnZ/E1N9OTk+rq69eXl3t7e/k9P"
    "+MjI+2xs+Ojo/r6+/D09uLj4+0xM/h4elpb2PDz7/c3N/Ozs/b29/C0t+qqq+NjYLS38+oqK"
    "+4uL+urq/T09+nt7+3t79sbGior5+cnJ+bm59sfH/n5++np6+pqa9re3enr6/k5O+mpq/X19"
    "9tbWeXn409Pz/j8//y8v/Fxc+8vL9ubm+enppaX1/d3d/S0t+bq6+YmJ9dXV/G1t+ltb/6+v"
    "+YqK+5ub+Li4+7u7/j4++Kio+ampeHj4qan4/m5u/I2N+6ur/e3t+4yMyMj4/U5O/8/P/s7O"
    "97e3+mtr3g8P/Hx898fHPDz8pqb2/z8/+ImJh4f3iIj3+3x8/+/v/V5e/w8P+srKa2v6++vr"
    "+5yc96en/Z6etrb2/39//x8f+dnZXFz7+NnZ09PT+JiY/l9fPT394uLy95eXw8Pz/W5uu4uL"
    "+Xp63Nzc/9/f/Y6O2traubn53wAAx8f37i8v9cXF/K2t/5+f+svL5ub2vD09eXn5bD09/V1d"
    "vW5u+1tb/n9/iIj4vV1d/H19/i4uu5ub99fXuqqqPS0tbW1tTj8/Tx8f+IiI+ZmZxcX1qKj4"
    "7wAA/NzcS0v6/U1N1NTUzs7O0tLy/o6O19f3/ExM/19fuamp+JmZy8vL/F1duYmJ+9vbzLy8"
    "/L29/t7e+tra/09P/29vzMzMzc3N/IyM/p6evwAAPT38/Jyc/Z2d/4+P/Gxsl5eX+2trmZn4"
    "mZn5bm5uPGhEvQAAAAF0Uk5TAEDm2GYAAAABYktHRACIBR1IAAAACXBIWXMAAAsTAAALEwEA"
    "mpwYAAAAB3RJTUUH2QkZFSQ2/VuIhwAAAUhJREFUOMuN01FugkAQBmAQlhXYFbWapjGp0aiJ"
    "+tCY9GEO0QPMNXqVvvQQPVlv0WEW8Ify4Dzx8GX+2dklih6pdJrnxmRlWVVxXJVZPk29Wx7u"
    "IJkMhBFRLBGMCQdgNhCVCgQDEasAkA4F0d5MACQp/RNZ3gPppie+Y6oyAF4E9qB6jhKBiksj"
    "iMJZAFjyEjMjFXvpQXSLYwCFJVJBEyJNuUkKgJ/TaUe78/l4/Npur9f3X3qjCiNcwdZ/yBxh"
    "HxvSsyBgttYTBUE561kAsOOisN6/yhyfJD1qgXuYcw1EkKxDeliuJwVw7oq6L2MALBZz55z2"
    "SGx3cwCWIuatYG4EglbIpJwkQUwBPKlQYFkqpCBohaSw9xz2AWDVE+zDThG0oplD73YGYN2I"
    "Blh9Hz2wXvVSggDwMiYSAAcU3cbuwDyP1kM/fvQHQgcvwPJisBMAAAAASUVORK5CYII=")

hklview_2d = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AEQARABEUhLlYwAAAAlwSFlzAAALEgAACxIB0t1+/AAAAAd0SU1FB9sFBAAGFyYmfCoAAAOO"
    "SURBVFjD7ZfPS2NXFMc/9+VGfU4SJ3GmhKkZdKGZmkXoLlmUFmkR1MJshIGmKdKVDFOaf6AM"
    "hS5czsr+WJS+CAUz0BGSRTbCgG1c2DCBQiGKDkRoKxpmaiYZk+jrwuSZTBIVkzqbOZvc9+Xk"
    "nXO/55zvfRfe2Gs2AXDlsx/1wWt9lxr46e5zXvw0I6Tj87D+ze0POx6gWD5ie7eIVTUBsLae"
    "w6qauOHoAsD1Xjf3ZViXlq4env7zsqPBy4c6yY0cdz64zlo6x8c+B49+28OqmvjqExcW1cSX"
    "325i6epB/ps/JPHnfsd3XyzpDbi114SlwsjREeQPjhDWT3/W3X3v/C91tqomRgZUAH6vlKBa"
    "kv3CIWt//4EUQlDS8/Q5clzt7e54En/lj39vvH2CPcsf8DxvQQiBVAQI5YjHX3/UkYCpVIpU"
    "KoXX68Xr9bb0e/eLX1EEKEKANImO7VjTNMLhMJqmGdj6+jqzs7N1ftIkEAIURQjMbSSgaVpd"
    "sGY2PDzM/Px8HWY2CRQhkEKAlBdPIBgMNjxXS3CaSXnMgFQEbTGwt7cHQH9/PwCqqqKqKoVC"
    "gUKhgKqqpNNpUqkULpcLr9eLqqoVBkARQpy7BwKBAIFAoA5LJBIkEgnjORaLGWWpJtcMO+4B"
    "0T4DU1NTF/pflQEplPP3wMLCwpk+ExMTDAwM4HK5cDgcLTEpBUIB2c4UrKysEIvF8Hg8TE5O"
    "YrfbcbvduN3uOr9mWHUKWupANBolGo02NFy1htXaJpNJlpaWyGazBr61tUWpVDp9Ck50oHkC"
    "fr8fv99/asN5PB5sNhujo6PYbDYDX1xcZHt7uy6hubm5hgQUAQzefajPPHiiX8Sy2ay+sbGh"
    "7+zs6OVyuaVfsVjUNzc367CZB0/0wbsPdam0IcV2ux273X52x5vNDA0NNWVAES2aMB6PE4/H"
    "T31xOp0mEokAGMKzurpKJBIhnU6fOYaGDjRjIBwOG+vx8XFDiGrHMRaLsby8zPT0tNGcmqaR"
    "yWQYGxtjZGSk/kup9BJp7nmVgUYharbzWuwsZlp2fiX4CQMVHXhViKo7rl3XHi7VdSgUIhQK"
    "1Z0FwWCQTCZzrsPIOA2b9UBtEgBOpxOn09nyhap6/Onl8/nw+XznkmIhQO7m8nhvXufeD0l2"
    "9vOXcid4y9rL+7du8t3jJII73/9ypdt8e+ja1Uu9mGztPuPFQenRm7vha7f/APVHmKiUVF97"
    "AAAAAElFTkSuQmCC")

clear_left = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAA"
    "CXBIWXMAAAsSAAALEgHS3X78AAAAB3RJTUUH1AMODhoSqw5f4wAAAy5JREFUeJztlz1L7EAU"
    "ht+ZTPwqZBsFW1s7QdzehQhyBftVK3/D4t+wsPUPCBYXG1nsRbC3UMtsMhuTIETWNTkWcoZk"
    "s9Hs5V72Fg6EzEdy3mfOzDmTCCLCNIucqvoPwP8AoCZ9QQjx628IE9HviQGEEAQAS0tLo/11"
    "BE1da73L9doALH5/fw8hBCzLgmVZICLYtm1A0jSFUgpSfq5ulmWQUhqAw8NDXF1dGbu1AFj8"
    "7u4OSZJASgmllJn5YDCAlNKIDodDWJZlABg0yzKkaVqw/S0Ai19fX+Pl5QW2bYOIIKXEzMwM"
    "hBCQUhpBAJBSQgiBLMuMt4gIRIT39/f6ACx+fn6OOI6hlIJlWZBSwnEcdLtd01ZKmeUgIjSb"
    "Tdze3hpbVR6oDEMWPz09Rb/fRxAE5u44DgCg1WohiiKEYYgwDBHHMcIwRLPZBABsbGzg+fnZ"
    "9MdxjOFw+D0Aix8fH8PzPPi+j16vB6012u124dm9vT1oreF5HoIgwPb2dmHccRxorREEAbTW"
    "GAwGXwOweLvdhu/7cF0XruvC8zz0ej10Op0S8NHREbTWODg4KI2dnJxAaw2tNXzfx9vbW1Ev"
    "H58svrW1BcuyzJorpWDbtgk9pRTOzs7GOa9QOp0OlFLIsgxEhDRNcXFxgYeHh91SImLxtbU1"
    "BEFgdjbfGYbrOzs7uLy8rBTf3983YSmlRJZlAFBaApUXX1lZQRRFBWGu50F4t29ubuLm5qYk"
    "3mq1TChyEiIiCCHGAxCREEKQ67poNBpGkC82xHW+np6exs6+2+1ifX3dtNkTRFTaA2YJGCKK"
    "IiwsLBgRNsBGGKbf71e6H/jMmqurq+Yd9sBoGBYSEUMkSQLbtgsQ+XuSJCXBRqOBKIoKfY+P"
    "j1heXjZtPisqAfIQ+XyeNzA6AwCYm5uDEALz8/N4fX0tjPm+j8XFRdOudRYwRJqmhaOW83re"
    "iFLKjAGAbdsFyNnZ2YINjoYvAfIQ+TzB68hhxfsiDwjAQDJcfnz0K/zLw4ghRvoKYlXG85t2"
    "9N3aAFUQFc+V+sbNeCIPTApRB2q01P4qJqLvP/z+oIg6lP+yTP2/4Adg6gAfe1qwcw05VlEA"
    "AAAASUVORK5CYII=")

hklview_3d = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AAAAAAD/1EFU8gAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sGBhEXKt3aaDcAAAiY"
    "SURBVFjD7ZdZkFbVEcd/555777fN8s033zBssjtsijIwYhlFo4gQY5BoNC/G3QxGs0kCWknl"
    "qzxELFP6lJJYpBItU5VUhJQxkYioiAu7o2yyDOuwDLMwzHz7vefezsMMA6N5tOJLuuo8nFun"
    "u0//u/99+qrm5mZ5YeVKljQ388K3V7JkTTMrX1hP85J5/C9ELV26VPgKxU6n0wAsW7aM1tZW"
    "Vq9ePbhXSrFixQoAli9fBsCKFc98uReora0FoLW1lUmTJnF+r5RCRFi1ahUAMoDTqlW1X24K"
    "Xn311a80BaqiqUkqGvdS3B3Q+2Fp4KvCTtZhJxoRU0T3baNQKFykpbDcNJZTg5O4AmM+w/Ts"
    "R0L/c9YVzvgJxO4OcJqTsPky7PQzjD3+dUYs6KbYJqiGv02TyoXteAeg9Y4speMGCYaCEo/H"
    "h15gqBfi0x9Cyp2gNKVDryGhGXLCimvcxkqkM07iqgXMfPA10tfCkQ9Go6vmepnoNIu+tyYh"
    "DxapuzZKKguFzpDAF5RS2LaNMWYgKBtlaZBw0IHf+THi9SF+jsqm3+K3v4+yIkjYj6j4gjle"
    "IujOUtrVQrTaxa2zOLlnDMpJa6mZHyVojFA3TzFfQywF217WbMh0E9WRIdE7yRlYTjVBqROT"
    "3fdFPHQU7Q7HTszAnjqGmtS7jF94go6thn1/zIOAshTRtMaEEfR9NyQz298oIXnFpZM102bD"
    "e3vHsmd2I+6VdciGDrxCedBBWDqDeD0opwon1oiemES8MlIu9h8QQ2jOYQr7iU6YzazHtjBm"
    "sSLRUE1HeS7+iS7CfBGTDwkLPvqSn1Vluk4F9HyYg6Oa0Y1RNvnTYGYanXSRde2UTvcNiVJC"
    "j9DrQlQHlcufR5XKmMOHQIbm3mvbzsivuSTGKXbvuxP/sd+goy7BjmOExT5A0N3PDcsEo2qQ"
    "UyHdW/o4/K6HXwSrPoH7djesP0PgGYwxWJFKrHgN4uUHgvXwd2wkONiKHWsgcfsPCHvaICgh"
    "vg8CHZt9elqE7hYDtcMJNh6kYtHLWNEu4s2TUbUfXSnq8iTyZoLcr3ZS3tMGgK50UWUhNAGR"
    "SATLsrDrL8O5ZDaFs8co7Prn0EqPxKlY/Avspnqs6RM5e9ciwr7eL9SI5caJzb4Ld14ZZ/l1"
    "6MjMZMaKTEbPuQN3VgPea9sJS2XEC9CWJgiCQQZ4vacodh+jYvR0EuNvRks7GI/A95HAp7z7"
    "bayaKpRtow+OQgIfnY4ihRyE/ayRwMdv+wQlPs4Vo8GKa6n43tVS1/p7Gfb6ZkmvWivO6FEC"
    "iOM4Agwuy7LEdV1BKYlOvFFqXlotyUefkERVUuLxuMTj8cGzdkWDxOcskGGb2iT58/lS/VxS"
    "xkyPyzWxmIwasGtVREU7rp0pbj+O/48dRGbNR43xiP30flT7GYJ9hwjDEMtO4qaaUFVx/N4z"
    "uK5LcO4oksuhstXoGbfCdecwhTKR3gDHcdDSR+Dl0ZU2+ht/Z9opxdNv2DzoOCyMRPhMhLZC"
    "Caofv0zsWlcAUY4r6Xf+KvX5Q1Lz5GOitR6MyBk5TSpuWSruiDlD0FBOXCofuVFSB34i1S/e"
    "PgSxSCQiFckKGfXKKMlMHyHtqZSEqZQUUin5XTIpgOjKdRMzTjpGaW0XBAH+B9sItrbgrVmL"
    "n8tf4H+2E9O2k+j024je802CE234XZ24tiLsOIvlasJ1Bqc8H5NrASAwBq/kUdhYZE7B5vJo"
    "jIjjUHQcWnyfN0sldPyhqzK67fsEew8SnO0g7OnF33MA5RvCgcJRSgOCBB5B8TCRG29Be/VI"
    "bxa/9zQq52M2HqN04CB+toWam15EKYsgexjCACmEnAlCGpTCNoZ9xvBcENCnNdqxr8o4sx7A"
    "npJCeQX8w0f6aag1YRiiLBensonQ7wIxSKFAef1aLLuOyMwmovMW4u3fTFj2cWyHMAzwu3eB"
    "9JF6/C3w9+BcAV3ted7sK7AuCPhTscixUonQrkd7W/dkrEqPyA8fxk6exIr1YVp7sEL6EZCA"
    "wDuFW3UNKmYTlnoAMJ370cPTuHPqifyoDjsdp/j+MRzHAa+XoJzDsi2iT+Rxn5iKU58gv6mL"
    "jlyRcigDjawPjYQZc+I4TroL61tg3zwO92SJ/McnLm6+hOY0san3QrGDsNzfRs3RA1iVZ3Bu"
    "uxQrm0a1j6R8ov+Bsi0oHd1E9DvjUGMrUMddYk/dgKUU3tYLtjWQkVwO6MFd1AAihP86Qml3"
    "e3/+rWh/j5cA//Qm4pcvQcVDlAoIi1lMaw/hltNY2TlEr7uH4MB2QuNhSnlc28F8cAbzUSfu"
    "LdNRjaOxTEDxLzsvmib6KYPSFtGbJ4ClCN5rw8uXAIVbMxdT2EVYPjuoVNX8PCp2EtP5PsU1"
    "LYQFD6VtrESS1FNvMC67jPGTP6V1vcenfy72t/G543AXTaH4UgvejhOAwoldCYnah4dw9/Md"
    "UFmOJKYuEWdkg2BZ/T0gmpDkK/dJzadPSfT6KUN0axunyKPba+XXXq38eH+t1Ix1RSklruuK"
    "NaB/8dKm/FnGUglEykOqX86PwRISlA5Rcd+zWM45wt5uwlwWOVtAnQ2ITfwlyj8Fuouw14Ni"
    "D9MWR6gcqdiw7VZ673oSs3Mv3snTaK2xLGuQ3oMVFnHn/dfoh6AyYZLU/HuNJB659wI62paK"
    "hfdI6vWbJLV9gUSuHiaA1E12pOmhhNS99LzUl9okcf93v/CeKKX6bZyvgcGRy3Hw/QvTrbIc"
    "JPRRWhOZdz06Nx5z9BDlkxv6EauNUv36XMj70JvFfNJH9umDSCDYI+pxZs3Ae2cH0dhi8t1/"
    "uDDoVs7GK37Sz4KLL3A+BeclMfYBTHY3EhjMoSOEPZ3Y48cQm38n/p4thLky5sMu7OEafXcd"
    "VsTCDizCjjKmvRdz4DDiFwn840hYvDDI+h0oHUE1Nzd/pT8m/5f/AISoXHZwsQ+WAAAAAElF"
    "TkSuQmCC")

search = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAF5klEQVRYhcWWf3BU1RXHP29/"
    "vF02uyS7+UFCukCyBmgi1BJTmKZQzQyCVouSUtRCtWpHR2f664/aWpihdGgpYlWGiE1lotiR"
    "qIQoYEGIBFdjAoi0aCSWbEIIMT/IkmTD2+zv0z+yxNBG200BvzNn3rz77rn3c89599yriAhf"
    "pgxf9PHOu35ocrlcxbk5UxeEI+EcBJNRNXZ393iPNzWdPLDt+ec6/l8A5fMi8Pv1T9zrzM58"
    "dPfr1dZXq6qagDNABJg0q6Bg5sqVK5Mt1uS/vXmgZtWu13Z0XjaA0u/dlbR06ZK/7tn9+rzK"
    "ysoNwDv5BbMNC2640WAyTbhw7lxf386d1fqA1nO9IyXpJ396aktu7aF3VjxfUX5wXAQiMmKL"
    "Ft9m3L79ldopTqcbyF+zZt09IrJdRLaJyO9E5AERKRERh4igT52bDKzbUlY2+IOV95WMHut/"
    "tUteNm588ul5RUXvATkeT9uLItImIrtEZL2IPCwiC0UkebTPrBseUYDflpeXty6+ZUl6ogC6"
    "kVwoyhzVoNzRcPTYg2e7tV/l5k5ZBjQDncAg4AVOdEGgC6ynwfqhhrWiarNx7i2PPfVy5cst"
    "hYVffyzRDIwALFq06KG360/UrN7sDmRnWD4AmgAfoAFDwCkfKDbIsIA9Cey2JOyKjkmrH1+n"
    "j06YWW63WW5dfPN30xMGUBTFeX1h4Txr2uzatY8Ub4qBPQyPxyePAuf8EDZDlh7SDJBmgjQz"
    "pJktpFltZJcsebglhjGY6nB8KxGAi3UgP2tytjlterEByNPBVIFNQA1wDeDXQRaguxgyfdxM"
    "Khh0MMWVH9B1tXbaPJ/MBqoTBZhsT81UzFk5qQzvdU0P3wHqwnBGwKYD21jhUwBFAZOZQLrT"
    "Fdbr9cnjiUDIpJpUi8WaAYSAcHzsr+mhJQSDulH/y2gJEBVQdAQzHKn2YDAUGg9Ax3lvlyEj"
    "T/eVKAT1w+0mIBKBzBjYdcNAxOIWjVOGQ+C/ABaVsEWNZvX19Z8aD8AnB97c21Gy5P78j7sY"
    "ys9kYhQkBmoYVB3EIqNXDASBAMOT9/cj1zoxfuo5ZfWe769PGEBEOhVFeeOJTd5fdw2mtjSb"
    "SUpOwQxEdBDRg+jjDhdXPwRofvB6IRoiVjCZrFXPHHj/UO3+jxMB+KwkwjUPPfhjT0gk9sZx"
    "0erOiP+ET7SmiGhtItrZuLWJaM1R0f7uE63GI1rFW6L1BGXI7XaHsp3Tbky0El5yGCmKct9r"
    "1dXP3nr77cbdRyGsg/RUsNnAoA73iUZhSINzvTDQBwuLwBbzc9NNC/fV19fdnNDq4T8AjMCj"
    "r1RWrl62fLn6QTv888xwyA3q8DYIh0GikOWAkgLweFpiR48ei+W4XJHcaVMPOVLtf9DrdO6E"
    "UzAqFSpwf2lpaXNHR7eIiAxERdp8Iq0DIj0hGVFZWZkG/Ab4+UeNTfLkps3S3dM7FIlEHxhX"
    "Ci4JjaJ8Ffj+nOuuW3xHaWnejBkzbKqq6jo7OwIHaw6efbWqqhb4i4gcVxRl8pq1a3c7ndPm"
    "NBw+zC9+9lNmzsjbeL6//5eOlJQvvPN9LkAcQgEcwJT4UwH6gNMi4v23vgu2VlS84Bv0T2tv"
    "b+fO5csoKpyzQ/P7702yWLRxASQqRVGW7tqzZ2vL6faUUDDAvLnfYH7xN98OhcJLVdV4fiyf"
    "McvreCUiO1fcffefZxUUhCYmT+R0WzvvNRz+tqoa9/X3+zKvOACAz+db9aN7VlRcW5AvRqOB"
    "QCDAPz5sLEpJmVj1aVeXfSzqy27AhOnTp297t65e9u6vkcbGk9LsaZVQKOL2tLZdcqW7IgBx"
    "CKvLlfei+906qWs4Ij09vdLZ3SMDPt+++oYjE644wGcQrm3uujr5qPGkhCIRGfD5pLfXu+PI"
    "+8eSrzhAHMKSnZ299a1D7ointU2i8SL2bHn5H68KQBzCnJ6evmXv/pqg74Im6zdsOAZkXjWA"
    "OITRZrM9XTx//kvApIvtl7UQ/TcpimKJ7zz/SNvVBBhL/wLUCyocOuqwfwAAAABJRU5ErkJg"
    "gg==")

pdb_file = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAKT2lDQ1BQaG90b3Nob3AgSUND"
    "IHByb2ZpbGUAAHjanVNnVFPpFj333vRCS4iAlEtvUhUIIFJCi4AUkSYqIQkQSoghodkVUcER"
    "RUUEG8igiAOOjoCMFVEsDIoK2AfkIaKOg6OIisr74Xuja9a89+bN/rXXPues852zzwfACAyW"
    "SDNRNYAMqUIeEeCDx8TG4eQuQIEKJHAAEAizZCFz/SMBAPh+PDwrIsAHvgABeNMLCADATZvA"
    "MByH/w/qQplcAYCEAcB0kThLCIAUAEB6jkKmAEBGAYCdmCZTAKAEAGDLY2LjAFAtAGAnf+bT"
    "AICd+Jl7AQBblCEVAaCRACATZYhEAGg7AKzPVopFAFgwABRmS8Q5ANgtADBJV2ZIALC3AMDO"
    "EAuyAAgMADBRiIUpAAR7AGDIIyN4AISZABRG8lc88SuuEOcqAAB4mbI8uSQ5RYFbCC1xB1dX"
    "Lh4ozkkXKxQ2YQJhmkAuwnmZGTKBNA/g88wAAKCRFRHgg/P9eM4Ors7ONo62Dl8t6r8G/yJi"
    "YuP+5c+rcEAAAOF0ftH+LC+zGoA7BoBt/qIl7gRoXgugdfeLZrIPQLUAoOnaV/Nw+H48PEWh"
    "kLnZ2eXk5NhKxEJbYcpXff5nwl/AV/1s+X48/Pf14L7iJIEyXYFHBPjgwsz0TKUcz5IJhGLc"
    "5o9H/LcL//wd0yLESWK5WCoU41EScY5EmozzMqUiiUKSKcUl0v9k4t8s+wM+3zUAsGo+AXuR"
    "LahdYwP2SycQWHTA4vcAAPK7b8HUKAgDgGiD4c93/+8//UegJQCAZkmScQAAXkQkLlTKsz/H"
    "CAAARKCBKrBBG/TBGCzABhzBBdzBC/xgNoRCJMTCQhBCCmSAHHJgKayCQiiGzbAdKmAv1EAd"
    "NMBRaIaTcA4uwlW4Dj1wD/phCJ7BKLyBCQRByAgTYSHaiAFiilgjjggXmYX4IcFIBBKLJCDJ"
    "iBRRIkuRNUgxUopUIFVIHfI9cgI5h1xGupE7yAAygvyGvEcxlIGyUT3UDLVDuag3GoRGogvQ"
    "ZHQxmo8WoJvQcrQaPYw2oefQq2gP2o8+Q8cwwOgYBzPEbDAuxsNCsTgsCZNjy7EirAyrxhqw"
    "VqwDu4n1Y8+xdwQSgUXACTYEd0IgYR5BSFhMWE7YSKggHCQ0EdoJNwkDhFHCJyKTqEu0JroR"
    "+cQYYjIxh1hILCPWEo8TLxB7iEPENyQSiUMyJ7mQAkmxpFTSEtJG0m5SI+ksqZs0SBojk8na"
    "ZGuyBzmULCAryIXkneTD5DPkG+Qh8lsKnWJAcaT4U+IoUspqShnlEOU05QZlmDJBVaOaUt2o"
    "oVQRNY9aQq2htlKvUYeoEzR1mjnNgxZJS6WtopXTGmgXaPdpr+h0uhHdlR5Ol9BX0svpR+iX"
    "6AP0dwwNhhWDx4hnKBmbGAcYZxl3GK+YTKYZ04sZx1QwNzHrmOeZD5lvVVgqtip8FZHKCpVK"
    "lSaVGyovVKmqpqreqgtV81XLVI+pXlN9rkZVM1PjqQnUlqtVqp1Q61MbU2epO6iHqmeob1Q/"
    "pH5Z/YkGWcNMw09DpFGgsV/jvMYgC2MZs3gsIWsNq4Z1gTXEJrHN2Xx2KruY/R27iz2qqaE5"
    "QzNKM1ezUvOUZj8H45hx+Jx0TgnnKKeX836K3hTvKeIpG6Y0TLkxZVxrqpaXllirSKtRq0fr"
    "vTau7aedpr1Fu1n7gQ5Bx0onXCdHZ4/OBZ3nU9lT3acKpxZNPTr1ri6qa6UbobtEd79up+6Y"
    "nr5egJ5Mb6feeb3n+hx9L/1U/W36p/VHDFgGswwkBtsMzhg8xTVxbzwdL8fb8VFDXcNAQ6Vh"
    "lWGX4YSRudE8o9VGjUYPjGnGXOMk423GbcajJgYmISZLTepN7ppSTbmmKaY7TDtMx83MzaLN"
    "1pk1mz0x1zLnm+eb15vft2BaeFostqi2uGVJsuRaplnutrxuhVo5WaVYVVpds0atna0l1rut"
    "u6cRp7lOk06rntZnw7Dxtsm2qbcZsOXYBtuutm22fWFnYhdnt8Wuw+6TvZN9un2N/T0HDYfZ"
    "DqsdWh1+c7RyFDpWOt6azpzuP33F9JbpL2dYzxDP2DPjthPLKcRpnVOb00dnF2e5c4PziIuJ"
    "S4LLLpc+Lpsbxt3IveRKdPVxXeF60vWdm7Obwu2o26/uNu5p7ofcn8w0nymeWTNz0MPIQ+BR"
    "5dE/C5+VMGvfrH5PQ0+BZ7XnIy9jL5FXrdewt6V3qvdh7xc+9j5yn+M+4zw33jLeWV/MN8C3"
    "yLfLT8Nvnl+F30N/I/9k/3r/0QCngCUBZwOJgUGBWwL7+Hp8Ib+OPzrbZfay2e1BjKC5QRVB"
    "j4KtguXBrSFoyOyQrSH355jOkc5pDoVQfujW0Adh5mGLw34MJ4WHhVeGP45wiFga0TGXNXfR"
    "3ENz30T6RJZE3ptnMU85ry1KNSo+qi5qPNo3ujS6P8YuZlnM1VidWElsSxw5LiquNm5svt/8"
    "7fOH4p3iC+N7F5gvyF1weaHOwvSFpxapLhIsOpZATIhOOJTwQRAqqBaMJfITdyWOCnnCHcJn"
    "Ii/RNtGI2ENcKh5O8kgqTXqS7JG8NXkkxTOlLOW5hCepkLxMDUzdmzqeFpp2IG0yPTq9MYOS"
    "kZBxQqohTZO2Z+pn5mZ2y6xlhbL+xW6Lty8elQfJa7OQrAVZLQq2QqboVFoo1yoHsmdlV2a/"
    "zYnKOZarnivN7cyzytuQN5zvn//tEsIS4ZK2pYZLVy0dWOa9rGo5sjxxedsK4xUFK4ZWBqw8"
    "uIq2Km3VT6vtV5eufr0mek1rgV7ByoLBtQFr6wtVCuWFfevc1+1dT1gvWd+1YfqGnRs+FYmK"
    "rhTbF5cVf9go3HjlG4dvyr+Z3JS0qavEuWTPZtJm6ebeLZ5bDpaql+aXDm4N2dq0Dd9WtO31"
    "9kXbL5fNKNu7g7ZDuaO/PLi8ZafJzs07P1SkVPRU+lQ27tLdtWHX+G7R7ht7vPY07NXbW7z3"
    "/T7JvttVAVVN1WbVZftJ+7P3P66Jqun4lvttXa1ObXHtxwPSA/0HIw6217nU1R3SPVRSj9Yr"
    "60cOxx++/p3vdy0NNg1VjZzG4iNwRHnk6fcJ3/ceDTradox7rOEH0x92HWcdL2pCmvKaRptT"
    "mvtbYlu6T8w+0dbq3nr8R9sfD5w0PFl5SvNUyWna6YLTk2fyz4ydlZ19fi753GDborZ752PO"
    "32oPb++6EHTh0kX/i+c7vDvOXPK4dPKy2+UTV7hXmq86X23qdOo8/pPTT8e7nLuarrlca7nu"
    "er21e2b36RueN87d9L158Rb/1tWeOT3dvfN6b/fF9/XfFt1+cif9zsu72Xcn7q28T7xf9EDt"
    "QdlD3YfVP1v+3Njv3H9qwHeg89HcR/cGhYPP/pH1jw9DBY+Zj8uGDYbrnjg+OTniP3L96fyn"
    "Q89kzyaeF/6i/suuFxYvfvjV69fO0ZjRoZfyl5O/bXyl/erA6xmv28bCxh6+yXgzMV70Vvvt"
    "wXfcdx3vo98PT+R8IH8o/2j5sfVT0Kf7kxmTk/8EA5jz/GMzLdsAAAAGYktHRAD/AP8A/6C9"
    "p5MAAAAJcEhZcwAACxMAAAsTAQCanBgAAAAHdElNRQfZBQoWFxvJ9RrrAAAF6klEQVRYw7WX"
    "f2xV5RnHP+97zr22t0BpmS2dpBZcXeLsAmG4ZDXdCEwggk6niKt/sERIlrCEf4xmCRkzWVxC"
    "mEn/MNMs8MdgmWHUDTXF0qCwKhi9KKQwVygXuooFqve2955z7zn3nPPsj95T773ei+0Sn+TN"
    "e97kOef5vt/n54Ei6evr45uWnTt3lpxVucKhQ4e6urq6TgRBYJcoKsX8+ZpMJiAI5JZGRGRm"
    "D4IgPMdaW1tvByaKdc0KLxuLFi3C87yYUopIJMLExASRiOaRR4SennncfXctSukSg+VGgyDA"
    "93183ycIArTWALrcnq52i6BwzeHhYUxTMzJyg1On3mHfvmtks0nOnRvj3nvT3LiRQalphorZ"
    "UkqhtcYwDCnsFe3oSvQFQYBSSgVBQHt7O6+99j6NjcLU1GM8/XQG01yA6zp0dr7P/PnmjEtC"
    "w+EyDAPDMJRhGCUAvxZAgYFpBQ179nyb7dsbAJ9ly77Pe++9S2vrPF5+eS2RiFnyXvHti4EU"
    "XDB7AF+C0LS1nWdg4B1s2yWVStHY2FjQE0DNxEAIupyJcM0KgFKqBIRl2fT1dSPyJAMD/QSB"
    "z+joVeLxiziOg2nqrwRhORPhmhMDX34IbNsmn8/T0tLEsWNX2LhxE21tS5g3L8OLL45jmqpi"
    "RvxfDIQpVC6e57Fq1X10dwvPPnude+5ppLv7Qx56yMTzghLWKjFRDYBZyQUhkGLalFKMj19i"
    "4cJxhobynDql6elZRV1d/UwWhO8UsxgGYzXRt6pkYRUzTZPBwUEWL/4u50dW8Oab96O1wdmz"
    "F9DaKGEsfC7PpmpiVjOutMasqyOfyTA6OsrIyAipXI7vHD9OfnKS5fv2ofN5HMdBKVXCWKGO"
    "ICJfCepZZQFaM/b226QaGjj9wgu0t7fT2dnJ45s28Wl9PbX79zN28iRBxbQFqsTDrBgIP5Ky"
    "LP6dSrFi2zZ6e3vp6OjAsizW7t7Nu9ksP+nqwrEsbqurIwD8bBalFGYkgg8EjoMyDNRc2+XB"
    "gwdXZzIZSVuWBCIyNTkpjuPIiRMnZGhoSN46elSuXr8ujuOILyKDW7fKaEeH5GVaBrb8Qq7f"
    "dZf4IuK6ruTzecnn8+J5ngBNs44Bz3WZdN3pFIpG+dz3Of3GGzQ1N2PZNuvWreM/iQS25xG/"
    "cJH7B18iudRmSVvAZ8u3s6gsFWctBw4cWJ1OpyWZTEoymZS0iHz86KOS2LJFREQ8z5MgCOTI"
    "kSOSzWblk0RCREQO960UkZh8mh0TT0RyuZzkcjlxXVdc163KgK5WB8IItmyb0d5evmhqwnJd"
    "bNsmk8mwYcMG+vv7aVm8mH899xsuvr6UI3/9Fdd+upV0PD5dQiuk5axcUJzDtzkOq0UwRHCn"
    "pmYKTTabZc2aNdTU1GB9fIYH7/sh33r4Oc51x5g4+Cp3/nEleB6GaeIVAnLOhYhCv/NSKZzJ"
    "yYrjljU1xdqjR2l//nfUK+EHIujYGS79t4ePBvq51t5O3nHmXoiKC0vojmrPuXQaVdCNZXPE"
    "H3iGH7es55/7IXYJYo5DNBabGwNhBSu+cfEq0QekUP1qamtouLafv//jCT45v5FmwI7HZwDO"
    "eSKqBrAciNKay8PDnFWKJR99jyce+xu7Xn2d5JUrtKxfT+B5c4+Bant55QzjoXnpUhJGBOOX"
    "T5GzbWzL4s477sC17dn3gpIALBqzbgVGRIjU1nL6pT+x7C+/5XPvD0QjMfxYLRdeeQUVi80+"
    "DctTUWtd0ucrdTmtNclMhtzze3jr92meeXIBZz6YJPHUJX6e+YyrN2/SsmvX3AaSYoqrGS8e"
    "XmJKsSE7wc1jfyb+4RjLV+7m9uNjHN/xa1bs2AFzjQEp4iz0863coLQmEY/zxQPbWMLPsO0M"
    "DfUL+dHhwxKtqanqAl2tHYuIKm4m5aN3+S5BQCQaxQZ8vBmAnm2rIuPytS5Ip9PJy5cvn/R9"
    "3yp3SThcFtNfEgtK0ZxMMp5IMD48XD6cLohGo57rutU74d69e7/x3/PNmzeXnP8HnfAAl2hN"
    "AloAAAAASUVORK5CYII=")

img_file = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9sHGhYZFKDYjwAAAAVL"
    "SURBVFjDfVdLktNIEH0lVUmyJCQ63F7BYrjAcIRh3VuCiD4Fh+EgzAWAgWFW9IKJXmF7x46I"
    "brfa+kv1mUVHFiVZgyIqbNmlysyXLzOf2PX1tVFKgS5jzORz/vuv9jHGJnvonjE2+Y+++74P"
    "nqYplFKTA2ktGTPGQGttf9NaWwO/WnNHGGPgnIMvGZ3fa63tWvqPDvU8D4wxeJ43WW7UxpgJ"
    "GhyzyzVAyGitoZSaRL6EgFJq4gDn3Do2Tw3Z+F8HlFKQUp5EPr/cyFy0PM+zz/i+D9/3J8bp"
    "Oe5GTIbIuJTyhGR0gOvwnGDuWe5e14mTFMwjp+gJPhd6rbU9QCk1yTOlwEVkHEd77/v+xCk+"
    "zzktdxPBSgbdPVprCzGtOfGIQ/OqsBxwU0AHu3BTFG3bou97DMOArusAAMMwIAxDxHGM1WqF"
    "IAgQBAGEEBOu0NlupUwcIJa78BpjIKXEOI4oyxJ1XaMoCjDGsN/t8NuzZ/B9H+M44t+vX/H7"
    "8+dI0xRJkiCOYwghJhUwRwIA2H6/N8MwYBxHSzo3f13X4Xg84u7uDlVVTaKL49iSres6KKXQ"
    "9z3Oz8/x+PFjJEkycYIqgnMOzjmCIIBHEM9Za4zBOI5omgb39/domgZJkqDve5ydnWGz2SBJ"
    "ElxeXiJJEqzXa2RZhiAIUJYliqJA27a4uro6qRrXFttut6brOozjOIFfSom2bXF7e4vj8Qgh"
    "BMIwxKNHj2xqjDEIwxBaa7Rti9Vqhaqq0DQNpJQ4Pz/HZrN5iNRJBaEQRRE8t8Tc3NChbdtC"
    "CIGyLJGmqYX7n8+fcX9/b0v11atXAIAsyxDHMXbbrSWsS2q3CwIA+/btm+m6DlJKuITsug63"
    "t7c4HA5IkgR5nlsnx3EEANzd3SHPc/i+D601oiiy6STnNpsN0jRFGIYng2i1Wj1wYGkCaq0h"
    "pZzUtDEGH96/t1URRRHqukbTNJZsFxcXEEJACGFTNe+kLure0qyfN58oiuyDf7x48dDBOMfl"
    "5SUOhwMYY3b/u3fvbJ6phN3qcgeaUgreXCxQ5PSdHHz9+rW9H8cRNzc3ePPmjXXu08ePqOva"
    "9pOXL19OxvRSoJ7nPXCgbdsJVEopHI9HFEWBuq6RZRnCMLRNR0ppDdFBnHMwxhAEAYZhwI8f"
    "PyClxJMnT7Berxc5YKtgacRSw6nr2jJZKYXv37/bOS+EwNWXLxZ+zjkuLi5QVRWEEIjjGL7v"
    "L05Qy4ntdmsRcDtg3/eoqgo3NzcwxiBNU9v9iFykJakfUI6pbQsh8PTpUyRJYhEiw0KIBwTm"
    "HKADr6+vEUURoihC3/do29Y2K601/v70CUEQ2An414cPaNsWXdeh6zrstlucnZ2dtGJXujHG"
    "wHa7ne0D7iSkCUhzoG1b22iklIiiCGEYou9763hd1+j7HsYY5Hk+mQduejnntrN6NBqXJLXv"
    "+4jjGHmeI4oiAEBZlrZNHw4HdF2HqqpQFAWKooAxBlmWIc9zhGGIP9++PVFVrj223+8NMXsY"
    "BlunRByq5aZpUJYlqqqyU9EYM1E/pAfW6zVWqxU45xO4ibiUliAIfkoyz/OsXHK7IrGYiBPH"
    "MbIss5VBTSkMQ4RhiCiKIISYKKP5We7F3SHhOjDX+3Qo5xxJkli+0IwHYEk5F68k013JZlWx"
    "mxf3IlHqTjI3ApJXriqmg11N4T4714uMsZ8I0GYXBTLk6gTrOedLPezEOKHmRr4oy90f5/rd"
    "hXvpZWTe6eZvR0TGRQeWGpGrXCmKJbnuDrA5l9ycu7w4QfL/XrXcIUOqh4THPEXUZucvpnPe"
    "LL0h/wc3DLvFAY/bOAAAAABJRU5ErkJggg==")

viewmag = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACFElEQVQ4jZWT30tTcRjGn+85"
    "Lo7T2XJ1PG79MH9gBI2xiIggatRVRasbQxndRGBRQpdGF0KIF7srm0iLCKI/wLqREKHIm4yg"
    "oqDmNsd+lLa1zdX0cPZ0sQyjnWAPPLzw5eXDA8/7FSSxrsHBa3Ik+qm5VCypirLpW1dX78rk"
    "5Pga/iOxDrh46Yq2UshenpmZtaiaRkM3oLW1Ojq79zwI35uYMyWQhP9cn8131BciuURymWSY"
    "5BOSU979h+/3ne8/QBK1LAkhpHQyfn0i/EgBkATwEAABFAGk5l+9cKyW9VsnT/mlWgEkAI0t"
    "W1y9PZ3aXgAzleobAOwAsB1AqkxrOZNOOMwA2/Z5DtkA6ABaJKBZB6wAPgJIA+hwunbLsmxR"
    "zQBLAroKYKcB9GQAuwX4UQFOAHgJQHW5tG5dX82ZAX5OP338NrOGVhnwSIC3Up2tAILPY2gr"
    "ZhcLkiR9MW0BgDYWDMW+GvxL0RVyLDjOQGBgxKyFht+QjBDi2OyzqZDnoO+40qjKhlGiUcrM"
    "j46OJPoHBm5GFmJH2p3aWauifP8nwUbbbDYFQEdTk3Wz2+2WSMJisUyfPuPnu/cfFkju2rhf"
    "M1Yt2+32uUDgAj9Hosu5fN5aN4AkNKfzzdWhIebyhVQ8vqjUDQAgVFV9PTx8gyQjyWS6vaFm"
    "NSZileLdqqrzxVIpcffO7eyf31iPhBAyqjdk/AIEL4Xptl+gaQAAAABJRU5ErkJggg==")

symmetry = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAADnRFWHRTb2Z0d2FyZQBQeU1P"
    "TPa/er0AAAAYdEVYdFVSTABodHRwOi8vd3d3LnB5bW9sLm9yZ5iPN04AAAozSURBVFiFtZZ5"
    "WFNnFsbfm9xLNiCEJSBLYgibAhWMu6AVsQgOSh0FbdUWx4LjaB11tFrHbcTWahe1dSoq1Vor"
    "WluklCquVaQIakDZIYISBRRI2BOS3Nw7f7Q4aPGx7XTev+53nnPP+3vOd77n+4D/k9Km4+D6"
    "cBx+Xh7xR5q2rIaiwWTzutiWlJe3EMzlsh7KykLkwMcDlkU9j0T2uouo/kMB3hgO73WTSG97"
    "e97khg5WbjZbLzxoMV3ydiTWm2k2ZeVZkB728BeSmOkoQIg9D7UCCpkGC8o2XUYp+XuN8/8C"
    "pdMghyijwRzJIy2a+oaecx9eQ92Xpbi7cizCA90IDPuUrf85vRbA6TdHYY7SjXpVJaPed2AM"
    "Rzddxlu/GeBALKLHelNTRSJK2dBJ19yoNny64izO98+ZM2eOylhz8l7funwJQuxdxa/1Gi3z"
    "uVa6+H6LocTBlWQBGr8KYOVY+L0ZRvnZ2vFitG2MsttEZx+vC8xPOX7jBACkpqbuS0pKKsrN"
    "zVV5enreYPf4thZZvOSXX6tfKJfaJFq55DALQ6R16g2TVftx+/ZS7mlzL10KPGcGrr8Bf8kg"
    "hxkmg/lPYq6l8qHekvVuHmoyKqGpqalRubu7w2g0WiQSCZWRkZEkk8mSFAoF7GqP5pgubAxh"
    "WNxV1xnVdTombXE2bgHAMFcEn5hNnK5vZ2Oijj5jBlIiMCTQjbvWxZnnX6+nK65VGnauu4jv"
    "+uf4+fmpMzMzC8aMGeNTV1d3+IXc+P2NfJnqoSJEpWtrGN6o6Vkf+QUOPl379RAEWxiwUUdR"
    "CgCcgQCsDI4V1ltHZRYZmvLKu3/obz558uShLMsGvf3227tCQ0MDLqRt1HQf+/OLpK3wpo//"
    "ULbpWtYKki86NpA5AEhFCFY4k8f61r/owPbJeDl2CGHdcJGd3diNeVIhEteHI9mOh7KOXhTN"
    "2LYt/5uPVsyLIS/z2lIPi6N57dQlmwTrjfs+1+e/+i+1A/xZO2FHPZA74LZOVHKJsodW9pkA"
    "LiIEDHbiZmRU0mUA1gJAlBILZWKMsuEitWrnOHW4n0BlsfMBf+Q/geEJBT5a7cHZoaG3BgVN"
    "SFKVf+Jk48TkAUBtbW2sUql8Yuvq9OxcxsqseybAFF8uUdPCPBFL3Ha8fcSIEXNtbGwSqzYo"
    "DmlNg3ZR0/ZWcDic7UEURZ06dYoLABEREe3tgac2W0PGbPnY88QCpVJ5vLGx0dfd3V0DACkR"
    "CPKwA9acRUlf7V/MQG0bG2c0MZX9Y1arNYUkScJoNKq8Z72LRulUm7CwsANXrlw5XVNTM3vC"
    "hAn7DAbDvsrKyn906Jo5t27dWuLn58euWbPG99y5c5zs7OwYABjtgWCKw5Z8U4myAQH+OQEB"
    "XvbA1xWoBIAjR44k1dfX75FIJNqCgoKbjY2NS+/yQ00FDUSgyWQKcHR0zK6oqCDkcvngEydO"
    "JE8NCxkc7ifWubq6ipubm7tCQ0NJnU7H6erq0gCARIBgHo8s7e/5BMB4LwTwuWzVh9dQBQCe"
    "np6phYWF48RisbOrqytd8MWmhyFN+01SqZTT2dk5Lz09vZsgiN1nzpw5LBKJvsktqukqNw7S"
    "tra2jvM9dGitZNOmK7a2tmv4c+eKNMBwHWMfV9HtangmgESAIXwe+bj9DMPA2dlZpdfrVW5u"
    "buGJk2TO+d1+9CuvvGJ75coV7e7du6nOzs4SnU73cVdXl4Gm6Zv3Cr8rlMvldobo6IfdNTWU"
    "z9Jkj2qA2L10qZOM3yWwDYyusFqtygEBSIobYDZZHgN4e3snEwTBSKXSnoqKClqbd4ysvN9m"
    "rq6ubpdKpbRQKJxG03RxQ/GFIe6VqQX2HV8JxquoqXq9vi1i9er46lmz0isEspBxciIli3CI"
    "vk4FckcuPpCxZMkS4vz5876/ABBwmACN7qf2h4WFJQmFwlQej8cCWCEQCMpJv2iETJyeSNM0"
    "bTQaPywuLj7b29uLFwfb+529cz0iqOp46Zfbj+9IXT1KvObvwzeNXrw4S7Zy7p5crmiYpZP3"
    "+mu22zJ37NgxLTU19c6UKVM0TwBsnYQZBAfsxMM/ASgUCpAkiebm5iX5+flFo1H4mbH+ukUo"
    "FO4rKSlxd3Z2Ft+5c0fO5/N9nKYx4yaP9fat5WLuvHF3EvSx3iW8ThtuZOTeRzM2v5dSO3T8"
    "X5tEQ4lZ5hpZfHz88rS0tJjHXe/7mDkEhNyRmwnQAAAXFxe11WpNdnNzY+Li4tSDV41OVfHa"
    "DuVUVU2SyWSeVqtV7eXlVR4cHLzR0fFl3O06rSXuLdb+4BLkNcbWjl4fGfxgTWX39DeWfbIo"
    "vZEktj/8rCtysGtndXX1/ry8PE2f7+Pb8N4q7ludvSxe2Mu8hwF09Z0oxq3p7OJM2c4cqVS6"
    "0t3dfRpFUQatVnubx+MJGjpuDe/wfzdjy+2Fk+ApRsSt2++4sMu2z5ztV7Dj/TZxVE9KiL4+"
    "J2bfTZQPeApq9WycwcRUDWQepYTKob2EuOu9CK2traqWlhb34ODgYvpR+cHw0kVVI5v+3ZHz"
    "xbk7upwlkTDZhY7KvHov+tqlkhPa8tMJsefOqUv5owLtGm4/bQ4AXABYGwb/CG9ixldlbFpu"
    "PXRPJ60LR2yoU4/7sI1FyfMlP/YaGYpv4+IbHD42yIMwdqizv806vPtC094WJ6dBSp8APw87"
    "Ca/VZJk+W3us24OvD/ay6XBbFfT9+Z15zKWna5MAECZDAJ/LVqfkPvli7ZOzECqK4uofbBEt"
    "0rTxI8as2mLbZHE0nrp44xLFi/sxOfuIFgDufpuzOWrQ4K74+PjvNh/4BHIvJMT5lcwfLa+g"
    "9e102UC1SQBwFMCfz+NW9g1gf11NxEsBHjxvEzgSjnyiTx5n5GHtpfJYLy+vnISEhO+PHj0a"
    "l56eTnzwwQeckydPclxcXLL0G2wFGQtFr3abMLerl7ldWN3z5eyTOP5MAJLiBtBm+tu+4Gcz"
    "4BMz3NaHTxIv0bSVrW3ojWzuYpJjU7L219Xt8lEoFHsIgtAAgE6nw/Lly2sAwPC+94IuCX+B"
    "gRIGdfYQnzc/6p4W8TlKBzLuEwEAZX8jfmw3sgtdhGDsXOynGXutUxmLpfruI/Ppqla0xvhz"
    "bvrsYh6fmK1bt84MCAhQajSaCoX+vMgX6vE+EnaYyWhmz5Sa1Bo9jmy7+t8r97kAlcs4ebZC"
    "sryXIH0JisrSNXV8P/ogND9vQZK7mJOk3MWM6P/jmZ0LNo02fC3tNBGJ9SYnQ227MG1hWtVb"
    "v8a0v0gA+LyIsQlxN6vut5uzVp/Hrv4JDgJCxbPhqIGfHilVyzhJpFTxkbnla94DK1IfNveM"
    "/6h1gsLf378CGPAUP78D0/0xREQh3s0WI3hcjHAQ4CuLFSUbfkBa+ZvkTdpMqxl7eyjErMpk"
    "MEPXbko9VAz1znwU/WbHgQD6K1yGed4SjHQRYSyfBGfBMEJF2QnQZoS67J5h/4JT2P+/mv4m"
    "bXkR7POzfr/+A+DZZBN1kMZbAAAAAElFTkSuQmCC")
