<!--
%CopyrightBegin%

SPDX-License-Identifier: Apache-2.0

Copyright Ericsson AB 2023-2025. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

%CopyrightEnd%
-->
# script

Boot script

## Description

The _boot script_ describes how the Erlang runtime system is started. It
contains instructions for which code to load, and which processes and applications
to start.

Command `erl -boot Name` starts the system with a boot file called `Name.boot`,
which is generated from the `Name.script` file, using `systools:script2boot/1`.

The `.script` file is generated by `systools` from a `.rel` file and from `.app`
files.

## File Syntax

The boot script is stored in a file with extension `.script`. The file has the
following syntax:

```erlang
{script, {Name, Vsn},
 [
  {progress, loading},
  {preLoaded, [Mod1, Mod2, ...]},
  {path, [Dir1,"$ROOT/Dir",...]}.
  {primLoad, [Mod1, Mod2, ...]},
  ...
  {kernel_load_completed},
  {progress, loaded},
  {kernelProcess, Name, {Mod, Func, Args}},
  ...
  {apply, {Mod, Func, Args}},
  ...
  {progress, started}]}.
```

- **`Name = string()`** - Defines the system name.

- **`Vsn = string()`** - Defines the system version.

- **`{progress, Term}`** - Sets the "progress" of the initialization program.
  The `init:get_status/0` function returns the current value of the progress,
  which is `{InternalStatus,Term}`.

- **`{path, [Dir]}`** - `Dir` is a string. This argument sets the load path of
  the system to `[Dir]`. The load path used to load modules is obtained from the
  initial load path, which is given in the script file, together with any path
  flags that were supplied in the command-line arguments. The command-line
  arguments modify the path as follows:

  - `-pa Dir1 Dir2 ... DirN` adds the directories
    `DirN, DirN-1, ..., Dir2, Dir1` to the front of the initial load path.
  - `-pz Dir1 Dir2 ... DirN` adds the directories `Dir1, Dir2, ..., DirN` to the
    end of the initial load path.
  - `-path Dir1 Dir2 ... DirN` defines a set of directories
    `Dir1, Dir2, ..., DirN`, which replace the search path given in the script
    file. Directory names in the path are interpreted as follows:

    - Directory names starting with `/` are assumed to be absolute path names.
    - Directory names not starting with `/` are assumed to be relative the
      current working directory.
    - The special `$ROOT` variable can only be used in the script, not as a
      command-line argument. The given directory is relative the Erlang
      installation directory.

- **`{primLoad, [Mod]}`** - Loads the modules `[Mod]` from the directories
  specified in `Path`. The script interpreter fetches the appropriate module by
  calling [`erl_prim_loader:get_file(Mod)`](`erl_prim_loader:get_file/1`). A
  fatal error that terminates the system occurs if the module cannot be located.

- **`{kernel_load_completed}`** - Indicates that all modules that _must_ be
  loaded _before_ any processes are started are loaded. In interactive mode, all
  `{primLoad,[Mod]}` commands interpreted after this command are ignored, and
  these modules are loaded on demand. In embedded mode, `kernel_load_completed`
  is ignored, and all modules are loaded during system start.

- **`{kernelProcess, Name, {Mod, Func, Args}}`** - Starts the "kernel process"
  `Name` by evaluating [`apply(Mod, Func, Args)`](`apply/3`). The start function
  is to return `{ok, Pid}` or `ignore`. The `init` process monitors the behavior
  of `Pid` and terminates the system if `Pid` dies. Kernel processes are key
  components of the runtime system. Users do not normally add new kernel
  processes.

- **`{apply, {Mod, Func, Args}}`.** - The init process evaluates
  [`apply(Mod, Func, Args)`](`apply/3`). The system terminates if this results
  in an error. The boot procedure hangs if this function never returns.

> #### Note {: .info }
>
> In an interactive system, the code loader provides demand-driven code loading,
> but in an embedded system the code loader loads all code immediately. The same
> version of `m:code` is used in both cases. The code server calls
> [`init:get_argument(mode)`](`init:get_argument/1`) to determine if it is to
> run in demand mode or non-demand driven mode.

## See Also

`m:systools`
