//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armlabservices.ClientFactory type.
type ServerFactory struct {
	ImagesServer           ImagesServer
	LabPlansServer         LabPlansServer
	LabsServer             LabsServer
	OperationResultsServer OperationResultsServer
	OperationsServer       OperationsServer
	SKUsServer             SKUsServer
	SchedulesServer        SchedulesServer
	UsagesServer           UsagesServer
	UsersServer            UsersServer
	VirtualMachinesServer  VirtualMachinesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armlabservices.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armlabservices.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                      *ServerFactory
	trMu                     sync.Mutex
	trImagesServer           *ImagesServerTransport
	trLabPlansServer         *LabPlansServerTransport
	trLabsServer             *LabsServerTransport
	trOperationResultsServer *OperationResultsServerTransport
	trOperationsServer       *OperationsServerTransport
	trSKUsServer             *SKUsServerTransport
	trSchedulesServer        *SchedulesServerTransport
	trUsagesServer           *UsagesServerTransport
	trUsersServer            *UsersServerTransport
	trVirtualMachinesServer  *VirtualMachinesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ImagesClient":
		initServer(s, &s.trImagesServer, func() *ImagesServerTransport { return NewImagesServerTransport(&s.srv.ImagesServer) })
		resp, err = s.trImagesServer.Do(req)
	case "LabPlansClient":
		initServer(s, &s.trLabPlansServer, func() *LabPlansServerTransport { return NewLabPlansServerTransport(&s.srv.LabPlansServer) })
		resp, err = s.trLabPlansServer.Do(req)
	case "LabsClient":
		initServer(s, &s.trLabsServer, func() *LabsServerTransport { return NewLabsServerTransport(&s.srv.LabsServer) })
		resp, err = s.trLabsServer.Do(req)
	case "OperationResultsClient":
		initServer(s, &s.trOperationResultsServer, func() *OperationResultsServerTransport {
			return NewOperationResultsServerTransport(&s.srv.OperationResultsServer)
		})
		resp, err = s.trOperationResultsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SKUsClient":
		initServer(s, &s.trSKUsServer, func() *SKUsServerTransport { return NewSKUsServerTransport(&s.srv.SKUsServer) })
		resp, err = s.trSKUsServer.Do(req)
	case "SchedulesClient":
		initServer(s, &s.trSchedulesServer, func() *SchedulesServerTransport { return NewSchedulesServerTransport(&s.srv.SchedulesServer) })
		resp, err = s.trSchedulesServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	case "UsersClient":
		initServer(s, &s.trUsersServer, func() *UsersServerTransport { return NewUsersServerTransport(&s.srv.UsersServer) })
		resp, err = s.trUsersServer.Do(req)
	case "VirtualMachinesClient":
		initServer(s, &s.trVirtualMachinesServer, func() *VirtualMachinesServerTransport {
			return NewVirtualMachinesServerTransport(&s.srv.VirtualMachinesServer)
		})
		resp, err = s.trVirtualMachinesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
