//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armworkloads_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/workloads/armworkloads"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_Get.json
func ExampleSAPCentralInstancesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSAPCentralInstancesClient().Get(ctx, "test-rg", "X00", "centralServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPCentralServerInstance = armworkloads.SAPCentralServerInstance{
	// 	Name: to.Ptr("centralServer"),
	// 	Type: to.Ptr("Microsoft.Workloads/sapVirtualInstances/centralInstances"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westcentralus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armworkloads.SAPCentralServerProperties{
	// 		EnqueueReplicationServerProperties: &armworkloads.EnqueueReplicationServerProperties{
	// 			ErsVersion: to.Ptr(armworkloads.EnqueueReplicationServerTypeEnqueueReplicator1),
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ers1"),
	// 			InstanceNo: to.Ptr("00"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			KernelPatch: to.Ptr("patch 300"),
	// 			KernelVersion: to.Ptr("777"),
	// 		},
	// 		EnqueueServerProperties: &armworkloads.EnqueueServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateUnknown),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			Port: to.Ptr[int64](3600),
	// 		},
	// 		GatewayServerProperties: &armworkloads.GatewayServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateDegraded),
	// 			Port: to.Ptr[int64](3300),
	// 		},
	// 		Health: to.Ptr(armworkloads.SAPHealthStateUnknown),
	// 		InstanceNo: to.Ptr("00"),
	// 		KernelPatch: to.Ptr("patch 300"),
	// 		KernelVersion: to.Ptr("777"),
	// 		MessageServerProperties: &armworkloads.MessageServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateUnhealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			HTTPPort: to.Ptr[int64](8100),
	// 			HTTPSPort: to.Ptr[int64](44400),
	// 			InternalMsPort: to.Ptr[int64](3900),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			MSPort: to.Ptr[int64](3600),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.SapVirtualInstanceProvisioningStateSucceeded),
	// 		Status: to.Ptr(armworkloads.SAPVirtualInstanceStatusRunning),
	// 		VMDetails: []*armworkloads.CentralServerVMDetails{
	// 			{
	// 				Type: to.Ptr(armworkloads.CentralServerVirtualMachineTypePrimary),
	// 				VirtualMachineID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/cs-vm"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_Create_HA_AvSet.json
func ExampleSAPCentralInstancesClient_BeginCreate_createSapCentralInstancesForHaSystemWithAvailabilitySet() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSAPCentralInstancesClient().BeginCreate(ctx, "test-rg", "X00", "centralServer", armworkloads.SAPCentralServerInstance{
		Location:   to.Ptr("westcentralus"),
		Tags:       map[string]*string{},
		Properties: &armworkloads.SAPCentralServerProperties{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPCentralServerInstance = armworkloads.SAPCentralServerInstance{
	// 	Name: to.Ptr("centralServer"),
	// 	Type: to.Ptr("Microsoft.Workloads/sapVirtualInstances/centralInstances"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westcentralus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armworkloads.SAPCentralServerProperties{
	// 		EnqueueReplicationServerProperties: &armworkloads.EnqueueReplicationServerProperties{
	// 			ErsVersion: to.Ptr(armworkloads.EnqueueReplicationServerTypeEnqueueReplicator1),
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ers1"),
	// 			InstanceNo: to.Ptr("00"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			KernelPatch: to.Ptr("patch 300"),
	// 			KernelVersion: to.Ptr("777"),
	// 		},
	// 		EnqueueServerProperties: &armworkloads.EnqueueServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			Port: to.Ptr[int64](3600),
	// 		},
	// 		GatewayServerProperties: &armworkloads.GatewayServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Port: to.Ptr[int64](3300),
	// 		},
	// 		Health: to.Ptr(armworkloads.SAPHealthStateUnknown),
	// 		InstanceNo: to.Ptr("00"),
	// 		KernelPatch: to.Ptr("patch 300"),
	// 		KernelVersion: to.Ptr("777"),
	// 		LoadBalancerDetails: &armworkloads.LoadBalancerDetails{
	// 			ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Network/loadBalancers/cs-ASCS-loadBalancer"),
	// 		},
	// 		MessageServerProperties: &armworkloads.MessageServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			HTTPPort: to.Ptr[int64](8100),
	// 			HTTPSPort: to.Ptr[int64](44400),
	// 			InternalMsPort: to.Ptr[int64](3900),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			MSPort: to.Ptr[int64](3600),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.SapVirtualInstanceProvisioningStateSucceeded),
	// 		Status: to.Ptr(armworkloads.SAPVirtualInstanceStatusRunning),
	// 		VMDetails: []*armworkloads.CentralServerVMDetails{
	// 			{
	// 				Type: to.Ptr(armworkloads.CentralServerVirtualMachineTypePrimary),
	// 				StorageDetails: []*armworkloads.StorageInformation{
	// 					{
	// 						ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/nfsstorageaccount"),
	// 				}},
	// 				VirtualMachineID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/cs-vm1"),
	// 			},
	// 			{
	// 				Type: to.Ptr(armworkloads.CentralServerVirtualMachineTypePrimary),
	// 				StorageDetails: []*armworkloads.StorageInformation{
	// 					{
	// 						ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Storage/storageAccounts/nfsstorageaccount"),
	// 				}},
	// 				VirtualMachineID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/cs-vm2"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_Create.json
func ExampleSAPCentralInstancesClient_BeginCreate_sapCentralInstancesCreate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSAPCentralInstancesClient().BeginCreate(ctx, "test-rg", "X00", "centralServer", armworkloads.SAPCentralServerInstance{
		Location:   to.Ptr("westcentralus"),
		Tags:       map[string]*string{},
		Properties: &armworkloads.SAPCentralServerProperties{},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPCentralServerInstance = armworkloads.SAPCentralServerInstance{
	// 	Name: to.Ptr("centralServer"),
	// 	Type: to.Ptr("Microsoft.Workloads/sapVirtualInstances/centralInstances"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westcentralus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armworkloads.SAPCentralServerProperties{
	// 		EnqueueReplicationServerProperties: &armworkloads.EnqueueReplicationServerProperties{
	// 			ErsVersion: to.Ptr(armworkloads.EnqueueReplicationServerTypeEnqueueReplicator1),
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ers1"),
	// 			InstanceNo: to.Ptr("00"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			KernelPatch: to.Ptr("patch 300"),
	// 			KernelVersion: to.Ptr("777"),
	// 		},
	// 		EnqueueServerProperties: &armworkloads.EnqueueServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			Port: to.Ptr[int64](3600),
	// 		},
	// 		GatewayServerProperties: &armworkloads.GatewayServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Port: to.Ptr[int64](3300),
	// 		},
	// 		Health: to.Ptr(armworkloads.SAPHealthStateUnknown),
	// 		InstanceNo: to.Ptr("00"),
	// 		KernelPatch: to.Ptr("patch 300"),
	// 		KernelVersion: to.Ptr("777"),
	// 		MessageServerProperties: &armworkloads.MessageServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			HTTPPort: to.Ptr[int64](8100),
	// 			HTTPSPort: to.Ptr[int64](44400),
	// 			InternalMsPort: to.Ptr[int64](3900),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			MSPort: to.Ptr[int64](3600),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.SapVirtualInstanceProvisioningStateSucceeded),
	// 		Status: to.Ptr(armworkloads.SAPVirtualInstanceStatusRunning),
	// 		VMDetails: []*armworkloads.CentralServerVMDetails{
	// 			{
	// 				Type: to.Ptr(armworkloads.CentralServerVirtualMachineTypePrimary),
	// 				VirtualMachineID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/cs-vm"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_Update.json
func ExampleSAPCentralInstancesClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSAPCentralInstancesClient().BeginUpdate(ctx, "test-rg", "X00", "centralServer", armworkloads.UpdateSAPCentralInstanceRequest{
		Tags: map[string]*string{
			"tag1": to.Ptr("value1"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SAPCentralServerInstance = armworkloads.SAPCentralServerInstance{
	// 	Name: to.Ptr("centralServer"),
	// 	Type: to.Ptr("Microsoft.Workloads/sapVirtualInstances/centralInstances"),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
	// 	SystemData: &armworkloads.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		CreatedBy: to.Ptr("user@xyz.com"),
	// 		CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("user@xyz.com"),
	// 		LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("westcentralus"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armworkloads.SAPCentralServerProperties{
	// 		EnqueueReplicationServerProperties: &armworkloads.EnqueueReplicationServerProperties{
	// 			ErsVersion: to.Ptr(armworkloads.EnqueueReplicationServerTypeEnqueueReplicator1),
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ers1"),
	// 			InstanceNo: to.Ptr("00"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			KernelPatch: to.Ptr("patch 300"),
	// 			KernelVersion: to.Ptr("777"),
	// 		},
	// 		EnqueueServerProperties: &armworkloads.EnqueueServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			Port: to.Ptr[int64](3600),
	// 		},
	// 		GatewayServerProperties: &armworkloads.GatewayServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Port: to.Ptr[int64](3300),
	// 		},
	// 		Health: to.Ptr(armworkloads.SAPHealthStateUnknown),
	// 		InstanceNo: to.Ptr("00"),
	// 		KernelPatch: to.Ptr("patch 300"),
	// 		KernelVersion: to.Ptr("777"),
	// 		MessageServerProperties: &armworkloads.MessageServerProperties{
	// 			Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
	// 			Hostname: to.Ptr("vh-ascs1"),
	// 			HTTPPort: to.Ptr[int64](8100),
	// 			HTTPSPort: to.Ptr[int64](44400),
	// 			InternalMsPort: to.Ptr[int64](3900),
	// 			IPAddress: to.Ptr("10.0.0.5"),
	// 			MSPort: to.Ptr[int64](3600),
	// 		},
	// 		ProvisioningState: to.Ptr(armworkloads.SapVirtualInstanceProvisioningStateSucceeded),
	// 		Status: to.Ptr(armworkloads.SAPVirtualInstanceStatusRunning),
	// 		VMDetails: []*armworkloads.CentralServerVMDetails{
	// 			{
	// 				Type: to.Ptr(armworkloads.CentralServerVirtualMachineTypePrimary),
	// 				VirtualMachineID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/cs-vm"),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_Delete.json
func ExampleSAPCentralInstancesClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSAPCentralInstancesClient().BeginDelete(ctx, "test-rg", "X00", "centralServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatusResult = armworkloads.OperationStatusResult{
	// 	Name: to.Ptr("1e4193c3-206e-4916-b124-1da16175eb0e"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/operations/locations/centralus/1e4193c3-206e-4916-b124-1da16175eb0e"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_List.json
func ExampleSAPCentralInstancesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSAPCentralInstancesClient().NewListPager("test-rg", "X00", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SAPCentralInstanceList = armworkloads.SAPCentralInstanceList{
		// 	Value: []*armworkloads.SAPCentralServerInstance{
		// 		{
		// 			Name: to.Ptr("centralServer"),
		// 			Type: to.Ptr("Microsoft.Workloads/sapVirtualInstances/centralInstances"),
		// 			ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
		// 			SystemData: &armworkloads.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
		// 				CreatedBy: to.Ptr("user@xyz.com"),
		// 				CreatedByType: to.Ptr(armworkloads.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T15:10:46.196Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("user@xyz.com"),
		// 				LastModifiedByType: to.Ptr(armworkloads.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("westcentralus"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armworkloads.SAPCentralServerProperties{
		// 				EnqueueReplicationServerProperties: &armworkloads.EnqueueReplicationServerProperties{
		// 					ErsVersion: to.Ptr(armworkloads.EnqueueReplicationServerTypeEnqueueReplicator1),
		// 					Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
		// 					Hostname: to.Ptr("vh-ers1"),
		// 					InstanceNo: to.Ptr("00"),
		// 					IPAddress: to.Ptr("10.0.0.5"),
		// 					KernelPatch: to.Ptr("patch 300"),
		// 					KernelVersion: to.Ptr("777"),
		// 				},
		// 				EnqueueServerProperties: &armworkloads.EnqueueServerProperties{
		// 					Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
		// 					Hostname: to.Ptr("vh-ascs1"),
		// 					IPAddress: to.Ptr("10.0.0.5"),
		// 					Port: to.Ptr[int64](3600),
		// 				},
		// 				GatewayServerProperties: &armworkloads.GatewayServerProperties{
		// 					Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
		// 					Port: to.Ptr[int64](3300),
		// 				},
		// 				Health: to.Ptr(armworkloads.SAPHealthStateUnknown),
		// 				InstanceNo: to.Ptr("00"),
		// 				KernelPatch: to.Ptr("patch 300"),
		// 				KernelVersion: to.Ptr("777"),
		// 				MessageServerProperties: &armworkloads.MessageServerProperties{
		// 					Health: to.Ptr(armworkloads.SAPHealthStateHealthy),
		// 					Hostname: to.Ptr("vh-ascs1"),
		// 					HTTPPort: to.Ptr[int64](8100),
		// 					HTTPSPort: to.Ptr[int64](44400),
		// 					InternalMsPort: to.Ptr[int64](3900),
		// 					IPAddress: to.Ptr("10.0.0.5"),
		// 					MSPort: to.Ptr[int64](3600),
		// 				},
		// 				ProvisioningState: to.Ptr(armworkloads.SapVirtualInstanceProvisioningStateSucceeded),
		// 				Status: to.Ptr(armworkloads.SAPVirtualInstanceStatusRunning),
		// 				VMDetails: []*armworkloads.CentralServerVMDetails{
		// 					{
		// 						Type: to.Ptr(armworkloads.CentralServerVirtualMachineTypePrimary),
		// 						VirtualMachineID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Compute/virtualMachines/cs-vm"),
		// 				}},
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_StartInstance.json
func ExampleSAPCentralInstancesClient_BeginStartInstance() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSAPCentralInstancesClient().BeginStartInstance(ctx, "test-rg", "X00", "centralServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatusResult = armworkloads.OperationStatusResult{
	// 	Name: to.Ptr("centralServer"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/1e7b408f3323e7f5424745718fe62c7a043a2337/specification/workloads/resource-manager/Microsoft.Workloads/stable/2023-04-01/examples/sapvirtualinstances/SAPCentralInstances_StopInstance.json
func ExampleSAPCentralInstancesClient_BeginStopInstance() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armworkloads.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSAPCentralInstancesClient().BeginStopInstance(ctx, "test-rg", "X00", "centralServer", &armworkloads.SAPCentralInstancesClientBeginStopInstanceOptions{Body: &armworkloads.StopRequest{
		SoftStopTimeoutSeconds: to.Ptr[int64](1200),
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationStatusResult = armworkloads.OperationStatusResult{
	// 	Name: to.Ptr("centralServer"),
	// 	EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:38:07.000Z"); return t}()),
	// 	ID: to.Ptr("/subscriptions/6d875e77-e412-4d7d-9af4-8895278b4443/resourceGroups/test-rg/providers/Microsoft.Workloads/sapVirtualInstances/X00/centralInstances/centralServer"),
	// 	StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-08-19T03:36:07.000Z"); return t}()),
	// 	Status: to.Ptr("Succeeded"),
	// }
}
