/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.pertable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;

public class PerTable {
    protected final int mNumAtoms = 120;
    protected Vector mTable = new Vector(120);
    protected HashMap mSymHash = new HashMap(120);
    protected HashMap mNameHash = new HashMap(120);
    protected int[][] mWebTable = new int[9][18];
    protected static PerTable thePerTable = null;

    public static PerTable getPerTable() {
        if (thePerTable == null) {
            thePerTable = new PerTable();
        }
        return thePerTable;
    }

    public PerTable() {
        InputStream instr = this.getClass().getResourceAsStream("/org/scidac/cmcs/tools/pertable/AtomicElements.dat");
        BufferedReader lineBuffer = new BufferedReader(new InputStreamReader(instr));
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 18; ++j) {
                this.mWebTable[i][j] = 0;
            }
        }
        try {
            String a;
            int atomicNumber = 0;
            while ((a = lineBuffer.readLine()) != null) {
                String b = a.trim();
                if (b.startsWith("#") || b.length() == 0) continue;
                Element elt = new Element(atomicNumber, b);
                this.mTable.add(elt);
                this.mSymHash.put(elt.symbol.toLowerCase(), elt);
                this.mNameHash.put(elt.name.toLowerCase(), elt);
                ++atomicNumber;
            }
            lineBuffer.close();
            instr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mWebTable[8][1] = 0;
    }

    public int numAtoms() {
        return 120;
    }

    public int atomicNumber(String atomicSymbol) {
        return ((Element)this.mSymHash.get((Object)atomicSymbol.toLowerCase())).number;
    }

    public boolean isValid(String atomicSymbol) {
        return this.mSymHash.get(atomicSymbol.toLowerCase()) != null;
    }

    public boolean isValid(int atomicNumber) {
        return atomicNumber >= 0 && atomicNumber < 120;
    }

    public String atomicSymbol(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).symbol;
    }

    public String atomicSymbol(String atomicName) {
        String symbol = null;
        for (int i = 0; i < 120; ++i) {
            String name = ((Element)this.mTable.get((int)i)).name;
            if (!name.equals(atomicName)) continue;
            symbol = ((Element)this.mTable.get((int)i)).symbol;
            break;
        }
        return symbol;
    }

    public int row(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).row;
    }

    public int column(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).col;
    }

    public String color(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).color;
    }

    public String formatSymbol(String symbol) {
        if (symbol == null) {
            return null;
        }
        int delta = 32;
        char[] tmp = symbol.toCharArray();
        if (tmp[0] >= 'a' && tmp[0] <= 'z') {
            tmp[0] = (char)(tmp[0] - delta);
        }
        for (int idx = 1; idx < tmp.length; ++idx) {
            if (tmp[idx] < 'A' || tmp[idx] > 'Z') continue;
            int n = idx;
            tmp[n] = (char)(tmp[n] + delta);
        }
        return new String(tmp);
    }

    public String name(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).name;
    }

    public double atomicWeight(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).weight;
    }

    public String electronAffinity(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).affinity;
    }

    public String state(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).state;
    }

    public String metal(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).metal;
    }

    public double meltingPoint(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).melting;
    }

    public double boilingPoint(int atomicNumber) {
        return ((Element)this.mTable.get((int)atomicNumber)).boiling;
    }

    public int getAtomNumByPos(int row, int col) {
        return this.mWebTable[row - 1][col - 1];
    }

    public String getAtomSymByPos(int row, int col) {
        return this.atomicSymbol(this.mWebTable[row - 1][col - 1]);
    }

    public int getAtomNumByName(String name) {
        return ((Element)this.mNameHash.get((Object)name.toLowerCase())).number;
    }

    public String getAtomSymByName(String name) {
        return ((Element)this.mNameHash.get((Object)name.toLowerCase())).symbol;
    }

    private class Element {
        int number;
        String symbol;
        String name;
        int row;
        int col;
        String state;
        String metal;
        String color;
        String affinity;
        double weight;
        double boiling;
        double melting;
        double cr;
        double crt;

        public Element(int atomicNumber, String data) {
            this.number = atomicNumber;
            this.symbol = data.substring(0, data.indexOf(58));
            String[] tokens = data.substring(data.indexOf(58) + 2).split(",");
            this.name = tokens[0];
            this.row = Integer.parseInt(tokens[1]);
            this.col = Integer.parseInt(tokens[2]);
            this.state = tokens[3];
            this.metal = tokens[4];
            this.color = tokens[5];
            this.affinity = tokens[6];
            this.weight = Double.parseDouble(tokens[7]);
            this.boiling = Double.parseDouble(tokens[9]);
            this.melting = Double.parseDouble(tokens[10]);
            this.cr = Double.parseDouble(tokens[11]);
            this.crt = Double.parseDouble(tokens[12]);
            PerTable.this.mWebTable[this.row - 1][this.col - 1] = atomicNumber;
        }
    }
}

