# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, AsyncIterable, AsyncIterator, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._serialization import Deserializer, Serializer
from ...operations._replication_protected_items_operations import (
    build_add_disks_request,
    build_apply_recovery_point_request,
    build_create_request,
    build_delete_request,
    build_failover_cancel_request,
    build_failover_commit_request,
    build_get_request,
    build_list_by_replication_protection_containers_request,
    build_list_request,
    build_planned_failover_request,
    build_purge_request,
    build_remove_disks_request,
    build_repair_replication_request,
    build_reprotect_request,
    build_resolve_health_errors_request,
    build_switch_provider_request,
    build_test_failover_cleanup_request,
    build_test_failover_request,
    build_unplanned_failover_request,
    build_update_appliance_request,
    build_update_mobility_service_request,
    build_update_request,
)
from .._configuration import SiteRecoveryManagementClientConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ReplicationProtectedItemsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.recoveryservicessiterecovery.aio.SiteRecoveryManagementClient`'s
        :attr:`replication_protected_items` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: SiteRecoveryManagementClientConfiguration = (
            input_args.pop(0) if input_args else kwargs.pop("config")
        )
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list_by_replication_protection_containers(  # pylint: disable=name-too-long
        self, fabric_name: str, protection_container_name: str, **kwargs: Any
    ) -> AsyncIterable["_models.ReplicationProtectedItem"]:
        """Gets the list of Replication protected items.

        Gets the list of ASR replication protected items in the protection container.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :return: An iterator like instance of either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectedItemCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_by_replication_protection_containers_request(
                    fabric_name=fabric_name,
                    protection_container_name=protection_container_name,
                    resource_group_name=self._config.resource_group_name,
                    resource_name=self._config.resource_name,
                    subscription_id=self._config.subscription_id,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> _models.ReplicationProtectedItem:
        """Gets the details of a Replication protected item.

        Gets the details of an ASR replication protected item.

        :param fabric_name: Fabric unique name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :return: ReplicationProtectedItem or the result of cls(response)
        :rtype: ~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)

        _request = build_get_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: Union[_models.EnableProtectionInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(input, (IOBase, bytes)):
            _content = input
        else:
            _json = self._serialize.body(input, "EnableProtectionInput")

        _request = build_create_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: _models.EnableProtectionInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Enables protection.

        The operation to create an ASR replication protected item (Enable replication).

        :param fabric_name: Name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: A name for the replication protected item. Required.
        :type replicated_protected_item_name: str
        :param input: Enable Protection Input. Required.
        :type input: ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Enables protection.

        The operation to create an ASR replication protected item (Enable replication).

        :param fabric_name: Name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: A name for the replication protected item. Required.
        :type replicated_protected_item_name: str
        :param input: Enable Protection Input. Required.
        :type input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_create(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        input: Union[_models.EnableProtectionInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Enables protection.

        The operation to create an ASR replication protected item (Enable replication).

        :param fabric_name: Name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: A name for the replication protected item. Required.
        :type replicated_protected_item_name: str
        :param input: Enable Protection Input. Is either a EnableProtectionInput type or a IO[bytes]
         type. Required.
        :type input: ~azure.mgmt.recoveryservicessiterecovery.models.EnableProtectionInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                input=input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _purge_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_purge_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_purge(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Purges protection.

        The operation to delete or purge a replication protected item. This operation will force delete
        the replication protected item. Use the remove operation on replication protected item to
        perform a clean disable replication for the item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._purge_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _update_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: Union[_models.UpdateReplicationProtectedItemInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(update_protection_input, (IOBase, bytes)):
            _content = update_protection_input
        else:
            _json = self._serialize.body(update_protection_input, "UpdateReplicationProtectedItemInput")

        _request = build_update_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: _models.UpdateReplicationProtectedItemInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Updates the replication protected item settings.

        The operation to update the recovery settings of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param update_protection_input: Update protection input. Required.
        :type update_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateReplicationProtectedItemInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Updates the replication protected item settings.

        The operation to update the recovery settings of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param update_protection_input: Update protection input. Required.
        :type update_protection_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_protection_input: Union[_models.UpdateReplicationProtectedItemInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Updates the replication protected item settings.

        The operation to update the recovery settings of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param update_protection_input: Update protection input. Is either a
         UpdateReplicationProtectedItemInput type or a IO[bytes] type. Required.
        :type update_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateReplicationProtectedItemInput or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                update_protection_input=update_protection_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _add_disks_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: Union[_models.AddDisksInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(add_disks_input, (IOBase, bytes)):
            _content = add_disks_input
        else:
            _json = self._serialize.body(add_disks_input, "AddDisksInput")

        _request = build_add_disks_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_add_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: _models.AddDisksInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Add disk(s) for protection.

        Operation to add disks(s) to the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param add_disks_input: Add disks input. Required.
        :type add_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_add_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Add disk(s) for protection.

        Operation to add disks(s) to the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param add_disks_input: Add disks input. Required.
        :type add_disks_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_add_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        add_disks_input: Union[_models.AddDisksInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Add disk(s) for protection.

        Operation to add disks(s) to the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param add_disks_input: Add disks input. Is either a AddDisksInput type or a IO[bytes] type.
         Required.
        :type add_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.AddDisksInput or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._add_disks_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                add_disks_input=add_disks_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _apply_recovery_point_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: Union[_models.ApplyRecoveryPointInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(apply_recovery_point_input, (IOBase, bytes)):
            _content = apply_recovery_point_input
        else:
            _json = self._serialize.body(apply_recovery_point_input, "ApplyRecoveryPointInput")

        _request = build_apply_recovery_point_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_apply_recovery_point(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: _models.ApplyRecoveryPointInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Change or apply recovery point.

        The operation to change the recovery point of a failed over replication protected item.

        :param fabric_name: The ARM fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: The protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The replicated protected item name. Required.
        :type replicated_protected_item_name: str
        :param apply_recovery_point_input: The ApplyRecoveryPointInput. Required.
        :type apply_recovery_point_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_apply_recovery_point(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Change or apply recovery point.

        The operation to change the recovery point of a failed over replication protected item.

        :param fabric_name: The ARM fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: The protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The replicated protected item name. Required.
        :type replicated_protected_item_name: str
        :param apply_recovery_point_input: The ApplyRecoveryPointInput. Required.
        :type apply_recovery_point_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_apply_recovery_point(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        apply_recovery_point_input: Union[_models.ApplyRecoveryPointInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Change or apply recovery point.

        The operation to change the recovery point of a failed over replication protected item.

        :param fabric_name: The ARM fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: The protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The replicated protected item name. Required.
        :type replicated_protected_item_name: str
        :param apply_recovery_point_input: The ApplyRecoveryPointInput. Is either a
         ApplyRecoveryPointInput type or a IO[bytes] type. Required.
        :type apply_recovery_point_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.ApplyRecoveryPointInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._apply_recovery_point_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                apply_recovery_point_input=apply_recovery_point_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _failover_cancel_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_failover_cancel_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_failover_cancel(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute cancel failover.

        Operation to cancel the failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._failover_cancel_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _failover_commit_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_failover_commit_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_failover_commit(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute commit failover.

        Operation to commit the failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._failover_commit_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _planned_failover_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.PlannedFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(failover_input, (IOBase, bytes)):
            _content = failover_input
        else:
            _json = self._serialize.body(failover_input, "PlannedFailoverInput")

        _request = build_planned_failover_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_planned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: _models.PlannedFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute planned failover.

        Operation to initiate a planned failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Planned failover input. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_planned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute planned failover.

        Operation to initiate a planned failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Planned failover input. Required.
        :type failover_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_planned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.PlannedFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute planned failover.

        Operation to initiate a planned failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Planned failover input. Is either a PlannedFailoverInput type or a
         IO[bytes] type. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.PlannedFailoverInput or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._planned_failover_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                failover_input=failover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: Union[_models.DisableProtectionInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(disable_protection_input, (IOBase, bytes)):
            _content = disable_protection_input
        else:
            _json = self._serialize.body(disable_protection_input, "DisableProtectionInput")

        _request = build_delete_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_delete(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: _models.DisableProtectionInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Disables protection.

        The operation to disable replication on a replication protected item. This will also remove the
        item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param disable_protection_input: Disable protection input. Required.
        :type disable_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_delete(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Disables protection.

        The operation to disable replication on a replication protected item. This will also remove the
        item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param disable_protection_input: Disable protection input. Required.
        :type disable_protection_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_delete(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        disable_protection_input: Union[_models.DisableProtectionInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[None]:
        """Disables protection.

        The operation to disable replication on a replication protected item. This will also remove the
        item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param disable_protection_input: Disable protection input. Is either a DisableProtectionInput
         type or a IO[bytes] type. Required.
        :type disable_protection_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.DisableProtectionInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                disable_protection_input=disable_protection_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    async def _remove_disks_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: Union[_models.RemoveDisksInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(remove_disks_input, (IOBase, bytes)):
            _content = remove_disks_input
        else:
            _json = self._serialize.body(remove_disks_input, "RemoveDisksInput")

        _request = build_remove_disks_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_remove_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: _models.RemoveDisksInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Removes disk(s).

        Operation to remove disk(s) from the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param remove_disks_input: Remove disks input. Required.
        :type remove_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.RemoveDisksInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_remove_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Removes disk(s).

        Operation to remove disk(s) from the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param remove_disks_input: Remove disks input. Required.
        :type remove_disks_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_remove_disks(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        remove_disks_input: Union[_models.RemoveDisksInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Removes disk(s).

        Operation to remove disk(s) from the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param remove_disks_input: Remove disks input. Is either a RemoveDisksInput type or a IO[bytes]
         type. Required.
        :type remove_disks_input: ~azure.mgmt.recoveryservicessiterecovery.models.RemoveDisksInput or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._remove_disks_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                remove_disks_input=remove_disks_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _repair_replication_initial(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_repair_replication_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_repair_replication(
        self, fabric_name: str, protection_container_name: str, replicated_protected_item_name: str, **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Resynchronize or repair replication.

        The operation to start resynchronize/repair replication for a replication protected item
        requiring resynchronization.

        :param fabric_name: The name of the fabric. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the replication protected item. Required.
        :type replicated_protected_item_name: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._repair_replication_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _reprotect_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: Union[_models.ReverseReplicationInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(reprotect_input, (IOBase, bytes)):
            _content = reprotect_input
        else:
            _json = self._serialize.body(reprotect_input, "ReverseReplicationInput")

        _request = build_reprotect_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_reprotect(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: _models.ReverseReplicationInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute Reverse Replication\\Reprotect.

        Operation to reprotect or reverse replicate a failed over replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param reprotect_input: Reverse replication input. Required.
        :type reprotect_input: ~azure.mgmt.recoveryservicessiterecovery.models.ReverseReplicationInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_reprotect(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute Reverse Replication\\Reprotect.

        Operation to reprotect or reverse replicate a failed over replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param reprotect_input: Reverse replication input. Required.
        :type reprotect_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_reprotect(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        reprotect_input: Union[_models.ReverseReplicationInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute Reverse Replication\\Reprotect.

        Operation to reprotect or reverse replicate a failed over replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param reprotect_input: Reverse replication input. Is either a ReverseReplicationInput type or
         a IO[bytes] type. Required.
        :type reprotect_input: ~azure.mgmt.recoveryservicessiterecovery.models.ReverseReplicationInput
         or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._reprotect_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                reprotect_input=reprotect_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _resolve_health_errors_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: Union[_models.ResolveHealthInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(resolve_health_input, (IOBase, bytes)):
            _content = resolve_health_input
        else:
            _json = self._serialize.body(resolve_health_input, "ResolveHealthInput")

        _request = build_resolve_health_errors_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_resolve_health_errors(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: _models.ResolveHealthInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Resolve health errors.

        Operation to resolve health issues of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param resolve_health_input: Health issue input object. Required.
        :type resolve_health_input: ~azure.mgmt.recoveryservicessiterecovery.models.ResolveHealthInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_resolve_health_errors(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Resolve health errors.

        Operation to resolve health issues of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param resolve_health_input: Health issue input object. Required.
        :type resolve_health_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_resolve_health_errors(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        resolve_health_input: Union[_models.ResolveHealthInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Resolve health errors.

        Operation to resolve health issues of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param resolve_health_input: Health issue input object. Is either a ResolveHealthInput type or
         a IO[bytes] type. Required.
        :type resolve_health_input: ~azure.mgmt.recoveryservicessiterecovery.models.ResolveHealthInput
         or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._resolve_health_errors_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                resolve_health_input=resolve_health_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _switch_provider_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: Union[_models.SwitchProviderInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(switch_provider_input, (IOBase, bytes)):
            _content = switch_provider_input
        else:
            _json = self._serialize.body(switch_provider_input, "SwitchProviderInput")

        _request = build_switch_provider_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_switch_provider(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: _models.SwitchProviderInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute switch provider.

        Operation to initiate a switch provider of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param switch_provider_input: Switch provider input. Required.
        :type switch_provider_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.SwitchProviderInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_switch_provider(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute switch provider.

        Operation to initiate a switch provider of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param switch_provider_input: Switch provider input. Required.
        :type switch_provider_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_switch_provider(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        switch_provider_input: Union[_models.SwitchProviderInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute switch provider.

        Operation to initiate a switch provider of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param switch_provider_input: Switch provider input. Is either a SwitchProviderInput type or a
         IO[bytes] type. Required.
        :type switch_provider_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.SwitchProviderInput or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._switch_provider_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                switch_provider_input=switch_provider_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod,
                AsyncARMPolling(lro_delay, lro_options={"final-state-via": "azure-async-operation"}, **kwargs),
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _test_failover_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: Union[_models.TestFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(testfailover_input, (IOBase, bytes)):
            _content = testfailover_input
        else:
            _json = self._serialize.body(testfailover_input, "TestFailoverInput")

        _request = build_test_failover_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_test_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: _models.TestFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover.

        Operation to perform a test failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param testfailover_input: Test failover input. Required.
        :type testfailover_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_test_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover.

        Operation to perform a test failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param testfailover_input: Test failover input. Required.
        :type testfailover_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_test_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        testfailover_input: Union[_models.TestFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover.

        Operation to perform a test failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param testfailover_input: Test failover input. Is either a TestFailoverInput type or a
         IO[bytes] type. Required.
        :type testfailover_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverInput or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._test_failover_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                testfailover_input=testfailover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _test_failover_cleanup_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: Union[_models.TestFailoverCleanupInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(cleanup_input, (IOBase, bytes)):
            _content = cleanup_input
        else:
            _json = self._serialize.body(cleanup_input, "TestFailoverCleanupInput")

        _request = build_test_failover_cleanup_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_test_failover_cleanup(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: _models.TestFailoverCleanupInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover cleanup.

        Operation to clean up the test failover of a replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param cleanup_input: Test failover cleanup input. Required.
        :type cleanup_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverCleanupInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_test_failover_cleanup(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover cleanup.

        Operation to clean up the test failover of a replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param cleanup_input: Test failover cleanup input. Required.
        :type cleanup_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_test_failover_cleanup(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        cleanup_input: Union[_models.TestFailoverCleanupInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute test failover cleanup.

        Operation to clean up the test failover of a replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param cleanup_input: Test failover cleanup input. Is either a TestFailoverCleanupInput type or
         a IO[bytes] type. Required.
        :type cleanup_input: ~azure.mgmt.recoveryservicessiterecovery.models.TestFailoverCleanupInput
         or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._test_failover_cleanup_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                cleanup_input=cleanup_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _unplanned_failover_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.UnplannedFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(failover_input, (IOBase, bytes)):
            _content = failover_input
        else:
            _json = self._serialize.body(failover_input, "UnplannedFailoverInput")

        _request = build_unplanned_failover_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_unplanned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: _models.UnplannedFailoverInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute unplanned failover.

        Operation to initiate a failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Failover input. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.UnplannedFailoverInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_unplanned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute unplanned failover.

        Operation to initiate a failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Failover input. Required.
        :type failover_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_unplanned_failover(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        failover_input: Union[_models.UnplannedFailoverInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Execute unplanned failover.

        Operation to initiate a failover of the replication protected item.

        :param fabric_name: Unique fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param failover_input: Failover input. Is either a UnplannedFailoverInput type or a IO[bytes]
         type. Required.
        :type failover_input: ~azure.mgmt.recoveryservicessiterecovery.models.UnplannedFailoverInput or
         IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._unplanned_failover_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                failover_input=failover_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_appliance_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: Union[_models.UpdateApplianceForReplicationProtectedItemInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(appliance_update_input, (IOBase, bytes)):
            _content = appliance_update_input
        else:
            _json = self._serialize.body(appliance_update_input, "UpdateApplianceForReplicationProtectedItemInput")

        _request = build_update_appliance_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_appliance(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: _models.UpdateApplianceForReplicationProtectedItemInput,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Updates appliance for replication protected Item.

        The operation to update appliance of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param appliance_update_input: Appliance update protection input. Required.
        :type appliance_update_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateApplianceForReplicationProtectedItemInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_appliance(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Updates appliance for replication protected Item.

        The operation to update appliance of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param appliance_update_input: Appliance update protection input. Required.
        :type appliance_update_input: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_appliance(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        appliance_update_input: Union[_models.UpdateApplianceForReplicationProtectedItemInput, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Updates appliance for replication protected Item.

        The operation to update appliance of an ASR replication protected item.

        :param fabric_name: Fabric name. Required.
        :type fabric_name: str
        :param protection_container_name: Protection container name. Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: Replication protected item name. Required.
        :type replicated_protected_item_name: str
        :param appliance_update_input: Appliance update protection input. Is either a
         UpdateApplianceForReplicationProtectedItemInput type or a IO[bytes] type. Required.
        :type appliance_update_input:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateApplianceForReplicationProtectedItemInput
         or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_appliance_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                appliance_update_input=appliance_update_input,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_mobility_service_initial(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: Union[_models.UpdateMobilityServiceRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(update_mobility_service_request, (IOBase, bytes)):
            _content = update_mobility_service_request
        else:
            _json = self._serialize.body(update_mobility_service_request, "UpdateMobilityServiceRequest")

        _request = build_update_mobility_service_request(
            fabric_name=fabric_name,
            protection_container_name=protection_container_name,
            replicated_protected_item_name=replicated_protected_item_name,
            resource_group_name=self._config.resource_group_name,
            resource_name=self._config.resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _decompress = kwargs.pop("decompress", True)
        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))

        deserialized = response.stream_download(self._client._pipeline, decompress=_decompress)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update_mobility_service(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: _models.UpdateMobilityServiceRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Update the mobility service on a protected item.

        The operation to update(push update) the installed mobility service software on a replication
        protected item to the latest available version.

        :param fabric_name: The name of the fabric containing the protected item. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container containing the protected item.
         Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the protected item on which the agent is to
         be updated. Required.
        :type replicated_protected_item_name: str
        :param update_mobility_service_request: Request to update the mobility service on the protected
         item. Required.
        :type update_mobility_service_request:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMobilityServiceRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def begin_update_mobility_service(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Update the mobility service on a protected item.

        The operation to update(push update) the installed mobility service software on a replication
        protected item to the latest available version.

        :param fabric_name: The name of the fabric containing the protected item. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container containing the protected item.
         Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the protected item on which the agent is to
         be updated. Required.
        :type replicated_protected_item_name: str
        :param update_mobility_service_request: Request to update the mobility service on the protected
         item. Required.
        :type update_mobility_service_request: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def begin_update_mobility_service(
        self,
        fabric_name: str,
        protection_container_name: str,
        replicated_protected_item_name: str,
        update_mobility_service_request: Union[_models.UpdateMobilityServiceRequest, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.ReplicationProtectedItem]:
        """Update the mobility service on a protected item.

        The operation to update(push update) the installed mobility service software on a replication
        protected item to the latest available version.

        :param fabric_name: The name of the fabric containing the protected item. Required.
        :type fabric_name: str
        :param protection_container_name: The name of the container containing the protected item.
         Required.
        :type protection_container_name: str
        :param replicated_protected_item_name: The name of the protected item on which the agent is to
         be updated. Required.
        :type replicated_protected_item_name: str
        :param update_mobility_service_request: Request to update the mobility service on the protected
         item. Is either a UpdateMobilityServiceRequest type or a IO[bytes] type. Required.
        :type update_mobility_service_request:
         ~azure.mgmt.recoveryservicessiterecovery.models.UpdateMobilityServiceRequest or IO[bytes]
        :return: An instance of AsyncLROPoller that returns either ReplicationProtectedItem or the
         result of cls(response)
        :rtype:
         ~azure.core.polling.AsyncLROPoller[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ReplicationProtectedItem] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_mobility_service_initial(
                fabric_name=fabric_name,
                protection_container_name=protection_container_name,
                replicated_protected_item_name=replicated_protected_item_name,
                update_mobility_service_request=update_mobility_service_request,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItem", pipeline_response.http_response)
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(
                AsyncPollingMethod, AsyncARMPolling(lro_delay, lro_options={"final-state-via": "location"}, **kwargs)
            )
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.ReplicationProtectedItem].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.ReplicationProtectedItem](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    @distributed_trace
    def list(
        self, skip_token: Optional[str] = None, filter: Optional[str] = None, **kwargs: Any
    ) -> AsyncIterable["_models.ReplicationProtectedItem"]:
        """Gets the list of replication protected items.

        Gets the list of ASR replication protected items in the vault.

        :param skip_token: The pagination token. Possible values: "FabricId" or "FabricId_CloudId" or
         null. Default value is None.
        :type skip_token: str
        :param filter: OData filter options. Default value is None.
        :type filter: str
        :return: An iterator like instance of either ReplicationProtectedItem or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.recoveryservicessiterecovery.models.ReplicationProtectedItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ReplicationProtectedItemCollection] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    resource_group_name=self._config.resource_group_name,
                    resource_name=self._config.resource_name,
                    subscription_id=self._config.subscription_id,
                    skip_token=skip_token,
                    filter=filter,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ReplicationProtectedItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
