/* Copyright (c) 2024-2025. The SimGrid Team. All rights reserved.          */

/* This program is free software; you can redistribute it and/or modify it
 * under the terms of the license (GNU LGPL) which comes with this package. */

package org.simgrid.s4u;

public class simgridJNI {
  public final static native void
  try_loading_some_symbols(long arg); // Dummy function to check whether simgrid-java is merged in libsimgrid
  public final static native void Actor_sleep_for(long jarg1, Actor jarg1_, double jarg2);
  public final static native void Actor_sleep_until(long jarg1, Actor jarg1_, double jarg2);
  public final static native void Actor_execute__SWIG_0(long jarg1, Actor jarg1_, double jarg2);
  public final static native void Actor_execute__SWIG_1(long jarg1, Actor jarg1_, double jarg2, double jarg3);
  public final static native void Actor_parallel_execute(long jarg1, Actor jarg1_, long[] hosts, double[] flops_amounts,
                                                         double[] bytes_amounts);
  public final static native void Actor_thread_execute(long jarg1, Actor jarg1_, long chost, Host jhost, double jarg3,
                                                       int jarg4);
  public final static native long Actor_exec_seq_init(long jarg1, Actor jarg1_, double jarg2);
  public final static native long Actor_exec_par_init(long jarg1, Actor jarg1_, long[] hosts, double[] flops_amounts,
                                                      double[] bytes_amounts);
  public final static native long Actor_exec_async(long jarg1, Actor jarg1_, double jarg2);
  public final static native void Actor_yield(long jarg1, Actor jarg1_);
  public final static native void Actor_exit(long cthis, Actor jthis);
  public final static native void Actor_on_exit(long cthis, CallbackBoolean jcode);
  public final static native Actor Actor_self();
  public final static native void Actor_on_this_suspend_cb(long jarg1, Actor jarg1_, CallbackActor cb);
  public final static native void Actor_on_this_resume_cb(long jarg1, Actor jarg1_, CallbackActor cb);
  public final static native void Actor_on_this_sleep_cb(long jarg1, Actor jarg1_, CallbackActor cb);
  public final static native void Actor_on_this_wake_up_cb(long jarg1, Actor jarg1_, CallbackActor cb);
  public final static native void Actor_on_this_host_change_cb(long jarg1, Actor jarg1_, CallbackActorHost cb);
  public final static native void Actor_daemonize(long jarg1, Actor jarg1_);
  public final static native boolean Actor_is_daemon(long jarg1, Actor jarg1_);
  public final static native String Actor_get_name(long jarg1, Actor jarg1_);
  public final static native long Actor_get_host(long jarg1, Actor jarg1_);
  public final static native int Actor_get_pid(long jarg1, Actor jarg1_);
  public final static native int Actor_get_ppid(long jarg1, Actor jarg1_);
  public final static native void Actor_suspend(long jarg1, Actor jarg1_);
  public final static native void Actor_resume(long jarg1, Actor jarg1_);
  public final static native boolean Actor_is_suspended(long jarg1, Actor jarg1_);
  public final static native void Actor_set_auto_restart(long jarg1, Actor jarg1_, boolean jarg2);
  public final static native int Actor_get_restart_count(long jarg1, Actor jarg1_);
  public final static native void Actor_set_kill_time(long jarg1, Actor jarg1_, double jarg2);
  public final static native double Actor_get_kill_time(long jarg1, Actor jarg1_);
  public final static native void Actor_set_host(long cthis, Actor jthis, long chost, Host jhost);
  public final static native void Actor_kill(long jarg1, Actor jarg1_);
  public final static native Actor Actor_by_pid(int jarg1);
  public final static native void Actor_join__SWIG_0(long jarg1, Actor jarg1_);
  public final static native void Actor_join__SWIG_1(long jarg1, Actor jarg1_, double jarg2);
  public final static native long Actor_restart(long jarg1, Actor jarg1_);
  public final static native void Actor_kill_all();
  public final static native String Actor_get_property(long jarg1, Actor jarg1_, String jarg2);
  public final static native void Actor_set_property(long jarg1, Actor jarg1_, String jarg2, String jarg3);
  public final static native long Actor_create(String jarg1, long chost, Host jhost, Actor jcode);
  public final static native void delete_Actor(long jarg1);
  public final static native String Activity_to_c_str(int jarg1);
  public final static native boolean Activity_is_assigned(long jarg1, Activity jarg1_);
  public final static native boolean Activity_dependencies_solved(long jarg1, Activity jarg1_);
  public final static native boolean Activity_has_no_successor(long jarg1, Activity jarg1_);
  public final static native Activity[] Activity_get_dependencies(long jarg1, Activity jarg1_);
  public final static native Activity[] Activity_get_successors(long jarg1, Activity jarg1_);
  public final static native void delete_Activity(long jarg1);
  public final static native void Activity_start(long jarg1, Activity jarg1_);
  public final static native boolean Activity_test(long jarg1, Activity jarg1_);
  public final static native void Activity_await_for(long jarg1, Activity jarg1_, double jarg2);
  public final static native void Activity_await_for_or_cancel(long jarg1, Activity jarg1_, double jarg2);
  public final static native void Activity_await_until(long jarg1, Activity jarg1_, double jarg2);
  public final static native void Activity_cancel(long jarg1, Activity jarg1_);
  public final static native int Activity_get_state(long jarg1, Activity jarg1_);
  public final static native String Activity_get_state_str(long jarg1, Activity jarg1_);
  public final static native boolean Activity_is_canceled(long jarg1, Activity jarg1_);
  public final static native boolean Activity_is_failed(long jarg1, Activity jarg1_);
  public final static native boolean Activity_is_done(long jarg1, Activity jarg1_);
  public final static native boolean Activity_is_detached(long jarg1, Activity jarg1_);
  public final static native void Activity_suspend(long jarg1, Activity jarg1_);
  public final static native void Activity_resume(long jarg1, Activity jarg1_);
  public final static native boolean Activity_is_suspended(long jarg1, Activity jarg1_);
  public final static native String Activity_get_name(long jarg1, Activity jarg1_);
  public final static native Object Activity_get_data(long swigCPtr);
  public final static native void Activity_set_data(long swigCPtr, Object o);
  public final static native double Activity_get_remaining(long jarg1, Activity jarg1_);
  public final static native double Activity_get_start_time(long jarg1, Activity jarg1_);
  public final static native double Activity_get_finish_time(long jarg1, Activity jarg1_);
  public final static native void Activity_mark(long jarg1, Activity jarg1_);
  public final static native boolean Activity_is_marked(long jarg1, Activity jarg1_);

  public final static native long new_ActivitySet();
  public final static native void delete_ActivitySet(long jarg1);
  public final static native void ActivitySet_push(long jarg1, ActivitySet jarg1_, long cactivity, Activity a);
  public final static native void ActivitySet_erase(long jarg1, ActivitySet jarg1_, long cactivity, Activity a);
  public final static native int ActivitySet_size(long jarg1, ActivitySet jarg1_);
  public final static native boolean ActivitySet_empty(long jarg1, ActivitySet jarg1_);
  public final static native void ActivitySet_clear(long jarg1, ActivitySet jarg1_);
  public final static native Activity ActivitySet_at(long jarg1, ActivitySet jarg1_, int index);
  public final static native void ActivitySet_await_all_for(long jarg1, ActivitySet jarg1_, double timeout);
  public final static native void ActivitySet_await_all(long jarg1, ActivitySet jarg1_);
  public final static native Activity ActivitySet_test_any(long jarg1, ActivitySet jarg1_);
  public final static native Activity ActivitySet_await_any_for(long jarg1, ActivitySet jarg1_, double timeout);
  public final static native Activity ActivitySet_await_any(long jarg1, ActivitySet jarg1_);
  public final static native Activity ActivitySet_get_failed_activity(long jarg1, ActivitySet jarg1_);
  public final static native boolean ActivitySet_has_failed_activity(long jarg1, ActivitySet jarg1_);

  public final static native void Comm_on_start_cb(CallbackComm cb);
  public final static native void Comm_on_this_start_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_on_completion_cb(CallbackComm cb);
  public final static native void Comm_on_this_completion_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_on_this_suspend_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_on_this_resume_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_on_veto_cb(CallbackComm cb);
  public final static native void Comm_on_this_veto_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_add_successor(long jarg1, Comm jarg1_, long jarg2, Activity jarg2_);
  public final static native void Comm_remove_successor(long jarg1, Comm jarg1_, long jarg2, Activity jarg2_);
  public final static native void Comm_set_name(long jarg1, Comm jarg1_, String jarg2);
  public final static native String Comm_get_name(long jarg1, Comm jarg1_);
  public final static native void Comm_set_tracing_category(long jarg1, Comm jarg1_, String jarg2);
  public final static native String Comm_get_tracing_category(long jarg1, Comm jarg1_);
  public final static native void Comm_detach__SWIG_0(long jarg1, Comm jarg1_);
  public final static native void Comm_detach__SWIG_1(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_cancel(long jarg1, Comm jarg1_);
  public final static native void Comm_on_send_cb(CallbackComm cb);
  public final static native void Comm_on_this_send_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native void Comm_on_recv_cb(CallbackComm cb);
  public final static native void Comm_on_this_recv_cb(long jarg1, Comm jarg1_, CallbackComm cb);
  public final static native long Comm_sendto_init__SWIG_0();
  public final static native long Comm_sendto_init__SWIG_1(long jarg1, Host jarg1_, long jarg2, Host jarg2_);
  public final static native long Comm_sendto_async(long jarg1, Host jarg1_, long jarg2, Host jarg2_, long jarg3);
  public final static native void Comm_sendto(long jarg1, Host jarg1_, long jarg2, Host jarg2_, long jarg3);
  public final static native void Comm_set_source(long jarg1, Comm jarg1_, long jarg2, Host jarg2_);
  public final static native long Comm_get_source(long jarg1, Comm jarg1_);
  public final static native void Comm_set_destination(long jarg1, Comm jarg1_, long jarg2, Host jarg2_);
  public final static native long Comm_get_destination(long jarg1, Comm jarg1_);
  public final static native void Comm_set_mailbox(long jarg1, Comm jarg1_, long jarg2, Mailbox jarg2_);
  public final static native long Comm_get_mailbox(long jarg1, Comm jarg1_);
  public final static native void Comm_set_src_data(long jarg1, Comm jarg1_, Object payload);
  public final static native Object Comm_get_payload(long jarg1, Comm jarg1_);
  public final static native void Comm_set_payload_size(long jarg1, Comm jarg1_, long jarg2);
  public final static native void Comm_set_rate(long jarg1, Comm jarg1_, double jarg2);
  public final static native boolean Comm_is_assigned(long jarg1, Comm jarg1_);
  public final static native Actor Comm_get_sender(long jarg1, Comm jarg1_);
  public final static native Actor Comm_get_receiver(long jarg1, Comm jarg1_);
  public final static native void Comm_await_for(long jarg1, Comm jarg1_, double jarg2);

  public final static native void Exec_on_start_cb(CallbackExec cb);
  public final static native void Exec_on_this_start_cb(long jarg1, Exec jarg1_, CallbackExec cb);
  public final static native void Exec_on_completion_cb(CallbackExec cb);
  public final static native void Exec_on_this_completion_cb(long jarg1, Exec jarg1_, CallbackExec cb);
  public final static native void Exec_on_this_suspend_cb(long jarg1, Exec jarg1_, CallbackExec cb);
  public final static native void Exec_on_this_resume_cb(long jarg1, Exec jarg1_, CallbackExec cb);
  public final static native void Exec_on_veto_cb(CallbackExec cb);
  public final static native void Exec_on_this_veto_cb(long jarg1, Exec jarg1_, CallbackExec cb);
  public final static native void Exec_add_successor(long jarg1, Exec jarg1_, long jarg2, Activity jarg2_);
  public final static native void Exec_remove_successor(long jarg1, Exec jarg1_, long jarg2, Activity jarg2_);
  public final static native void Exec_set_name(long jarg1, Exec jarg1_, String jarg2);
  public final static native String Exec_get_name(long jarg1, Exec jarg1_);
  public final static native void Exec_set_tracing_category(long jarg1, Exec jarg1_, String jarg2);
  public final static native String Exec_get_tracing_category(long jarg1, Exec jarg1_);
  public final static native void Exec_detach__SWIG_0(long jarg1, Exec jarg1_);
  public final static native void Exec_detach__SWIG_1(long jarg1, Exec jarg1_, CallbackExec cb);
  public final static native void Exec_cancel(long jarg1, Exec jarg1_);
  public final static native void Exec_await_for(long jarg1, Exec jarg1_, double jarg2);
  public final static native void Io_on_start_cb(CallbackIo cb);
  public final static native void Io_on_this_start_cb(long jarg1, Io jarg1_, CallbackIo cb);
  public final static native void Io_on_completion_cb(CallbackIo cb);
  public final static native void Io_on_this_completion_cb(long jarg1, Io jarg1_, CallbackIo cb);
  public final static native void Io_on_this_suspend_cb(long jarg1, Io jarg1_, CallbackIo cb);
  public final static native void Io_on_this_resume_cb(long jarg1, Io jarg1_, CallbackIo cb);
  public final static native void Io_on_veto_cb(CallbackIo cb);
  public final static native void Io_on_this_veto_cb(long jarg1, Io jarg1_, CallbackIo cb);
  public final static native void Io_add_successor(long jarg1, Io jarg1_, long jarg2, Activity jarg2_);
  public final static native void Io_remove_successor(long jarg1, Io jarg1_, long jarg2, Activity jarg2_);
  public final static native void Io_set_name(long jarg1, Io jarg1_, String jarg2);
  public final static native String Io_get_name(long jarg1, Io jarg1_);
  public final static native void Io_set_tracing_category(long jarg1, Io jarg1_, String jarg2);
  public final static native String Io_get_tracing_category(long jarg1, Io jarg1_);
  public final static native void Io_detach__SWIG_0(long jarg1, Io jarg1_);
  public final static native void Io_detach__SWIG_1(long jarg1, Io jarg1_, CallbackIo cb);
  public final static native void Io_cancel(long jarg1, Io jarg1_);
  public final static native void Io_await_for(long jarg1, Io jarg1_, double jarg2);
  public final static native long Barrier_create(long jarg1);
  public final static native String Barrier_to_string(long jarg1, Barrier jarg1_);
  public final static native void delete_Barrier(long jarg1);
  public final static native boolean Barrier_await(long jarg1, Barrier jarg1_);
  public final static native void delete_ConditionVariable(long jarg1);
  public final static native long ConditionVariable_create();
  public final static native void ConditionVariable_await_until(long jarg1, ConditionVariable jarg1_, long cmutex,
                                                                Mutex jmutex, double jarg3) throws TimeoutException;
  public final static native void ConditionVariable_await_for(long jarg1, ConditionVariable jarg1_, long cmutex,
                                                              Mutex jmutex, double jarg3) throws TimeoutException;
  public final static native void ConditionVariable_notify_one(long jarg1, ConditionVariable jarg1_);
  public final static native void ConditionVariable_notify_all(long jarg1, ConditionVariable jarg1_);
  public final static native String Disk_get_name(long jarg1, Disk jarg1_);
  public final static native void Disk_set_read_bandwidth(long jarg1, Disk jarg1_, double jarg2);
  public final static native double Disk_get_read_bandwidth(long jarg1, Disk jarg1_);
  public final static native void Disk_set_write_bandwidth(long jarg1, Disk jarg1_, double jarg2);
  public final static native double Disk_get_write_bandwidth(long jarg1, Disk jarg1_);
  public final static native void Disk_set_readwrite_bandwidth(long jarg1, Disk jarg1_, double jarg2);
  public final static native String Disk_get_property(long jarg1, Disk jarg1_, String jarg2);
  public final static native void Disk_set_property(long jarg1, Disk jarg1_, String jarg2, String jarg3);
  public final static native void Disk_set_host(long jarg1, Disk jarg1_, long jarg2, Host jarg2_);
  public final static native long Disk_get_host(long jarg1, Disk jarg1_);
  public final static native void Disk_set_concurrency_limit(long jarg1, Disk jarg1_, int jarg2);
  public final static native int Disk_get_concurrency_limit(long jarg1, Disk jarg1_);
  public final static native long Disk_io_init(long jarg1, Disk jarg1_, int jarg2, int jarg3);
  public final static native long Disk_read_async(long jarg1, Disk jarg1_, long jarg2);
  public final static native long Disk_read__SWIG_0(long jarg1, Disk jarg1_, long jarg2);
  public final static native long Disk_read__SWIG_1(long jarg1, Disk jarg1_, long jarg2, double jarg3);
  public final static native long Disk_write_async(long jarg1, Disk jarg1_, long jarg2);
  public final static native long Disk_write__SWIG_0(long jarg1, Disk jarg1_, long jarg2);
  public final static native long Disk_write__SWIG_1(long jarg1, Disk jarg1_, long jarg2, double jarg3);
  public final static native int Disk_SharingPolicy_NONLINEAR_get();
  public final static native int Disk_SharingPolicy_LINEAR_get();
  public final static native int Disk_Operation_READ_get();
  public final static native int Disk_Operation_WRITE_get();
  public final static native int Disk_Operation_READWRITE_get();
  public final static native int Disk_get_sharing_policy(long jarg1, Disk jarg1_, int jarg2);
  public final static native Object Disk_get_data(long jarg1, Disk jarg1_);
  public final static native void Disk_set_data(long jarg1, Disk jarg1_, Object data);
  public final static native void Disk_seal(long jarg1, Disk jarg1_);
  public final static native void Disk_on_onoff_cb(CallbackDisk cb);
  public final static native void Disk_on_this_onoff_cb(long jarg1, Disk jarg1_, CallbackDisk cb);
  public final static native void Disk_on_read_bandwidth_change_cb(CallbackDisk cb);
  public final static native void Disk_on_this_read_bandwidth_change_cb(long jarg1, Disk jarg1_, CallbackDisk cb);
  public final static native void Disk_on_write_bandwidth_change_cb(CallbackDisk cb);
  public final static native void Disk_on_this_write_bandwidth_change_cb(long jarg1, Disk jarg1_, CallbackDisk cb);
  public final static native void Disk_on_destruction_cb(CallbackDisk cb);
  public final static native void Disk_on_this_destruction_cb(long jarg1, Disk jarg1_, CallbackDisk cb);
  public final static native long new_Engine(String[] jarg1);
  public final static native String[] Engine_get_args(long jarg1);
  public final static native void Engine_run(long jarg1, Engine jarg1_);
  public final static native void Engine_run_until(long jarg1, Engine jarg1_, double jarg2);
  public final static native double Engine_get_clock();
  public final static native long Engine_get_instance();
  public final static native void Engine_load_platform(long jarg1, Engine jarg1_, String jarg2);
  public final static native void Engine_seal_platform(long jarg1, Engine jarg1_);
  public final static native String Engine_flatify_platform(long jarg1, Engine jarg1_);
  public final static native void Engine_track_vetoed_activities(long cthis);
  public final static native Activity[] Engine_get_vetoed_activities(long cthis);
  public final static native void Engine_clear_vetoed_activities(long cthis);
  public final static native void Engine_load_deployment(long jarg1, String jarg2);
  public final static native long Engine_get_host_count(long jarg1, Engine jarg1_);
  public final static native Host[] Engine_get_all_hosts(long jarg1, Engine jarg1_);
  public final static native Host[] Engine_get_hosts_from_MPI_hostfile(long jarg1, Engine jarg1_, String jarg2);
  public final static native long Engine_host_by_name(long jarg1, Engine jarg1_, String jarg2);
  public final static native long Engine_get_link_count(long jarg1, Engine jarg1_);
  public final static native Link[] Engine_get_all_links(long jarg1, Engine jarg1_);
  public final static native long Engine_link_by_name(long jarg1, Engine jarg1_, String jarg2);
  public final static native long Engine_mailbox_by_name_or_create(long jarg1, Engine jarg1_, String jarg2);
  public final static native long Engine_message_queue_by_name_or_create(long jarg1, Engine jarg1_, String jarg2);
  public final static native long Engine_get_actor_count(long jarg1, Engine jarg1_);
  public final static native int Engine_get_actor_max_pid(long jarg1, Engine jarg1_);
  public final static native Actor[] Engine_get_all_actors(long jarg1, Engine jarg1_);
  public final static native long Engine_get_netzone_root(long jarg1, Engine jarg1_);
  public final static native NetZone[] Engine_get_all_netzones(long jarg1, Engine jarg1_);
  public final static native long Engine_netzone_by_name_or_null(long jarg1, Engine jarg1_, String jarg2);
  public final static native void Engine_set_config__SWIG_0(String jarg1);
  public final static native void Engine_set_config__SWIG_1(String jarg1, int jarg2);
  public final static native void Engine_set_config__SWIG_2(String jarg1, boolean jarg2);
  public final static native void Engine_set_config__SWIG_3(String jarg1, double jarg2);
  public final static native void Engine_set_config__SWIG_4(String jarg1, String jarg2);
  public final static native void Engine_plugin_vm_live_migration_init(long jarg1);
  public final static native void Engine_plugin_host_energy_init(long jarg1);
  public final static native void Engine_plugin_link_energy_init(long jarg1);
  public final static native void Engine_plugin_wifi_energy_init(long jarg1);
  public final static native void Engine_plugin_host_load_init(long jarg1);
  public final static native void Engine_plugin_link_load_init(long jarg1);
  public final static native void Engine_on_platform_created_cb(CallbackVoid jarg1);
  public final static native void Engine_on_platform_creation_cb(CallbackVoid jarg1);
  public final static native void Engine_on_simulation_start_cb(CallbackVoid jarg1);
  public final static native void Engine_on_simulation_end_cb(CallbackVoid jarg1);
  public final static native void Engine_on_time_advance_cb(CallbackDouble jarg1);
  public final static native void Engine_on_deadlock_cb(CallbackVoid jarg1);
  public final static native void Engine_die(String jarg1);
  public final static native void Engine_critical(String jarg1);
  public final static native void Engine_error(String jarg1);
  public final static native void Engine_warn(String jarg1);
  public final static native void Engine_info(String jarg1);
  public final static native void Engine_verbose(String jarg1);
  public final static native void Engine_debug(String jarg1);
  public final static native void delete_Engine(long jarg1);
  public final static native Activity[] create_DAG_from_dot(String jarg1);
  public final static native Activity[] create_DAG_from_DAX(String jarg1);
  public final static native Activity[] create_DAG_from_json(String jarg1);
  public final static native long Exec_init();
  public final static native double Exec_get_remaining(long jarg1, Exec jarg1_);
  public final static native double Exec_get_remaining_ratio(long jarg1, Exec jarg1_);
  public final static native void Exec_set_host(long jarg1, Exec jarg1_, long jarg2, Host jarg2_);
  public final static native void Exec_set_hosts(long jarg1, Exec jarg1_, long[] jarg2);
  public final static native void Exec_unset_host(long jarg1, Exec jarg1_);
  public final static native void Exec_unset_hosts(long jarg1, Exec jarg1_);
  public final static native void Exec_set_flops_amount(long jarg1, Exec jarg1_, double jarg2);
  public final static native void Exec_set_flops_amounts(long jarg1, Exec jarg1_, double[] jarg2);
  public final static native void Exec_set_bytes_amounts(long jarg1, Exec jarg1_, double[] jarg2);
  public final static native void Exec_set_thread_count(long jarg1, Exec jarg1_, int jarg2);
  public final static native void Exec_set_bound(long jarg1, Exec jarg1_, double jarg2);
  public final static native void Exec_set_priority(long jarg1, Exec jarg1_, double jarg2);
  public final static native void Exec_update_priority(long jarg1, Exec jarg1_, double jarg2);
  public final static native long Exec_get_host(long jarg1, Exec jarg1_);
  public final static native long Exec_get_host_number(long jarg1, Exec jarg1_);
  public final static native int Exec_get_thread_count(long jarg1, Exec jarg1_);
  public final static native double Exec_get_cost(long jarg1, Exec jarg1_);
  public final static native boolean Exec_is_parallel(long jarg1, Exec jarg1_);
  public final static native boolean Exec_is_assigned(long jarg1, Exec jarg1_);
  public final static native long Host_add_disk(long jarg1, Host jarg1_, String name, double read_bandwidth,
                                                   double write_bandwidth);
  public final static native Disk[] Host_get_disks(long jarg1, Host jarg1_);
  public final static native long Host_create_vm(long jarg1, Host jarg1_, String name, int core_amount);
  public final static native String Host_get_name(long jarg1, Host jarg1_);
  public final static native String[] Host_get_properties_names(long jarg1, Host jarg1_);
  public final static native String Host_get_property(long jarg1, Host jarg1_, String name);
  public final static native long Host_current();
  public final static native double Host_get_speed(long jarg1, Host jarg1_);
  public final static native int Host_get_pstate_count(long jarg1, Host jarg1_);
  public final static native double Host_get_pstate_speed(long jarg1, Host jarg1_, int pstate);
  public final static native double Host_get_load(long jarg1);
  public final static native int Host_get_core_count(long jarg1);
  public final static native boolean Host_is_on(long jarg1, Host jarg1_);
  public final static native void Host_turn_on(long jarg1);
  public final static native void Host_turn_off(long jarg1);
  public final static native int Host_get_pstate(long jarg1);
  public final static native void Host_set_pstate(long jarg1, int pstate);
  public final static native long Host_exec_init(long jarg1, double flops_amount);
  public final static native long Host_exec_async(long jarg1, double flops_amount);
  public final static native Link[] Host_route_links_to(long swigCPtr, long host);
  public final static native double Host_route_latency_to(long swigCPtr, long host);
  public final static native Object Host_get_data(long swigCPtr);
  public final static native void Host_set_data(long swigCPtr, Object o);
  public final static native void Host_set_concurrency_limit(long swigCPtr, int i);
  public final static native void Host_set_cpu_factor_cb(long swigCPtr, CallbackDHostDouble cb);
  public final static native double Host_get_consumed_energy(long swigCPtr);
  public final static native double Host_get_wattmax_at(long swigCPtr, int pstate);
  public final static native double Host_get_wattmin_at(long swigCPtr, int pstate);
  public final static native long Io_init();
  public final static native double Io_get_remaining(long jarg1, Io jarg1_);
  public final static native int Io_get_performed_ioops(long jarg1, Io jarg1_);
  public final static native void Io_set_disk(long jarg1, Io jarg1_, long jarg2, Disk jarg2_);
  public final static native void Io_set_priority(long jarg1, Io jarg1_, double jarg2);
  public final static native void Io_set_size(long jarg1, Io jarg1_, int jarg2);
  public final static native void Io_set_op_type(long jarg1, Io jarg1_, int jarg2);
  public final static native long Io_streamto_init(long jarg1, Host jarg1_, long jarg2, Disk jarg2_, long jarg3, Host jarg3_, long jarg4, Disk jarg4_);
  public final static native long Io_streamto_async(long jarg1, Host jarg1_, long jarg2, Disk jarg2_, long jarg3, Host jarg3_, long jarg4, Disk jarg4_, long jarg5);
  public final static native void Io_streamto(long jarg1, Host jarg1_, long jarg2, Disk jarg2_, long jarg3, Host jarg3_, long jarg4, Disk jarg4_, long jarg5);
  public final static native void Io_set_source(long jarg1, Io jarg1_, long jarg2, Host jarg2_, long jarg3,
                                                Disk jarg3_);
  public final static native void Io_set_destination(long jarg1, Io jarg1_, long jarg2, Host jarg2_, long jarg3,
                                                     Disk jarg3_);
  public final static native void Io_update_priority(long jarg1, Io jarg1_, double jarg2);
  public final static native boolean Io_is_assigned(long jarg1, Io jarg1_);
  public final static native int Link_SharingPolicy_NONLINEAR_get();
  public final static native int Link_SharingPolicy_WIFI_get();
  public final static native int Link_SharingPolicy_SPLITDUPLEX_get();
  public final static native int Link_SharingPolicy_SHARED_get();
  public final static native int Link_SharingPolicy_FATPIPE_get();
  public final static native String Link_get_name(long jarg1, Link jarg1_);
  public final static native double Link_get_bandwidth(long jarg1, Link jarg1_);
  public final static native void Link_set_bandwidth(long jarg1, Link jarg1_, double jarg2);
  public final static native double Link_get_latency(long jarg1, Link jarg1_);
  public final static native void Link_set_latency__SWIG_0(long jarg1, Link jarg1_, double jarg2);
  public final static native void Link_set_latency__SWIG_1(long jarg1, Link jarg1_, String jarg2);
  public final static native int Link_get_sharing_policy(long jarg1, Link jarg1_);
  public final static native String Link_get_property(long jarg1, Link jarg1_, String jarg2);
  public final static native void Link_set_property(long jarg1, Link jarg1_, String jarg2, String jarg3);
  public final static native void Link_set_concurrency_limit(long jarg1, Link jarg1_, int jarg2);
  public final static native int Link_get_concurrency_limit(long jarg1, Link jarg1_);
  public final static native void Link_set_host_wifi_rate(long jarg1, Link jarg1_, long jarg2, Host jarg2_, int jarg3);
  public final static native double Link_get_load(long jarg1, Link jarg1_);
  public final static native boolean Link_is_used(long jarg1, Link jarg1_);
  public final static native boolean Link_is_shared(long jarg1, Link jarg1_);
  public final static native void Link_turn_on(long jarg1, Link jarg1_);
  public final static native void Link_turn_off(long jarg1, Link jarg1_);
  public final static native boolean Link_is_on(long jarg1, Link jarg1_);
  public final static native void Link_seal(long jarg1, Link jarg1_);
  public final static native void Link_on_onoff_cb(CallbackLink cb);
  public final static native void Link_on_this_onoff_cb(long jarg1, Link jarg1_, CallbackLink cb);
  public final static native void Link_on_bandwidth_change_cb(CallbackLink cb);
  public final static native void Link_on_this_bandwidth_change_cb(long jarg1, Link jarg1_, CallbackLink cb);
  public final static native void Link_on_destruction_cb(CallbackLink cb);
  public final static native void Link_on_this_destruction_cb(long jarg1, Link jarg1_, CallbackLink cb);
  public final static native int LinkInRoute_Direction_UP_get();
  public final static native int LinkInRoute_Direction_DOWN_get();
  public final static native int LinkInRoute_Direction_NONE_get();
  public final static native long new_LinkInRoute__SWIG_0(long jarg1, Link jarg1_);
  public final static native long new_LinkInRoute__SWIG_1(long jarg1, Link jarg1_, int jarg2);
  public final static native int LinkInRoute_get_direction(long jarg1, LinkInRoute jarg1_);
  public final static native long LinkInRoute_get_link(long jarg1, LinkInRoute jarg1_);
  public final static native void delete_LinkInRoute(long jarg1);
  public final static native void Mess_set_queue(long cmess, Mess jmess, long cqueue, MessageQueue jqueue);
  public final static native long Mess_get_queue(long cmess, Mess jmess);
  public final static native void Mess_set_payload(long cmess, Mess jmess, Object payload);
  public final static native Object Mess_get_payload(long cmess, Mess jmess);
  public final static native Actor Mess_get_sender(long cmess, Mess jmess);
  public final static native boolean Mess_is_assigned(long cmess, Mess jmess);
  public final static native Actor Mess_get_receiver(long cmess, Mess jmess);
  public final static native void Mess_add_successor(long cmess, Mess jmess, long cactivity, Activity jActivity);
  public final static native void Mess_remove_successor(long cmess, Mess jmess, long cactivity, Activity jActivity);
  public final static native void Mess_set_name(long cmess, Mess jmess, String name);
  public final static native String Mess_get_name(long cmess, Mess jmess);
  public final static native void Mess_set_tracing_category(long cmess, Mess jmess, String category);
  public final static native String Mess_get_tracing_category(long cmess, Mess jmess);
  public final static native void Mess_cancel(long cmess, Mess jmess);
  public final static native void Mess_await_for(long cmess, Mess jmess, double timeout);
  public final static native String NetZone_get_name(long jarg1, NetZone jarg1_);
  public final static native long NetZone_get_parent(long jarg1, NetZone jarg1_);
  public final static native NetZone[] NetZone_get_children(long jarg1, NetZone jarg1_);
  public final static native Host[] NetZone_get_all_hosts(long jarg1, NetZone jarg1_);
  public final static native long NetZone_get_host_count(long jarg1, NetZone jarg1_);
  public final static native String NetZone_get_property(long jarg1, NetZone jarg1_, String jarg2);
  public final static native void NetZone_set_property(long jarg1, NetZone jarg1_, String jarg2, String jarg3);
  public final static native void NetZone_on_seal_cb(CallbackNetzone cb);
  public final static native long NetZone_add_host__SWIG_0(long jarg1, NetZone jarg1_, String jarg2, double[] jarg3);
  public final static native long NetZone_add_host__SWIG_1(long jarg1, NetZone jarg1_, String jarg2, double jarg3);
  public final static native long NetZone_add_host__SWIG_2(long jarg1, NetZone jarg1_, String jarg2, String[] jarg3);
  public final static native long NetZone_add_host__SWIG_3(long jarg1, NetZone jarg1_, String jarg2, String jarg3);
  public final static native long NetZone_add_link__SWIG_0(long jarg1, NetZone jarg1_, String jarg2, double[] jarg3);
  public final static native long NetZone_add_link__SWIG_1(long jarg1, NetZone jarg1_, String jarg2, double jarg3);
  public final static native long NetZone_add_link__SWIG_2(long jarg1, NetZone jarg1_, String jarg2, String[] jarg3);
  public final static native long NetZone_add_link__SWIG_3(long jarg1, NetZone jarg1_, String jarg2, String jarg3);
  public final static native long NetZone_add_splitlink_from_double(long jarg1, NetZone jarg1_, String jarg2,
                                                                       double jarg3, double jarg4);
  public final static native long NetZone_add_splitlink_from_string(long jarg1, NetZone jarg1_, String jarg2,
                                                                       String jarg3, String jarg4);
  public final static native long NetZone_add_splitlink_from_links(long jarg1, NetZone jarg1_, String jarg2,
                                                                      long jarg3, long jarg4);
  public final static native void NetZone_add_route_hosts(long jarg1, NetZone jarg1_, long src, long dst, long[] links);
  public final static native void NetZone_add_route_netzones(long jarg1, NetZone jarg1_, long src, long dst,
                                                             long[] links);
  public final static native void NetZone_seal(long jarg1, NetZone jarg1_);
  public final static native String Mailbox_get_name(long jarg1, Mailbox jarg1_);
  public final static native boolean Mailbox_empty(long jarg1, Mailbox jarg1_);
  public final static native long Mailbox_size(long jarg1, Mailbox jarg1_);
  public final static native boolean Mailbox_listen(long jarg1, Mailbox jarg1_);
  public final static native int Mailbox_listen_from(long jarg1, Mailbox jarg1_);
  public final static native boolean Mailbox_ready(long jarg1, Mailbox jarg1_);
  public final static native void Mailbox_set_receiver(long jarg1, Mailbox jarg1_, long jarg2, Actor jarg2_);
  public final static native Actor Mailbox_get_receiver(long jarg1, Mailbox jarg1_);
  public final static native long Mailbox_put_init__SWIG_0(long jarg1, Mailbox jarg1_);
  public final static native long Mailbox_put_init__SWIG_1(long jarg1, Mailbox jarg1_, Object jarg2, long jarg3);
  public final static native long Mailbox_put_async(long jarg1, Mailbox jarg1_, Object jarg2, long jarg3);
  public final static native String Mailbox_to_c_str(int jarg1);
  public final static native long Mailbox_get_init(long jarg1, Mailbox jarg1_);
  public final static native long Mailbox_get_async(long jarg1, Mailbox jarg1_);
  public final static native void Mailbox_clear(long jarg1, Mailbox jarg1_);
  public final static native void Mailbox_put__SWIG_0(long jarg1, Mailbox jarg1_, Object jarg3, long jarg4);
  public final static native void Mailbox_put__SWIG_1(long jarg1, Mailbox jarg1_, Object jarg3, long jarg4, double jarg5);
  public final static native Object Mailbox_get(long jarg1, Mailbox jarg1_);
  public final static native String MessageQueue_get_name(long jarg1, MessageQueue jarg1_);
  public final static native boolean MessageQueue_empty(long jarg1, MessageQueue jarg1_);
  public final static native long MessageQueue_size(long jarg1, MessageQueue jarg1_);
  public final static native long MessageQueue_put_init__SWIG_0(long jarg1, MessageQueue jarg1_);
  public final static native long MessageQueue_put_init__SWIG_1(long jarg1, MessageQueue jarg1_, Object jarg2);
  public final static native long MessageQueue_put_async(long jarg1, MessageQueue jarg1_, Object jarg2);
  public final static native void MessageQueue_put__SWIG_0(long jarg1, MessageQueue jarg1_, Object jarg2);
  public final static native void MessageQueue_put__SWIG_1(long jarg1, MessageQueue jarg1_, Object jarg2, double jarg3);
  public final static native long MessageQueue_get_init(long jarg1, MessageQueue jarg1_);
  public final static native long MessageQueue_get_async(long jarg1, MessageQueue jarg1_);
  public final static native void delete_Mutex(long jarg1);
  public final static native long Mutex_create(boolean recursive);
  public final static native void Mutex_lock(long jarg1, Mutex jarg1_);
  public final static native void Mutex_unlock(long jarg1, Mutex jarg1_);
  public final static native boolean Mutex_try_lock(long jarg1, Mutex jarg1_);
  public final static native Actor Mutex_get_owner(long jarg1, Mutex jarg1_);
  public final static native void delete_Semaphore(long jarg1);
  public final static native long Semaphore_create(long jarg1);
  public final static native void Semaphore_acquire(long jarg1, Semaphore jarg1_);
  public final static native boolean Semaphore_acquire_timeout(long jarg1, Semaphore jarg1_, double jarg2);
  public final static native void Semaphore_release(long jarg1, Semaphore jarg1_);
  public final static native int Semaphore_get_capacity(long jarg1, Semaphore jarg1_);
  public final static native boolean Semaphore_would_block(long jarg1, Semaphore jarg1_);
  public final static native String VirtualMachine_to_c_str(int jarg1);
  public final static native void VirtualMachine_start(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_suspend(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_resume(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_shutdown(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_destroy(long jarg1, VirtualMachine jarg1_);
  public final static native long VirtualMachine_get_pm(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_set_pm(long jarg1, VirtualMachine jarg1_, long jarg2, Host jarg2_);
  public final static native long VirtualMachine_get_ramsize(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_set_ramsize(long jarg1, VirtualMachine jarg1_, long jarg2);
  public final static native void VirtualMachine_set_bound(long jarg1, VirtualMachine jarg1_, double jarg2);
  public final static native void VirtualMachine_migrate(long jarg1, VirtualMachine jarg1_, long chost, Host jhost);
  public final static native void VirtualMachine_start_migration(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_end_migration(long jarg1, VirtualMachine jarg1_);
  public final static native int VirtualMachine_get_state(long jarg1, VirtualMachine jarg1_);
  public final static native void VirtualMachine_on_start_cb(CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_start_cb(long jarg1, VirtualMachine jarg1_,
                                                                  CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_started_cb(CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_started_cb(long jarg1, VirtualMachine jarg1_,
                                                                    CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_shutdown_cb(CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_shutdown_cb(long jarg1, VirtualMachine jarg1_,
                                                                     CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_suspend_cb(long jarg1, VirtualMachine jarg1_,
                                                                    CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_resume_cb(long jarg1, VirtualMachine jarg1_,
                                                                   CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_destruction_cb(CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_destruction_cb(long jarg1, VirtualMachine jarg1_,
                                                                        CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_migration_start_cb(CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_migration_start_cb(long jarg1, VirtualMachine jarg1_,
                                                                            CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_migration_end_cb(CallbackVirtualMachine cb);
  public final static native void VirtualMachine_on_this_migration_end_cb(long jarg1, VirtualMachine jarg1_,
                                                                          CallbackVirtualMachine cb);

  public final static native void Host_load_reset(long swigCPtr);
  public final static native double Host_get_current_load(long swigCPtr);
  public final static native double Host_get_avg_load(long swigCPtr);
  public final static native double Host_get_idle_time(long swigCPtr);
  public final static native double Host_get_total_idle_time(long swigCPtr);
  public final static native double Host_get_computed_flops(long swigCPtr);

  public final static native void Link_load_track(long swigCPtr);
  public final static native void Link_load_untrack(long swigCPtr);
  public final static native void Link_load_reset(long swigCPtr);
  public final static native double Link_get_cum_load(long swigCPtr);
  public final static native double Link_get_avg_load(long swigCPtr);
  public final static native double Link_get_min_instantaneous_load(long swigCPtr);
  public final static native double Link_get_max_instantaneous_load(long swigCPtr);
}
