/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlunit.ConfigurationException;
import org.xmlunit.XMLUnitException;

public final class Convert {
    private Convert() {
    }

    public static InputSource toInputSource(Source s) {
        return Convert.toInputSource(s, null);
    }

    public static InputSource toInputSource(Source s, TransformerFactory fac) {
        try {
            InputSource is = SAXSource.sourceToInputSource(s);
            if (is == null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                StreamResult r = new StreamResult(bos);
                if (fac == null) {
                    fac = TransformerFactory.newInstance();
                }
                Transformer t = fac.newTransformer();
                t.transform(s, r);
                s = new StreamSource(new ByteArrayInputStream(bos.toByteArray()));
                is = SAXSource.sourceToInputSource(s);
            }
            return is;
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationException(e);
        }
        catch (TransformerException e) {
            throw new XMLUnitException(e);
        }
    }

    public static Document toDocument(Source s) {
        Document d = Convert.tryExtractDocFromDOMSource(s);
        return d != null ? d : Convert.toDocument(s, DocumentBuilderFactory.newInstance());
    }

    public static Document toDocument(Source s, DocumentBuilderFactory factory) {
        Document d = Convert.tryExtractDocFromDOMSource(s);
        if (d == null) {
            InputSource is = Convert.toInputSource(s);
            DocumentBuilder b = null;
            boolean oldNsAware = factory.isNamespaceAware();
            try {
                if (!oldNsAware) {
                    factory.setNamespaceAware(true);
                }
                b = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new ConfigurationException(e);
            }
            finally {
                if (!oldNsAware) {
                    factory.setNamespaceAware(false);
                }
            }
            try {
                d = b.parse(is);
            }
            catch (SAXException e) {
                throw new XMLUnitException(e);
            }
            catch (IOException e) {
                throw new XMLUnitException(e);
            }
        }
        return d;
    }

    private static Document tryExtractDocFromDOMSource(Source s) {
        Node n = Convert.tryExtractNodeFromDOMSource(s);
        if (n != null && n instanceof Document) {
            Document d = (Document)n;
            return d;
        }
        return null;
    }

    public static Node toNode(Source s) {
        Node n = Convert.tryExtractNodeFromDOMSource(s);
        return n != null ? n : Convert.toDocument(s, DocumentBuilderFactory.newInstance());
    }

    public static Node toNode(Source s, DocumentBuilderFactory factory) {
        Node n = Convert.tryExtractNodeFromDOMSource(s);
        return n != null ? n : Convert.toDocument(s, factory);
    }

    private static Node tryExtractNodeFromDOMSource(Source s) {
        if (s instanceof DOMSource) {
            DOMSource ds = (DOMSource)s;
            return ds.getNode();
        }
        return null;
    }

    public static NamespaceContext toNamespaceContext(Map<String, String> prefix2URI) {
        final LinkedHashMap<String, String> copy = new LinkedHashMap<String, String>(prefix2URI);
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (prefix == null) {
                    throw new IllegalArgumentException("prefix must not be null");
                }
                if ("xml".equals(prefix)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                if ("xmlns".equals(prefix)) {
                    return "http://www.w3.org/2000/xmlns/";
                }
                String uri = (String)copy.get(prefix);
                return uri != null ? uri : "";
            }

            @Override
            public String getPrefix(String uri) {
                Iterator i = this.getPrefixes(uri);
                return i.hasNext() ? (String)i.next() : null;
            }

            public Iterator getPrefixes(String uri) {
                if (uri == null) {
                    throw new IllegalArgumentException("uri must not be null");
                }
                LinkedHashSet<String> c = new LinkedHashSet<String>();
                boolean done = false;
                if ("http://www.w3.org/XML/1998/namespace".equals(uri)) {
                    c.add("xml");
                    done = true;
                }
                if ("http://www.w3.org/2000/xmlns/".equals(uri)) {
                    c.add("xmlns");
                    done = true;
                }
                if (!done) {
                    for (Map.Entry entry : copy.entrySet()) {
                        if (!uri.equals(entry.getValue())) continue;
                        c.add((String)entry.getKey());
                    }
                }
                return c.iterator();
            }
        };
    }
}

