# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobScheduleAddParameter(Model):
    """A job schedule that allows recurring jobs by specifying when to run jobs
    and a specification used to create each job.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the schedule within
     the account. The ID can contain any combination of alphanumeric characters
     including hyphens and underscores, and cannot contain more than 64
     characters. The ID is case-preserving and case-insensitive (that is, you
     may not have two IDs within an account that differ only by case).
    :type id: str
    :param display_name: The display name for the schedule. The display name
     need not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param schedule: Required. The schedule according to which jobs will be
     created.
    :type schedule: ~azure.batch.models.Schedule
    :param job_specification: Required. The details of the jobs to be created
     on this schedule.
    :type job_specification: ~azure.batch.models.JobSpecification
    :param metadata: A list of name-value pairs associated with the schedule
     as metadata. The Batch service does not assign any meaning to metadata; it
     is solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'id': {'required': True},
        'schedule': {'required': True},
        'job_specification': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleAddParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.schedule = kwargs.get('schedule', None)
        self.job_specification = kwargs.get('job_specification', None)
        self.metadata = kwargs.get('metadata', None)
