# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RoleDefinitionProperties(Model):
    """Role definition properties.

    :param role_name: The role name.
    :type role_name: str
    :param description: The role definition description.
    :type description: str
    :param type: The role type.
    :type type: str
    :param permissions: Role definition permissions.
    :type permissions:
     list[~azure.mgmt.authorization.v2015_07_01.models.Permission]
    :param assignable_scopes: Role definition assignable scopes.
    :type assignable_scopes: list[str]
    """

    _attribute_map = {
        'role_name': {'key': 'roleName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': '[Permission]'},
        'assignable_scopes': {'key': 'assignableScopes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(RoleDefinitionProperties, self).__init__(**kwargs)
        self.role_name = kwargs.get('role_name', None)
        self.description = kwargs.get('description', None)
        self.type = kwargs.get('type', None)
        self.permissions = kwargs.get('permissions', None)
        self.assignable_scopes = kwargs.get('assignable_scopes', None)
