# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AvailableServiceSkuCapacity(Model):
    """A description of the scaling capacities of the SKU.

    :param minimum: The minimum capacity, usually 0 or 1.
    :type minimum: int
    :param maximum: The maximum capacity
    :type maximum: int
    :param default: The default capacity
    :type default: int
    :param scale_type: The scalability approach. Possible values include:
     'none', 'manual', 'automatic'
    :type scale_type: str or
     ~azure.mgmt.datamigration.models.ServiceScalability
    """

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'int'},
        'maximum': {'key': 'maximum', 'type': 'int'},
        'default': {'key': 'default', 'type': 'int'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(self, *, minimum: int=None, maximum: int=None, default: int=None, scale_type=None, **kwargs) -> None:
        super(AvailableServiceSkuCapacity, self).__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type
