# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EventHubProperties(Model):
    """The properties of the provisioned Event Hub-compatible endpoint used by the
    IoT hub.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param retention_time_in_days: The retention time for device-to-cloud
     messages in days. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages
    :type retention_time_in_days: long
    :param partition_count: The number of partitions for receiving
     device-to-cloud messages in the Event Hub-compatible endpoint. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :type partition_count: int
    :ivar partition_ids: The partition ids in the Event Hub-compatible
     endpoint.
    :vartype partition_ids: list[str]
    :ivar path: The Event Hub-compatible name.
    :vartype path: str
    :ivar endpoint: The Event Hub-compatible endpoint.
    :vartype endpoint: str
    """

    _validation = {
        'partition_ids': {'readonly': True},
        'path': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EventHubProperties, self).__init__(**kwargs)
        self.retention_time_in_days = kwargs.get('retention_time_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.partition_ids = None
        self.path = None
        self.endpoint = None
