# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .layer_py3 import Layer


class JpgLayer(Layer):
    """Describes the settings to produce a JPEG image from the input video.

    All required parameters must be populated in order to send to Azure.

    :param width: The width of the output video for this layer. The value can
     be absolute (in pixels) or relative (in percentage). For example 50% means
     the output video has half as many pixels in width as the input.
    :type width: str
    :param height: The height of the output video for this layer. The value
     can be absolute (in pixels) or relative (in percentage). For example 50%
     means the output video has half as many pixels in height as the input.
    :type height: str
    :param label: The alphanumeric label for this layer, which can be used in
     multiplexing different video and audio layers, or in naming the output
     file.
    :type label: str
    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param quality: The compression quality of the JPEG output. Range is from
     0-100 and the default is 70.
    :type quality: int
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'width': {'key': 'width', 'type': 'str'},
        'height': {'key': 'height', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'quality': {'key': 'quality', 'type': 'int'},
    }

    def __init__(self, *, width: str=None, height: str=None, label: str=None, quality: int=None, **kwargs) -> None:
        super(JpgLayer, self).__init__(width=width, height=height, label=label, **kwargs)
        self.quality = quality
        self.odatatype = '#Microsoft.Media.JpgLayer'
