# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Metric(Model):
    """A metric emitted by service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The metric name.
    :vartype name: str
    :ivar display_name: The metric display name.
    :vartype display_name: str
    :ivar display_description: The metric display description.
    :vartype display_description: str
    :ivar unit: The metric unit. Possible values include: 'Bytes', 'Count',
     'Milliseconds'
    :vartype unit: str or ~azure.mgmt.media.models.MetricUnit
    :ivar aggregation_type: The metric aggregation type. Possible values
     include: 'Average', 'Count', 'Total'
    :vartype aggregation_type: str or
     ~azure.mgmt.media.models.MetricAggregationType
    :ivar dimensions: The metric dimensions.
    :vartype dimensions: list[~azure.mgmt.media.models.MetricDimension]
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'display_description': {'readonly': True},
        'unit': {'readonly': True},
        'aggregation_type': {'readonly': True},
        'dimensions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'MetricUnit'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'MetricAggregationType'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
    }

    def __init__(self, **kwargs):
        super(Metric, self).__init__(**kwargs)
        self.name = None
        self.display_name = None
        self.display_description = None
        self.unit = None
        self.aggregation_type = None
        self.dimensions = None
