# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StreamingPolicyPlayReadyConfiguration(Model):
    """Class to specify configurations of PlayReady in Streaming Policy.

    :param custom_license_acquisition_url_template: The template for a
     customer service to deliver keys to end users.  Not needed when using
     Azure Media Services for issuing keys.
    :type custom_license_acquisition_url_template: str
    :param play_ready_custom_attributes: Custom attributes for PlayReady
    :type play_ready_custom_attributes: str
    """

    _attribute_map = {
        'custom_license_acquisition_url_template': {'key': 'customLicenseAcquisitionUrlTemplate', 'type': 'str'},
        'play_ready_custom_attributes': {'key': 'playReadyCustomAttributes', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(StreamingPolicyPlayReadyConfiguration, self).__init__(**kwargs)
        self.custom_license_acquisition_url_template = kwargs.get('custom_license_acquisition_url_template', None)
        self.play_ready_custom_attributes = kwargs.get('play_ready_custom_attributes', None)
