//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2024/11/20.
//

#ifndef UOS_RECOVERY_IMMURESTOREWIDGET_H
#define UOS_RECOVERY_IMMURESTOREWIDGET_H

#include "utils/global.h"
#include "common/ImmuBaseTableView.h"
#include "common/BaseItemDelegate.h"
#include "common/AuthorityUtils.h"
#include <DWidget>
#include <DLabel>
#include <DButtonBox>
#include <QStandardItemModel>
#include <DPushButton>
#include <QVBoxLayout>
#include <DSpinner>
#include <DGuiApplicationHelper>
#include <QPixmap>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

enum class ImmuBackupFileActionType {
    Invalid = -1,
    Restore = 0,
    Delete
};

class ImmuActionWidget : public QWidget
{
Q_OBJECT
public:
    static bool m_isRemoving;
    explicit ImmuActionWidget(QWidget *parent = nullptr);
    void setBackupInfo(const BackupInfo &backupInfo);
    void setDeleteBtnVisible(bool visible);
    void setRestoreBtnVisible(bool visible);
    void setSpinnerVisible(bool visible);
    void stopSpinner();
    void setBackupFileActionType(ImmuBackupFileActionType actionType);
    int getBackupInfoOperateType();

Q_SIGNALS:
    void deleteBackupInfo(const BackupInfo &backupInfo);
    void immuSystemRestoreClicked(const BackupInfo &backupInfo);
    void immuDataRestoreClicked(const BackupInfo &backupInfo);

public Q_SLOTS:
    void onRestore();
    void onDelete();
    void doAdminAuthorityTask(bool result, int type);
    void doCommonAuthorityTask(bool result, int type);
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

private:
    void checkAdminAuthority(AuthorityType type);
    void checkCommonAuthority(AuthorityType type);

private:
    DPushButton *m_restoreBtn = nullptr;
    DPushButton *m_deleteBtn = nullptr;
    DSpinner *m_spinner = nullptr;
    AuthorityUtils *m_adminAuthUtils = nullptr;
    AuthorityUtils *m_commonAuthUtils = nullptr;
    ImmuBackupFileActionType m_actionType = ImmuBackupFileActionType::Invalid;
    BackupInfo m_backupInfo;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
};

class ImmuBackupFileDelegate : public BaseItemDelegate
{
Q_OBJECT
public:
    explicit ImmuBackupFileDelegate(QObject *parent = nullptr);

    QWidget *createEditor(QWidget *widget, const QStyleOptionViewItem &styleOptionViewItem,
                          const QModelIndex &index) const override;

    void setEditorData(QWidget *editor, const QModelIndex &index) const override;
    void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const override;
};

class DefaultEmptyRestoreWidget : public DWidget {
    Q_OBJECT
public:
    explicit DefaultEmptyRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initLayout();
Q_SIGNALS:
    void notifyShowBackupPage();

private Q_SLOTS:
    void showBackupPage();
    void updateTheme();

private:
    DLabel *m_backupFilesMgrLabel = nullptr;
    DPushButton *m_newBackupBtn = nullptr;
    DLabel *m_icon = nullptr;
    DLabel *m_text = nullptr;
    QVBoxLayout *m_vMainLayout = nullptr;
    QPixmap m_lightIconPixmap;
    QPixmap m_darkIconPixmap;
    bool m_isCommunity = false;
};

class ImmuRestoreWidget : public DWidget
{
    Q_OBJECT
public:
    explicit ImmuRestoreWidget(DWidget *parent = nullptr);
    void initUI();
    void initTableView();
    void initLayout();
    void setData(BackupInfoList &backupInfos);
    void setSystemBackupInfoData(const BackupInfoList &backupInfos);
    void setDataBackupInfoData(const BackupInfoList &backupInfos);
    void setGhostInfoData(const BackupInfoList &backupInfos);
    void setDeleteWidgetStatus(bool deleteBtnVisible, bool spinnerVisible, const QString &operateId);
    void showErrorDlg(const QString &msg);
    void removeBackupInfo(const QString &operateId);
    void showFirstItem();
    bool showRebootDialog(const QString &title, const QString &msg, const QString &iconName, const QString &btnText);

Q_SIGNALS:
    void cancel();
    void start(BackupInfo &backupInfo);
    void notifyImmuSystemRestoreClicked(const BackupInfo &backupInfo);
    void notifyImmuDataRestoreClicked(const BackupInfo &backupInfo);
    void notifyDeleteBackupInfo(const BackupInfo &backupInfo);
    void notifyShowBackupPage();

private Q_SLOTS:
    void showBackupPage();
    void onBackupFileBtnChange(QAbstractButton *button);
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

private:
    DLabel *m_backupFilesMgrLabel = nullptr;
    DPushButton *m_newBackupBtn = nullptr;
    DButtonBox *m_buttonBox = nullptr;
    DButtonBoxButton *m_systemBackupBtn = nullptr;
    DButtonBoxButton *m_dataBackupBtn = nullptr;
    DButtonBoxButton *m_systemCloneBtn = nullptr;
    ImmuBaseTableView *m_tableView = nullptr;
    QStandardItemModel *m_model = nullptr;
    QVBoxLayout *m_mainVLayout = nullptr;
    BackupInfoList m_allSystemBackupInfo;
    BackupInfoList m_allDataBackupInfo;
    BackupInfoList m_allGhostBackupInfo;
    QMap<QString, BackupInfo> m_allBackupInfo;
    bool m_isCommunity = false;
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper = nullptr;
};

#endif //UOS_RECOVERY_IMMURESTOREWIDGET_H
