//
// Created by dtx on 2022/3/22.
//

#ifndef UOS_RECOVERY_SQUASHFSTASK_H
#define UOS_RECOVERY_SQUASHFSTASK_H

#include "AsyncTask.h"
#include <QTimer>
#include <QTime>

class SquashfsTask : public AsyncTask
{
    Q_OBJECT

public:
    SquashfsTask();
    virtual ~SquashfsTask();
    bool makeSquashfs(const QString &srcDir, const QString &destFile);
    bool extractSquashfs(const QString &srcFile, const QString &destDir);
    virtual bool buildArgumentsForBackup() override;
    virtual bool buildArgumentsForRestore(const QString &fromDir) override;
    void doResult() override;
    void setTimeString(const QString &timeStr) { m_timeStr = timeStr; }
    QTime getStartTime() { return m_startTime; }
    void setCheckPath(const QString &path);

signals:
    void progressChanged(const QJsonObject &value);
    void taskFinished();

public slots:
    void readResultSlot();
    virtual void readStandardOutput() override;
    virtual void readAllStandardError() override;

private:

private:
    QTimer *m_readResult = nullptr;
    QTime m_startTime;
    QString m_timeStr = "";
    int m_currentProgressValue = 0;
    QString m_checkPath;
};


#endif //UOS_RECOVERY_SQUASHFSTASK_H
