/**
 * This file is generated by dconfig2cpp.
 * Command line arguments: ./dconfig2cpp -p ./dde-session-shell/toolGenerate/dconfig2cpp ./dde-session-shell/configs/org.deepin.dde.lock.json
 * Generation time: 2025-01-14T10:55:00
 * JSON file version: 1.0
 * 
 * WARNING: DO NOT MODIFY THIS FILE MANUALLY.
 * If you need to change the content, please modify the dconfig2cpp tool.
 */

#ifndef ORG_DEEPIN_DDE_LOCK_H
#define ORG_DEEPIN_DDE_LOCK_H

#include <QThread>
#include <QVariant>
#include <QDebug>
#include <QAtomicPointer>
#include <QAtomicInteger>
#include <DConfig>

class org_deepin_dde_lock : public QObject {
    Q_OBJECT

    Q_PROPERTY(bool autoExit READ autoExit WRITE setAutoExit NOTIFY autoExitChanged)
    Q_PROPERTY(bool hideLogoutButton READ hideLogoutButton WRITE setHideLogoutButton NOTIFY hideLogoutButtonChanged)
    Q_PROPERTY(bool hideOnboard READ hideOnboard WRITE setHideOnboard NOTIFY hideOnboardChanged)
    Q_PROPERTY(bool useSolidBackground READ useSolidBackground WRITE setUseSolidBackground NOTIFY useSolidBackgroundChanged)
public:
    explicit org_deepin_dde_lock(QThread *thread, const QString &appId, const QString &name, const QString &subpath, QObject *parent = nullptr)
        : QObject(parent) {

        if (!thread->isRunning()) {
            qWarning() << QStringLiteral("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);
        QMetaObject::invokeMethod(worker, [=]() {
            auto config = DTK_CORE_NAMESPACE::DConfig::create(appId, name, subpath, nullptr);
            if (!config) {
                qWarning() << QStringLiteral("Failed to create DConfig instance.");
                worker->deleteLater();
                return;
            }
            config->moveToThread(QThread::currentThread());
            initialize(config);
            worker->deleteLater();
        });
    }
    explicit org_deepin_dde_lock(QThread *thread, DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &appId, const QString &name, const QString &subpath, QObject *parent = nullptr)
        : QObject(parent) {

        if (!thread->isRunning()) {
            qWarning() << QStringLiteral("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);
        QMetaObject::invokeMethod(worker, [=]() {
            auto config = DTK_CORE_NAMESPACE::DConfig::create(backend, appId, name, subpath, nullptr);
            if (!config) {
                qWarning() << QStringLiteral("Failed to create DConfig instance.");
                worker->deleteLater();
                return;
            }
            config->moveToThread(QThread::currentThread());
            initialize(config);
            worker->deleteLater();
        });
    }
    explicit org_deepin_dde_lock(QThread *thread, const QString &name, const QString &subpath, QObject *parent = nullptr)
        : QObject(parent) {

        if (!thread->isRunning()) {
            qWarning() << QStringLiteral("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);
        QMetaObject::invokeMethod(worker, [=]() {
            auto config = DTK_CORE_NAMESPACE::DConfig::create(name, subpath, nullptr);
            if (!config) {
                qWarning() << QStringLiteral("Failed to create DConfig instance.");
                worker->deleteLater();
                return;
            }
            config->moveToThread(QThread::currentThread());
            initialize(config);
            worker->deleteLater();
        });
    }
    explicit org_deepin_dde_lock(QThread *thread, DTK_CORE_NAMESPACE::DConfigBackend *backend, const QString &name, const QString &subpath, QObject *parent = nullptr)
        : QObject(parent) {

        if (!thread->isRunning()) {
            qWarning() << QStringLiteral("Warning: The provided thread is not running.");
        }
        Q_ASSERT(QThread::currentThread() != thread);
        auto worker = new QObject();
        worker->moveToThread(thread);
        QMetaObject::invokeMethod(worker, [=]() {
            auto config = DTK_CORE_NAMESPACE::DConfig::create(backend, name, subpath, nullptr);
            if (!config) {
                qWarning() << QStringLiteral("Failed to create DConfig instance.");
                worker->deleteLater();
                return;
            }
            config->moveToThread(QThread::currentThread());
            initialize(config);
            worker->deleteLater();
        });
    }
    ~org_deepin_dde_lock() {
        if (m_config.loadRelaxed()) {
            m_config.loadRelaxed()->deleteLater();
        }
    }

    bool autoExit() const {
        return p_autoExit;
    }
    void setAutoExit(const bool &value) {
        auto oldValue = p_autoExit;
        p_autoExit = value;
        markPropertySet(0);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("autoExit"), value);
            });
        }
        if (p_autoExit != oldValue) {
            Q_EMIT autoExitChanged();
        }
    }
    bool hideLogoutButton() const {
        return p_hideLogoutButton;
    }
    void setHideLogoutButton(const bool &value) {
        auto oldValue = p_hideLogoutButton;
        p_hideLogoutButton = value;
        markPropertySet(1);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("hideLogoutButton"), value);
            });
        }
        if (p_hideLogoutButton != oldValue) {
            Q_EMIT hideLogoutButtonChanged();
        }
    }
    bool hideOnboard() const {
        return p_hideOnboard;
    }
    void setHideOnboard(const bool &value) {
        auto oldValue = p_hideOnboard;
        p_hideOnboard = value;
        markPropertySet(2);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("hideOnboard"), value);
            });
        }
        if (p_hideOnboard != oldValue) {
            Q_EMIT hideOnboardChanged();
        }
    }
    bool useSolidBackground() const {
        return p_useSolidBackground;
    }
    void setUseSolidBackground(const bool &value) {
        auto oldValue = p_useSolidBackground;
        p_useSolidBackground = value;
        markPropertySet(3);
        if (auto config = m_config.loadRelaxed()) {
            QMetaObject::invokeMethod(config, [this, value]() {
                m_config.loadRelaxed()->setValue(QStringLiteral("useSolidBackground"), value);
            });
        }
        if (p_useSolidBackground != oldValue) {
            Q_EMIT useSolidBackgroundChanged();
        }
    }
Q_SIGNALS:
    void autoExitChanged();
    void hideLogoutButtonChanged();
    void hideOnboardChanged();
    void useSolidBackgroundChanged();
private:
    void initialize(DTK_CORE_NAMESPACE::DConfig *config) {
        Q_ASSERT(!m_config.loadRelaxed());
        m_config.storeRelaxed(config);
        if (testPropertySet(0)) {
            config->setValue(QStringLiteral("autoExit"), QVariant::fromValue(p_autoExit));
        } else {
            updateValue(QStringLiteral("autoExit"), QVariant::fromValue(p_autoExit));
        }
        if (testPropertySet(1)) {
            config->setValue(QStringLiteral("hideLogoutButton"), QVariant::fromValue(p_hideLogoutButton));
        } else {
            updateValue(QStringLiteral("hideLogoutButton"), QVariant::fromValue(p_hideLogoutButton));
        }
        if (testPropertySet(2)) {
            config->setValue(QStringLiteral("hideOnboard"), QVariant::fromValue(p_hideOnboard));
        } else {
            updateValue(QStringLiteral("hideOnboard"), QVariant::fromValue(p_hideOnboard));
        }
        if (testPropertySet(3)) {
            config->setValue(QStringLiteral("useSolidBackground"), QVariant::fromValue(p_useSolidBackground));
        } else {
            updateValue(QStringLiteral("useSolidBackground"), QVariant::fromValue(p_useSolidBackground));
        }

        connect(config, &DTK_CORE_NAMESPACE::DConfig::valueChanged, this, [this](const QString &key) {
            updateValue(key);
        }, Qt::DirectConnection);
    }
    void updateValue(const QString &key, const QVariant &fallback = QVariant()) {
        Q_ASSERT(QThread::currentThread() == m_config.loadRelaxed()->thread());
        const QVariant &value = m_config.loadRelaxed()->value(key, fallback);
        if (key == QStringLiteral("autoExit")) {
            auto newValue = qvariant_cast<bool>(value);
            QMetaObject::invokeMethod(this, [this, newValue]() {
                if (p_autoExit != newValue) {
                    p_autoExit = newValue;
                    Q_EMIT autoExitChanged();
                }
            });
            return;
        }
        if (key == QStringLiteral("hideLogoutButton")) {
            auto newValue = qvariant_cast<bool>(value);
            QMetaObject::invokeMethod(this, [this, newValue]() {
                if (p_hideLogoutButton != newValue) {
                    p_hideLogoutButton = newValue;
                    Q_EMIT hideLogoutButtonChanged();
                }
            });
            return;
        }
        if (key == QStringLiteral("hideOnboard")) {
            auto newValue = qvariant_cast<bool>(value);
            QMetaObject::invokeMethod(this, [this, newValue]() {
                if (p_hideOnboard != newValue) {
                    p_hideOnboard = newValue;
                    Q_EMIT hideOnboardChanged();
                }
            });
            return;
        }
        if (key == QStringLiteral("useSolidBackground")) {
            auto newValue = qvariant_cast<bool>(value);
            QMetaObject::invokeMethod(this, [this, newValue]() {
                if (p_useSolidBackground != newValue) {
                    p_useSolidBackground = newValue;
                    Q_EMIT useSolidBackgroundChanged();
                }
            });
            return;
        }
    }
    inline void markPropertySet(const int index) {
        if (index < 32) {
            m_propertySetStatus0.fetchAndOrOrdered(1 << (index - 0));
            return;
        }
        Q_UNREACHABLE();
    }
    inline bool testPropertySet(const int index) const {
        if (index < 32) {
            return (m_propertySetStatus0.loadRelaxed() & (1 << (index - 0)));
        }
        Q_UNREACHABLE();
    }
    QAtomicPointer<DTK_CORE_NAMESPACE::DConfig> m_config = nullptr;
    bool p_autoExit { false };
    bool p_hideLogoutButton { false };
    bool p_hideOnboard { false };
    bool p_useSolidBackground { false };
    QAtomicInteger<quint32> m_propertySetStatus0 = 0;
};

#endif // ORG_DEEPIN_DDE_LOCK_H
