package azurestackhci

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/azurestackhci/mgmt/2022-05-01/azurestackhci"

// ArcConnectivityProperties connectivity related configuration required by arc server.
type ArcConnectivityProperties struct {
	// Enabled - True indicates ARC connectivity is enabled
	Enabled *bool `json:"enabled,omitempty"`
}

// ArcIdentityResponse arcIdentity details.
type ArcIdentityResponse struct {
	autorest.Response `json:"-"`
	// ArcIdentityResponseProperties - ArcIdentity properties.
	*ArcIdentityResponseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcIdentityResponse.
func (air ArcIdentityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if air.ArcIdentityResponseProperties != nil {
		objectMap["properties"] = air.ArcIdentityResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArcIdentityResponse struct.
func (air *ArcIdentityResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var arcIdentityResponseProperties ArcIdentityResponseProperties
				err = json.Unmarshal(*v, &arcIdentityResponseProperties)
				if err != nil {
					return err
				}
				air.ArcIdentityResponseProperties = &arcIdentityResponseProperties
			}
		}
	}

	return nil
}

// ArcIdentityResponseProperties ...
type ArcIdentityResponseProperties struct {
	ArcApplicationClientID      *string `json:"arcApplicationClientId,omitempty"`
	ArcApplicationTenantID      *string `json:"arcApplicationTenantId,omitempty"`
	ArcServicePrincipalObjectID *string `json:"arcServicePrincipalObjectId,omitempty"`
	ArcApplicationObjectID      *string `json:"arcApplicationObjectId,omitempty"`
}

// ArcSetting arcSetting details.
type ArcSetting struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; System data of ArcSetting resource
	*SystemData `json:"systemData,omitempty"`
	// ArcSettingProperties - ArcSetting properties.
	*ArcSettingProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcSetting.
func (as ArcSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if as.ArcSettingProperties != nil {
		objectMap["properties"] = as.ArcSettingProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArcSetting struct.
func (as *ArcSetting) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				as.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var arcSettingProperties ArcSettingProperties
				err = json.Unmarshal(*v, &arcSettingProperties)
				if err != nil {
					return err
				}
				as.ArcSettingProperties = &arcSettingProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				as.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				as.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				as.Type = &typeVar
			}
		}
	}

	return nil
}

// ArcSettingList list of ArcSetting proxy resources for the HCI cluster.
type ArcSettingList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of ArcSetting proxy resources.
	Value *[]ArcSetting `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcSettingList.
func (asl ArcSettingList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ArcSettingListIterator provides access to a complete listing of ArcSetting values.
type ArcSettingListIterator struct {
	i    int
	page ArcSettingListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ArcSettingListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArcSettingListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ArcSettingListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ArcSettingListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ArcSettingListIterator) Response() ArcSettingList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ArcSettingListIterator) Value() ArcSetting {
	if !iter.page.NotDone() {
		return ArcSetting{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ArcSettingListIterator type.
func NewArcSettingListIterator(page ArcSettingListPage) ArcSettingListIterator {
	return ArcSettingListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (asl ArcSettingList) IsEmpty() bool {
	return asl.Value == nil || len(*asl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (asl ArcSettingList) hasNextLink() bool {
	return asl.NextLink != nil && len(*asl.NextLink) != 0
}

// arcSettingListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (asl ArcSettingList) arcSettingListPreparer(ctx context.Context) (*http.Request, error) {
	if !asl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(asl.NextLink)))
}

// ArcSettingListPage contains a page of ArcSetting values.
type ArcSettingListPage struct {
	fn  func(context.Context, ArcSettingList) (ArcSettingList, error)
	asl ArcSettingList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ArcSettingListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ArcSettingListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.asl)
		if err != nil {
			return err
		}
		page.asl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ArcSettingListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ArcSettingListPage) NotDone() bool {
	return !page.asl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ArcSettingListPage) Response() ArcSettingList {
	return page.asl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ArcSettingListPage) Values() []ArcSetting {
	if page.asl.IsEmpty() {
		return nil
	}
	return *page.asl.Value
}

// Creates a new instance of the ArcSettingListPage type.
func NewArcSettingListPage(cur ArcSettingList, getNextPage func(context.Context, ArcSettingList) (ArcSettingList, error)) ArcSettingListPage {
	return ArcSettingListPage{
		fn:  getNextPage,
		asl: cur,
	}
}

// ArcSettingProperties arcSetting properties.
type ArcSettingProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the ArcSetting proxy resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateAccepted', 'ProvisioningStateProvisioning'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ArcInstanceResourceGroup - The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
	ArcInstanceResourceGroup *string `json:"arcInstanceResourceGroup,omitempty"`
	// ArcApplicationClientID - App id of arc AAD identity.
	ArcApplicationClientID *string `json:"arcApplicationClientId,omitempty"`
	// ArcApplicationTenantID - Tenant id of arc AAD identity.
	ArcApplicationTenantID *string `json:"arcApplicationTenantId,omitempty"`
	// ArcServicePrincipalObjectID - Object id of arc AAD service principal.
	ArcServicePrincipalObjectID *string `json:"arcServicePrincipalObjectId,omitempty"`
	// ArcApplicationObjectID - Object id of arc AAD identity.
	ArcApplicationObjectID *string `json:"arcApplicationObjectId,omitempty"`
	// AggregateState - READ-ONLY; Aggregate state of Arc agent across the nodes in this HCI cluster. Possible values include: 'ArcSettingAggregateStateNotSpecified', 'ArcSettingAggregateStateError', 'ArcSettingAggregateStateSucceeded', 'ArcSettingAggregateStateCanceled', 'ArcSettingAggregateStateFailed', 'ArcSettingAggregateStateConnected', 'ArcSettingAggregateStateDisconnected', 'ArcSettingAggregateStateDeleted', 'ArcSettingAggregateStateCreating', 'ArcSettingAggregateStateUpdating', 'ArcSettingAggregateStateDeleting', 'ArcSettingAggregateStateMoving', 'ArcSettingAggregateStatePartiallySucceeded', 'ArcSettingAggregateStatePartiallyConnected', 'ArcSettingAggregateStateInProgress'
	AggregateState ArcSettingAggregateState `json:"aggregateState,omitempty"`
	// PerNodeDetails - READ-ONLY; State of Arc agent in each of the nodes.
	PerNodeDetails *[]PerNodeState `json:"perNodeDetails,omitempty"`
	// ConnectivityProperties - contains connectivity related configuration for ARC resources
	ConnectivityProperties interface{} `json:"connectivityProperties,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcSettingProperties.
func (asp ArcSettingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.ArcInstanceResourceGroup != nil {
		objectMap["arcInstanceResourceGroup"] = asp.ArcInstanceResourceGroup
	}
	if asp.ArcApplicationClientID != nil {
		objectMap["arcApplicationClientId"] = asp.ArcApplicationClientID
	}
	if asp.ArcApplicationTenantID != nil {
		objectMap["arcApplicationTenantId"] = asp.ArcApplicationTenantID
	}
	if asp.ArcServicePrincipalObjectID != nil {
		objectMap["arcServicePrincipalObjectId"] = asp.ArcServicePrincipalObjectID
	}
	if asp.ArcApplicationObjectID != nil {
		objectMap["arcApplicationObjectId"] = asp.ArcApplicationObjectID
	}
	if asp.ConnectivityProperties != nil {
		objectMap["connectivityProperties"] = asp.ConnectivityProperties
	}
	return json.Marshal(objectMap)
}

// ArcSettingsCreateIdentityFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ArcSettingsCreateIdentityFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ArcSettingsClient) (ArcIdentityResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ArcSettingsCreateIdentityFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ArcSettingsCreateIdentityFuture.Result.
func (future *ArcSettingsCreateIdentityFuture) result(client ArcSettingsClient) (air ArcIdentityResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ArcSettingsCreateIdentityFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		air.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ArcSettingsCreateIdentityFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if air.Response.Response, err = future.GetResult(sender); err == nil && air.Response.Response.StatusCode != http.StatusNoContent {
		air, err = client.CreateIdentityResponder(air.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "azurestackhci.ArcSettingsCreateIdentityFuture", "Result", air.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ArcSettingsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ArcSettingsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ArcSettingsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ArcSettingsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ArcSettingsDeleteFuture.Result.
func (future *ArcSettingsDeleteFuture) result(client ArcSettingsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ArcSettingsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ArcSettingsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ArcSettingsPatch arcSetting details to update.
type ArcSettingsPatch struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ArcSettingsPatchProperties - ArcSettings properties.
	*ArcSettingsPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ArcSettingsPatch.
func (asp ArcSettingsPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if asp.Tags != nil {
		objectMap["tags"] = asp.Tags
	}
	if asp.ArcSettingsPatchProperties != nil {
		objectMap["properties"] = asp.ArcSettingsPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ArcSettingsPatch struct.
func (asp *ArcSettingsPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				asp.Tags = tags
			}
		case "properties":
			if v != nil {
				var arcSettingsPatchProperties ArcSettingsPatchProperties
				err = json.Unmarshal(*v, &arcSettingsPatchProperties)
				if err != nil {
					return err
				}
				asp.ArcSettingsPatchProperties = &arcSettingsPatchProperties
			}
		}
	}

	return nil
}

// ArcSettingsPatchProperties arcSettings properties.
type ArcSettingsPatchProperties struct {
	// ConnectivityProperties - contains connectivity related configuration for ARC resources
	ConnectivityProperties interface{} `json:"connectivityProperties,omitempty"`
}

// AzureEntityResource the resource model definition for an Azure Resource Manager resource with an etag.
type AzureEntityResource struct {
	// Etag - READ-ONLY; Resource Etag.
	Etag *string `json:"etag,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureEntityResource.
func (aer AzureEntityResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Cluster cluster details.
type Cluster struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; System data of Cluster resource
	*SystemData `json:"systemData,omitempty"`
	// ClusterProperties - Cluster properties.
	*ClusterProperties `json:"properties,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Cluster.
func (c Cluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if c.ClusterProperties != nil {
		objectMap["properties"] = c.ClusterProperties
	}
	if c.Tags != nil {
		objectMap["tags"] = c.Tags
	}
	if c.Location != nil {
		objectMap["location"] = c.Location
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Cluster struct.
func (c *Cluster) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				c.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var clusterProperties ClusterProperties
				err = json.Unmarshal(*v, &clusterProperties)
				if err != nil {
					return err
				}
				c.ClusterProperties = &clusterProperties
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				c.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				c.Location = &location
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				c.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				c.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				c.Type = &typeVar
			}
		}
	}

	return nil
}

// ClusterDesiredProperties desired properties of the cluster.
type ClusterDesiredProperties struct {
	// WindowsServerSubscription - Desired state of Windows Server Subscription. Possible values include: 'WindowsServerSubscriptionDisabled', 'WindowsServerSubscriptionEnabled'
	WindowsServerSubscription WindowsServerSubscription `json:"windowsServerSubscription,omitempty"`
	// DiagnosticLevel - Desired level of diagnostic data emitted by the cluster. Possible values include: 'DiagnosticLevelOff', 'DiagnosticLevelBasic', 'DiagnosticLevelEnhanced'
	DiagnosticLevel DiagnosticLevel `json:"diagnosticLevel,omitempty"`
}

// ClusterIdentityResponse cluster Identity details.
type ClusterIdentityResponse struct {
	autorest.Response `json:"-"`
	// ClusterIdentityResponseProperties - Cluster identity properties.
	*ClusterIdentityResponseProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterIdentityResponse.
func (cir ClusterIdentityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cir.ClusterIdentityResponseProperties != nil {
		objectMap["properties"] = cir.ClusterIdentityResponseProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterIdentityResponse struct.
func (cir *ClusterIdentityResponse) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var clusterIdentityResponseProperties ClusterIdentityResponseProperties
				err = json.Unmarshal(*v, &clusterIdentityResponseProperties)
				if err != nil {
					return err
				}
				cir.ClusterIdentityResponseProperties = &clusterIdentityResponseProperties
			}
		}
	}

	return nil
}

// ClusterIdentityResponseProperties ...
type ClusterIdentityResponseProperties struct {
	AadClientID                 *string `json:"aadClientId,omitempty"`
	AadTenantID                 *string `json:"aadTenantId,omitempty"`
	AadServicePrincipalObjectID *string `json:"aadServicePrincipalObjectId,omitempty"`
	AadApplicationObjectID      *string `json:"aadApplicationObjectId,omitempty"`
}

// ClusterList list of clusters.
type ClusterList struct {
	autorest.Response `json:"-"`
	// Value - List of clusters.
	Value *[]Cluster `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterList.
func (cl ClusterList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cl.Value != nil {
		objectMap["value"] = cl.Value
	}
	return json.Marshal(objectMap)
}

// ClusterListIterator provides access to a complete listing of Cluster values.
type ClusterListIterator struct {
	i    int
	page ClusterListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ClusterListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ClusterListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ClusterListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ClusterListIterator) Response() ClusterList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ClusterListIterator) Value() Cluster {
	if !iter.page.NotDone() {
		return Cluster{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ClusterListIterator type.
func NewClusterListIterator(page ClusterListPage) ClusterListIterator {
	return ClusterListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (cl ClusterList) IsEmpty() bool {
	return cl.Value == nil || len(*cl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (cl ClusterList) hasNextLink() bool {
	return cl.NextLink != nil && len(*cl.NextLink) != 0
}

// clusterListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (cl ClusterList) clusterListPreparer(ctx context.Context) (*http.Request, error) {
	if !cl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(cl.NextLink)))
}

// ClusterListPage contains a page of Cluster values.
type ClusterListPage struct {
	fn func(context.Context, ClusterList) (ClusterList, error)
	cl ClusterList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ClusterListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ClusterListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.cl)
		if err != nil {
			return err
		}
		page.cl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ClusterListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ClusterListPage) NotDone() bool {
	return !page.cl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ClusterListPage) Response() ClusterList {
	return page.cl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ClusterListPage) Values() []Cluster {
	if page.cl.IsEmpty() {
		return nil
	}
	return *page.cl.Value
}

// Creates a new instance of the ClusterListPage type.
func NewClusterListPage(cur ClusterList, getNextPage func(context.Context, ClusterList) (ClusterList, error)) ClusterListPage {
	return ClusterListPage{
		fn: getNextPage,
		cl: cur,
	}
}

// ClusterNode cluster node details.
type ClusterNode struct {
	// Name - READ-ONLY; Name of the cluster node.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; Id of the node in the cluster.
	ID *float64 `json:"id,omitempty"`
	// WindowsServerSubscription - READ-ONLY; State of Windows Server Subscription. Possible values include: 'WindowsServerSubscriptionDisabled', 'WindowsServerSubscriptionEnabled'
	WindowsServerSubscription WindowsServerSubscription `json:"windowsServerSubscription,omitempty"`
	// Manufacturer - READ-ONLY; Manufacturer of the cluster node hardware.
	Manufacturer *string `json:"manufacturer,omitempty"`
	// Model - READ-ONLY; Model name of the cluster node hardware.
	Model *string `json:"model,omitempty"`
	// OsName - READ-ONLY; Operating system running on the cluster node.
	OsName *string `json:"osName,omitempty"`
	// OsVersion - READ-ONLY; Version of the operating system running on the cluster node.
	OsVersion *string `json:"osVersion,omitempty"`
	// SerialNumber - READ-ONLY; Immutable id of the cluster node.
	SerialNumber *string `json:"serialNumber,omitempty"`
	// CoreCount - READ-ONLY; Number of physical cores on the cluster node.
	CoreCount *float64 `json:"coreCount,omitempty"`
	// MemoryInGiB - READ-ONLY; Total available memory on the cluster node (in GiB).
	MemoryInGiB *float64 `json:"memoryInGiB,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterNode.
func (cn ClusterNode) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ClusterPatch cluster details to update.
type ClusterPatch struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ClusterPatchProperties - Cluster properties.
	*ClusterPatchProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterPatch.
func (cp ClusterPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.Tags != nil {
		objectMap["tags"] = cp.Tags
	}
	if cp.ClusterPatchProperties != nil {
		objectMap["properties"] = cp.ClusterPatchProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ClusterPatch struct.
func (cp *ClusterPatch) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cp.Tags = tags
			}
		case "properties":
			if v != nil {
				var clusterPatchProperties ClusterPatchProperties
				err = json.Unmarshal(*v, &clusterPatchProperties)
				if err != nil {
					return err
				}
				cp.ClusterPatchProperties = &clusterPatchProperties
			}
		}
	}

	return nil
}

// ClusterPatchProperties cluster properties.
type ClusterPatchProperties struct {
	// CloudManagementEndpoint - Endpoint configured for management from the Azure portal
	CloudManagementEndpoint *string `json:"cloudManagementEndpoint,omitempty"`
	// AadClientID - App id of cluster AAD identity.
	AadClientID *string `json:"aadClientId,omitempty"`
	// AadTenantID - Tenant id of cluster AAD identity.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// DesiredProperties - Desired properties of the cluster.
	DesiredProperties *ClusterDesiredProperties `json:"desiredProperties,omitempty"`
}

// ClusterProperties cluster properties.
type ClusterProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateAccepted', 'ProvisioningStateProvisioning'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; Status of the cluster agent. Possible values include: 'StatusNotYetRegistered', 'StatusConnectedRecently', 'StatusNotConnectedRecently', 'StatusDisconnected', 'StatusError'
	Status Status `json:"status,omitempty"`
	// CloudID - READ-ONLY; Unique, immutable resource id.
	CloudID *string `json:"cloudId,omitempty"`
	// CloudManagementEndpoint - Endpoint configured for management from the Azure portal.
	CloudManagementEndpoint *string `json:"cloudManagementEndpoint,omitempty"`
	// AadClientID - App id of cluster AAD identity.
	AadClientID *string `json:"aadClientId,omitempty"`
	// AadTenantID - Tenant id of cluster AAD identity.
	AadTenantID *string `json:"aadTenantId,omitempty"`
	// AadApplicationObjectID - Object id of cluster AAD identity.
	AadApplicationObjectID *string `json:"aadApplicationObjectId,omitempty"`
	// AadServicePrincipalObjectID - Id of cluster identity service principal.
	AadServicePrincipalObjectID *string `json:"aadServicePrincipalObjectId,omitempty"`
	// DesiredProperties - Desired properties of the cluster.
	DesiredProperties *ClusterDesiredProperties `json:"desiredProperties,omitempty"`
	// ReportedProperties - READ-ONLY; Properties reported by cluster agent.
	ReportedProperties *ClusterReportedProperties `json:"reportedProperties,omitempty"`
	// TrialDaysRemaining - READ-ONLY; Number of days remaining in the trial period.
	TrialDaysRemaining *float64 `json:"trialDaysRemaining,omitempty"`
	// BillingModel - READ-ONLY; Type of billing applied to the resource.
	BillingModel *string `json:"billingModel,omitempty"`
	// RegistrationTimestamp - READ-ONLY; First cluster sync timestamp.
	RegistrationTimestamp *date.Time `json:"registrationTimestamp,omitempty"`
	// LastSyncTimestamp - READ-ONLY; Most recent cluster sync timestamp.
	LastSyncTimestamp *date.Time `json:"lastSyncTimestamp,omitempty"`
	// LastBillingTimestamp - READ-ONLY; Most recent billing meter timestamp.
	LastBillingTimestamp *date.Time `json:"lastBillingTimestamp,omitempty"`
	// ServiceEndpoint - READ-ONLY; Region specific DataPath Endpoint of the cluster.
	ServiceEndpoint *string `json:"serviceEndpoint,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterProperties.
func (cp ClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cp.CloudManagementEndpoint != nil {
		objectMap["cloudManagementEndpoint"] = cp.CloudManagementEndpoint
	}
	if cp.AadClientID != nil {
		objectMap["aadClientId"] = cp.AadClientID
	}
	if cp.AadTenantID != nil {
		objectMap["aadTenantId"] = cp.AadTenantID
	}
	if cp.AadApplicationObjectID != nil {
		objectMap["aadApplicationObjectId"] = cp.AadApplicationObjectID
	}
	if cp.AadServicePrincipalObjectID != nil {
		objectMap["aadServicePrincipalObjectId"] = cp.AadServicePrincipalObjectID
	}
	if cp.DesiredProperties != nil {
		objectMap["desiredProperties"] = cp.DesiredProperties
	}
	return json.Marshal(objectMap)
}

// ClusterReportedProperties properties reported by cluster agent.
type ClusterReportedProperties struct {
	// ClusterName - READ-ONLY; Name of the on-prem cluster connected to this resource.
	ClusterName *string `json:"clusterName,omitempty"`
	// ClusterID - READ-ONLY; Unique id generated by the on-prem cluster.
	ClusterID *string `json:"clusterId,omitempty"`
	// ClusterVersion - READ-ONLY; Version of the cluster software.
	ClusterVersion *string `json:"clusterVersion,omitempty"`
	// Nodes - READ-ONLY; List of nodes reported by the cluster.
	Nodes *[]ClusterNode `json:"nodes,omitempty"`
	// LastUpdated - READ-ONLY; Last time the cluster reported the data.
	LastUpdated *date.Time `json:"lastUpdated,omitempty"`
	// ImdsAttestation - READ-ONLY; IMDS attestation status of the cluster. Possible values include: 'ImdsAttestationDisabled', 'ImdsAttestationEnabled'
	ImdsAttestation ImdsAttestation `json:"imdsAttestation,omitempty"`
	// DiagnosticLevel - Level of diagnostic data emitted by the cluster. Possible values include: 'DiagnosticLevelOff', 'DiagnosticLevelBasic', 'DiagnosticLevelEnhanced'
	DiagnosticLevel DiagnosticLevel `json:"diagnosticLevel,omitempty"`
}

// MarshalJSON is the custom marshaler for ClusterReportedProperties.
func (crp ClusterReportedProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if crp.DiagnosticLevel != "" {
		objectMap["diagnosticLevel"] = crp.DiagnosticLevel
	}
	return json.Marshal(objectMap)
}

// ClustersCreateIdentityFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersCreateIdentityFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (ClusterIdentityResponse, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersCreateIdentityFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersCreateIdentityFuture.Result.
func (future *ClustersCreateIdentityFuture) result(client ClustersClient) (cir ClusterIdentityResponse, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ClustersCreateIdentityFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		cir.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ClustersCreateIdentityFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cir.Response.Response, err = future.GetResult(sender); err == nil && cir.Response.Response.StatusCode != http.StatusNoContent {
		cir, err = client.CreateIdentityResponder(cir.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "azurestackhci.ClustersCreateIdentityFuture", "Result", cir.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ClustersDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ClustersDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersDeleteFuture.Result.
func (future *ClustersDeleteFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ClustersDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ClustersDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ClustersUploadCertificateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type ClustersUploadCertificateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ClustersClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ClustersUploadCertificateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ClustersUploadCertificateFuture.Result.
func (future *ClustersUploadCertificateFuture) result(client ClustersClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ClustersUploadCertificateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ClustersUploadCertificateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetail the error detail.
type ErrorDetail struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorDetail `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetail.
func (ed ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.).
type ErrorResponse struct {
	// Error - The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Extension details of a particular extension in HCI Cluster.
type Extension struct {
	autorest.Response `json:"-"`
	// SystemData - READ-ONLY; System data of Extension resource.
	*SystemData `json:"systemData,omitempty"`
	// ExtensionProperties - Describes Machine Extension Properties.
	*ExtensionProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Extension.
func (e Extension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if e.ExtensionProperties != nil {
		objectMap["properties"] = e.ExtensionProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Extension struct.
func (e *Extension) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "systemData":
			if v != nil {
				var systemData SystemData
				err = json.Unmarshal(*v, &systemData)
				if err != nil {
					return err
				}
				e.SystemData = &systemData
			}
		case "properties":
			if v != nil {
				var extensionProperties ExtensionProperties
				err = json.Unmarshal(*v, &extensionProperties)
				if err != nil {
					return err
				}
				e.ExtensionProperties = &extensionProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				e.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				e.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				e.Type = &typeVar
			}
		}
	}

	return nil
}

// ExtensionList list of Extensions in HCI cluster.
type ExtensionList struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of Extensions in HCI cluster.
	Value *[]Extension `json:"value,omitempty"`
	// NextLink - READ-ONLY; Link to the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionList.
func (el ExtensionList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExtensionListIterator provides access to a complete listing of Extension values.
type ExtensionListIterator struct {
	i    int
	page ExtensionListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ExtensionListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ExtensionListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ExtensionListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ExtensionListIterator) Response() ExtensionList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ExtensionListIterator) Value() Extension {
	if !iter.page.NotDone() {
		return Extension{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ExtensionListIterator type.
func NewExtensionListIterator(page ExtensionListPage) ExtensionListIterator {
	return ExtensionListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (el ExtensionList) IsEmpty() bool {
	return el.Value == nil || len(*el.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (el ExtensionList) hasNextLink() bool {
	return el.NextLink != nil && len(*el.NextLink) != 0
}

// extensionListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (el ExtensionList) extensionListPreparer(ctx context.Context) (*http.Request, error) {
	if !el.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(el.NextLink)))
}

// ExtensionListPage contains a page of Extension values.
type ExtensionListPage struct {
	fn func(context.Context, ExtensionList) (ExtensionList, error)
	el ExtensionList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ExtensionListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ExtensionListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.el)
		if err != nil {
			return err
		}
		page.el = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ExtensionListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ExtensionListPage) NotDone() bool {
	return !page.el.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ExtensionListPage) Response() ExtensionList {
	return page.el
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ExtensionListPage) Values() []Extension {
	if page.el.IsEmpty() {
		return nil
	}
	return *page.el.Value
}

// Creates a new instance of the ExtensionListPage type.
func NewExtensionListPage(cur ExtensionList, getNextPage func(context.Context, ExtensionList) (ExtensionList, error)) ExtensionListPage {
	return ExtensionListPage{
		fn: getNextPage,
		el: cur,
	}
}

// ExtensionParameters describes the properties of a Machine Extension. This object mirrors the definition
// in HybridCompute.
type ExtensionParameters struct {
	// ForceUpdateTag - How the extension handler should be forced to update even if the extension configuration has not changed.
	ForceUpdateTag *string `json:"forceUpdateTag,omitempty"`
	// Publisher - The name of the extension handler publisher.
	Publisher *string `json:"publisher,omitempty"`
	// Type - Specifies the type of the extension; an example is "CustomScriptExtension".
	Type *string `json:"type,omitempty"`
	// TypeHandlerVersion - Specifies the version of the script handler.
	TypeHandlerVersion *string `json:"typeHandlerVersion,omitempty"`
	// AutoUpgradeMinorVersion - Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
	AutoUpgradeMinorVersion *bool `json:"autoUpgradeMinorVersion,omitempty"`
	// Settings - Json formatted public settings for the extension.
	Settings interface{} `json:"settings,omitempty"`
	// ProtectedSettings - Protected settings (may contain secrets).
	ProtectedSettings interface{} `json:"protectedSettings,omitempty"`
}

// ExtensionProperties status of Arc Extension for a particular node in HCI Cluster.
type ExtensionProperties struct {
	// ProvisioningState - READ-ONLY; Provisioning state of the Extension proxy resource. Possible values include: 'ProvisioningStateSucceeded', 'ProvisioningStateFailed', 'ProvisioningStateCanceled', 'ProvisioningStateAccepted', 'ProvisioningStateProvisioning'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// ExtensionParameters - Parameters specific to this extension type.
	*ExtensionParameters `json:"extensionParameters,omitempty"`
	// AggregateState - READ-ONLY; Aggregate state of Arc Extensions across the nodes in this HCI cluster. Possible values include: 'ExtensionAggregateStateNotSpecified', 'ExtensionAggregateStateError', 'ExtensionAggregateStateSucceeded', 'ExtensionAggregateStateCanceled', 'ExtensionAggregateStateFailed', 'ExtensionAggregateStateConnected', 'ExtensionAggregateStateDisconnected', 'ExtensionAggregateStateDeleted', 'ExtensionAggregateStateCreating', 'ExtensionAggregateStateUpdating', 'ExtensionAggregateStateDeleting', 'ExtensionAggregateStateMoving', 'ExtensionAggregateStatePartiallySucceeded', 'ExtensionAggregateStatePartiallyConnected', 'ExtensionAggregateStateInProgress'
	AggregateState ExtensionAggregateState `json:"aggregateState,omitempty"`
	// PerNodeExtensionDetails - READ-ONLY; State of Arc Extension in each of the nodes.
	PerNodeExtensionDetails *[]PerNodeExtensionState `json:"perNodeExtensionDetails,omitempty"`
}

// MarshalJSON is the custom marshaler for ExtensionProperties.
func (ep ExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ep.ExtensionParameters != nil {
		objectMap["extensionParameters"] = ep.ExtensionParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ExtensionProperties struct.
func (ep *ExtensionProperties) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "provisioningState":
			if v != nil {
				var provisioningState ProvisioningState
				err = json.Unmarshal(*v, &provisioningState)
				if err != nil {
					return err
				}
				ep.ProvisioningState = provisioningState
			}
		case "extensionParameters":
			if v != nil {
				var extensionParameters ExtensionParameters
				err = json.Unmarshal(*v, &extensionParameters)
				if err != nil {
					return err
				}
				ep.ExtensionParameters = &extensionParameters
			}
		case "aggregateState":
			if v != nil {
				var aggregateState ExtensionAggregateState
				err = json.Unmarshal(*v, &aggregateState)
				if err != nil {
					return err
				}
				ep.AggregateState = aggregateState
			}
		case "perNodeExtensionDetails":
			if v != nil {
				var perNodeExtensionDetails []PerNodeExtensionState
				err = json.Unmarshal(*v, &perNodeExtensionDetails)
				if err != nil {
					return err
				}
				ep.PerNodeExtensionDetails = &perNodeExtensionDetails
			}
		}
	}

	return nil
}

// ExtensionsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (Extension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsCreateFuture.Result.
func (future *ExtensionsCreateFuture) result(client ExtensionsClient) (e Extension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ExtensionsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ExtensionsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.CreateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "azurestackhci.ExtensionsCreateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ExtensionsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsDeleteFuture.Result.
func (future *ExtensionsDeleteFuture) result(client ExtensionsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ExtensionsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ExtensionsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ExtensionsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ExtensionsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ExtensionsClient) (Extension, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ExtensionsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ExtensionsUpdateFuture.Result.
func (future *ExtensionsUpdateFuture) result(client ExtensionsClient) (e Extension, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "azurestackhci.ExtensionsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		e.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("azurestackhci.ExtensionsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if e.Response.Response, err = future.GetResult(sender); err == nil && e.Response.Response.StatusCode != http.StatusNoContent {
		e, err = client.UpdateResponder(e.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "azurestackhci.ExtensionsUpdateFuture", "Result", e.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Operation details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Name - READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action"
	Name *string `json:"name,omitempty"`
	// IsDataAction - READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane operations.
	IsDataAction *bool `json:"isDataAction,omitempty"`
	// Display - Localized display information for this particular operation.
	Display *OperationDisplay `json:"display,omitempty"`
	// Origin - READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default value is "user,system". Possible values include: 'OriginUser', 'OriginSystem', 'OriginUsersystem'
	Origin Origin `json:"origin,omitempty"`
	// ActionType - READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs. Possible values include: 'ActionTypeInternal'
	ActionType ActionType `json:"actionType,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay localized display information for this particular operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft Compute".
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job Schedule Collections".
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string `json:"description,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult a list of REST API operations supported by an Azure Resource Provider. It contains
// an URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of operations supported by the resource provider
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PasswordCredential ...
type PasswordCredential struct {
	autorest.Response `json:"-"`
	SecretText        *string    `json:"secretText,omitempty"`
	KeyID             *string    `json:"keyId,omitempty"`
	StartDateTime     *date.Time `json:"startDateTime,omitempty"`
	EndDateTime       *date.Time `json:"endDateTime,omitempty"`
}

// PerNodeExtensionState status of Arc Extension for a particular node in HCI Cluster.
type PerNodeExtensionState struct {
	// Name - READ-ONLY; Name of the node in HCI Cluster.
	Name *string `json:"name,omitempty"`
	// Extension - READ-ONLY; Fully qualified resource ID for the particular Arc Extension on this node.
	Extension *string `json:"extension,omitempty"`
	// State - READ-ONLY; State of Arc Extension in this node. Possible values include: 'NodeExtensionStateNotSpecified', 'NodeExtensionStateError', 'NodeExtensionStateSucceeded', 'NodeExtensionStateCanceled', 'NodeExtensionStateFailed', 'NodeExtensionStateConnected', 'NodeExtensionStateDisconnected', 'NodeExtensionStateDeleted', 'NodeExtensionStateCreating', 'NodeExtensionStateUpdating', 'NodeExtensionStateDeleting', 'NodeExtensionStateMoving'
	State NodeExtensionState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for PerNodeExtensionState.
func (pnes PerNodeExtensionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PerNodeState status of Arc agent for a particular node in HCI Cluster.
type PerNodeState struct {
	// Name - READ-ONLY; Name of the Node in HCI Cluster
	Name *string `json:"name,omitempty"`
	// ArcInstance - READ-ONLY; Fully qualified resource ID for the Arc agent of this node.
	ArcInstance *string `json:"arcInstance,omitempty"`
	// State - READ-ONLY; State of Arc agent in this node. Possible values include: 'NodeArcStateNotSpecified', 'NodeArcStateError', 'NodeArcStateSucceeded', 'NodeArcStateCanceled', 'NodeArcStateFailed', 'NodeArcStateConnected', 'NodeArcStateDisconnected', 'NodeArcStateDeleted', 'NodeArcStateCreating', 'NodeArcStateUpdating', 'NodeArcStateDeleting', 'NodeArcStateMoving'
	State NodeArcState `json:"state,omitempty"`
}

// MarshalJSON is the custom marshaler for PerNodeState.
func (pns PerNodeState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ProxyResource the resource model definition for a Azure Resource Manager proxy resource. It will not
// have tags and a location
type ProxyResource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ProxyResource.
func (pr ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// RawCertificateData ...
type RawCertificateData struct {
	Certificates *[]string `json:"certificates,omitempty"`
}

// Resource common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// SystemData metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// CreatedBy - The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`
	// CreatedByType - The type of identity that created the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	CreatedByType CreatedByType `json:"createdByType,omitempty"`
	// CreatedAt - The timestamp of resource creation (UTC).
	CreatedAt *date.Time `json:"createdAt,omitempty"`
	// LastModifiedBy - The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`
	// LastModifiedByType - The type of identity that last modified the resource. Possible values include: 'CreatedByTypeUser', 'CreatedByTypeApplication', 'CreatedByTypeManagedIdentity', 'CreatedByTypeKey'
	LastModifiedByType CreatedByType `json:"lastModifiedByType,omitempty"`
	// LastModifiedAt - The timestamp of resource last modification (UTC)
	LastModifiedAt *date.Time `json:"lastModifiedAt,omitempty"`
}

// TrackedResource the resource model definition for an Azure Resource Manager tracked top level resource
// which has 'tags' and a 'location'
type TrackedResource struct {
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// Location - The geo-location where the resource lives
	Location *string `json:"location,omitempty"`
	// ID - READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for TrackedResource.
func (tr TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Tags != nil {
		objectMap["tags"] = tr.Tags
	}
	if tr.Location != nil {
		objectMap["location"] = tr.Location
	}
	return json.Marshal(objectMap)
}

// UploadCertificateRequest ...
type UploadCertificateRequest struct {
	Properties *RawCertificateData `json:"properties,omitempty"`
}
