// META: global=window,worker
// META: title=Request cache - default with conditional requests
// META: timeout=long
// META: script=/common/utils.js
// META: script=/common/get-host-info.sub.js
// META: script=request-cache.js

var tests = [
  {
    name: 'RequestCache "default" mode with an If-Modified-Since header (following a request without additional headers) is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Modified-Since": now.toGMTString()}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Modified-Since header (following a request without additional headers) is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Modified-Since": now.toGMTString()}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Modified-Since header is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{"If-Modified-Since": now.toGMTString()}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Modified-Since header is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{"If-Modified-Since": now.toGMTString()}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-None-Match header (following a request without additional headers) is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-None-Match": '"foo"'}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-None-Match header (following a request without additional headers) is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-None-Match": '"foo"'}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-None-Match header is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{"If-None-Match": '"foo"'}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-None-Match header is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{"If-None-Match": '"foo"'}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Unmodified-Since header (following a request without additional headers) is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Unmodified-Since": now.toGMTString()}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Unmodified-Since header (following a request without additional headers) is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Unmodified-Since": now.toGMTString()}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Unmodified-Since header is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{"If-Unmodified-Since": now.toGMTString()}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Unmodified-Since header is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{"If-Unmodified-Since": now.toGMTString()}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Match header (following a request without additional headers) is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Match": '"foo"'}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Match header (following a request without additional headers) is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Match": '"foo"'}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Match header is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{"If-Match": '"foo"'}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Match header is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{"If-Match": '"foo"'}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Range header (following a request without additional headers) is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Range": '"foo"'}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Range header (following a request without additional headers) is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{}, {"If-Range": '"foo"'}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [false, true],
  },
  {
    name: 'RequestCache "default" mode with an If-Range header is treated similarly to "no-store"',
    state: "stale",
    request_cache: ["default", "default"],
    request_headers: [{"If-Range": '"foo"'}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
  {
    name: 'RequestCache "default" mode with an If-Range header is treated similarly to "no-store"',
    state: "fresh",
    request_cache: ["default", "default"],
    request_headers: [{"If-Range": '"foo"'}, {}],
    expected_validation_headers: [false, false],
    expected_no_cache_headers: [true, false],
  },
];
run_tests(tests);
