/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;

public class LogManager {
    private static final LogManager manager;
    private volatile Properties props;
    private static final Level defaultLevel;
    private final Map<Object, Integer> listenerMap;
    private final LoggerContext systemContext;
    private final LoggerContext userContext;
    private volatile Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers;
    private boolean deathImminent;
    private boolean initializedCalled;
    private volatile boolean initializationDone;
    private WeakHashMap<Object, LoggerContext> contextsMap;
    private final ReferenceQueue<Logger> loggerRefQueue;
    private static final int MAX_ITERATIONS = 400;
    private final Permission controlPermission;
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
    static final /* synthetic */ boolean $assertionsDisabled;

    protected LogManager() {
    }

    public static LogManager getLogManager() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
    }

    public boolean addLogger(Logger logger) {
        return false;
    }

    public Logger getLogger(String string) {
        return null;
    }

    public Enumeration<String> getLoggerNames() {
        return null;
    }

    public void readConfiguration() throws IOException, SecurityException {
    }

    public void reset() throws SecurityException {
    }

    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
    }

    public String getProperty(String string) {
        return null;
    }

    public void checkAccess() throws SecurityException {
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        return null;
    }

    private final class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null, null, LogManager.this, true);
        }

        @Override
        public void log(LogRecord record) {
            LogManager.this.initializeGlobalHandlers();
            super.log(record);
        }

        @Override
        public void addHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(h);
        }

        @Override
        public void removeHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(h);
        }

        Handler[] accessCheckedHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.accessCheckedHandlers();
        }
    }

    private static class LogNode {
        HashMap<String, LogNode> children;
        LoggerWeakRef loggerRef;
        LogNode parent;
        final LoggerContext context;

        LogNode(LogNode parent, LoggerContext context) {
            this.parent = parent;
            this.context = context;
        }

        void walkAndSetParent(Logger parent) {
            if (this.children == null) {
                return;
            }
            for (LogNode node : this.children.values()) {
                Logger logger;
                LoggerWeakRef ref = node.loggerRef;
                Logger logger2 = logger = ref == null ? null : (Logger)ref.get();
                if (logger == null) {
                    node.walkAndSetParent(parent);
                    continue;
                }
                LogManager.doSetParent((Logger)logger, (Logger)parent);
            }
        }
    }

    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private String name;
        private LogNode node;
        private WeakReference<Logger> parentRef;
        private boolean disposed = false;

        LoggerWeakRef(LogManager this$0, Logger logger) {
            super(logger, this$0.loggerRefQueue);
            this.name = logger.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            LoggerWeakRef loggerWeakRef = this;
            synchronized (loggerWeakRef) {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
            }
            LogNode n = this.node;
            if (n != null) {
                LoggerContext loggerContext = n.context;
                synchronized (loggerContext) {
                    n.context.removeLoggerRef(this.name, this);
                    this.name = null;
                    if (n.loggerRef == this) {
                        n.loggerRef = null;
                    }
                    this.node = null;
                }
            }
            if (this.parentRef != null) {
                Logger parent = (Logger)this.parentRef.get();
                if (parent != null) {
                    parent.removeChildLogger(this);
                }
                this.parentRef = null;
            }
        }

        void setNode(LogNode node) {
            this.node = node;
        }

        void setParentRef(WeakReference<Logger> parentRef) {
            this.parentRef = parentRef;
        }
    }

    final class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext(LogManager this$0) {
        }

        @Override
        Logger demandLogger(String name, String resourceBundleName, Module module) {
            Logger result = this.findLogger(name);
            if (result == null) {
                Logger newLogger = new Logger(name, resourceBundleName, module, this.getOwner(), true);
                while ((result = this.addLocalLogger(newLogger) ? newLogger : this.findLogger(name)) == null) {
                }
            }
            return result;
        }
    }

    class LoggerContext {
        private final ConcurrentHashMap<String, LoggerWeakRef> namedLoggers = new ConcurrentHashMap();
        private final LogNode root = new LogNode(null, this);

        private LoggerContext() {
        }

        final boolean requiresDefaultLoggers() {
            boolean requiresDefaultLoggers;
            boolean bl = requiresDefaultLoggers = this.getOwner() == manager;
            if (requiresDefaultLoggers) {
                this.getOwner().ensureLogManagerInitialized();
            }
            return requiresDefaultLoggers;
        }

        final LogManager getOwner() {
            return LogManager.this;
        }

        final Logger getRootLogger() {
            return this.getOwner().rootLogger;
        }

        final Logger getGlobalLogger() {
            Logger global = Logger.global;
            return global;
        }

        Logger demandLogger(String name, String resourceBundleName, Module module) {
            LogManager owner = this.getOwner();
            return owner.demandLogger(name, resourceBundleName, module);
        }

        private void ensureInitialized() {
            if (this.requiresDefaultLoggers()) {
                this.ensureDefaultLogger(this.getRootLogger());
                this.ensureDefaultLogger(this.getGlobalLogger());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Logger findLogger(String name) {
            Logger logger;
            LoggerWeakRef ref = this.namedLoggers.get(name);
            Logger logger2 = logger = ref == null ? null : (Logger)ref.get();
            if (logger != null || ref == null && !name.isEmpty() && !name.equals("global")) {
                return logger;
            }
            LoggerContext loggerContext = this;
            synchronized (loggerContext) {
                this.ensureInitialized();
                ref = this.namedLoggers.get(name);
                if (ref == null) {
                    return null;
                }
                logger = (Logger)ref.get();
                if (logger == null) {
                    ref.dispose();
                }
                return logger;
            }
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            String name;
            if (this.requiresDefaultLoggers() && !(name = logger.getName()).isEmpty()) {
                this.ensureDefaultLogger(this.getRootLogger());
                if (!"global".equals(name)) {
                    this.ensureDefaultLogger(this.getGlobalLogger());
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            if (!this.requiresDefaultLoggers() || logger == null || logger != this.getGlobalLogger() && logger != LogManager.this.rootLogger) {
                assert (logger == null);
                return;
            }
            if (!this.namedLoggers.containsKey(logger.getName())) {
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            return this.addLocalLogger(logger, this.requiresDefaultLoggers());
        }

        synchronized boolean addLocalLogger(Logger logger, boolean addDefaultLoggersIfNeeded) {
            LoggerWeakRef nodeRef;
            String name;
            if (addDefaultLoggersIfNeeded) {
                this.ensureAllDefaultLoggers(logger);
            }
            if ((name = logger.getName()) == null) {
                throw new NullPointerException();
            }
            LoggerWeakRef ref = this.namedLoggers.get(name);
            if (ref != null) {
                if (ref.refersTo(null)) {
                    ref.dispose();
                } else {
                    return false;
                }
            }
            LogManager owner = this.getOwner();
            logger.setLogManager(owner);
            LogManager logManager = owner;
            Objects.requireNonNull(logManager);
            ref = new LoggerWeakRef(logManager, logger);
            Level level = owner.getLevelProperty(name + ".level", null);
            if (level != null && !logger.isLevelInitialized()) {
                LogManager.doSetLevel((Logger)logger, (Level)level);
            }
            this.processParentHandlers(logger, name, VisitedLoggers.NEVER);
            LogNode node = this.getNode(name);
            node.loggerRef = ref;
            Logger parent = null;
            LogNode nodep = node.parent;
            while (nodep != null && ((nodeRef = nodep.loggerRef) == null || (parent = (Logger)nodeRef.get()) == null)) {
                nodep = nodep.parent;
            }
            if (parent != null) {
                LogManager.doSetParent((Logger)logger, parent);
            }
            node.walkAndSetParent(logger);
            ref.setNode(node);
            this.namedLoggers.put(name, ref);
            return true;
        }

        void removeLoggerRef(String name, LoggerWeakRef ref) {
            this.namedLoggers.remove(name, ref);
        }

        synchronized Enumeration<String> getLoggerNames() {
            this.ensureInitialized();
            return Collections.enumeration(this.namedLoggers.keySet());
        }

        private void processParentHandlers(final Logger logger, final String name, Predicate<Logger> visited) {
            String pname;
            int ix2;
            final LogManager owner = this.getOwner();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    boolean useParent;
                    if (logger != owner.rootLogger && !(useParent = owner.getBooleanProperty(name + ".useParentHandlers", true))) {
                        logger.setUseParentHandlers(false);
                    }
                    return null;
                }
            });
            int ix = 1;
            while ((ix2 = name.indexOf(46, ix)) >= 0 && (owner.getProperty((pname = name.substring(0, ix2)) + ".level") == null && owner.getProperty(pname + ".handlers") == null || !visited.test(this.demandLogger(pname, null, null)))) {
                ix = ix2 + 1;
            }
        }

        LogNode getNode(String name) {
            if (name == null || name.isEmpty()) {
                return this.root;
            }
            LogNode node = this.root;
            while (name.length() > 0) {
                LogNode child;
                String head;
                int ix = name.indexOf(46);
                if (ix > 0) {
                    head = name.substring(0, ix);
                    name = name.substring(ix + 1);
                } else {
                    head = name;
                    name = "";
                }
                if (node.children == null) {
                    node.children = new HashMap();
                }
                if ((child = node.children.get(head)) == null) {
                    child = new LogNode(node, this);
                    node.children.put(head, child);
                }
                node = child;
            }
            return node;
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
            super(null, null, "Logging-Cleaner", 0L, false);
            this.setContextClassLoader(null);
        }

        @Override
        public void run() {
            LogManager mgr = manager;
            LogManager.this.configurationLock.lock();
            LogManager.this.globalHandlersState = 4;
            LogManager.this.configurationLock.unlock();
            LogManager.this.reset();
        }
    }
}

