/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databricks.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class DatabricksTable
extends GenericTable {
    private static final Log log = Log.getLog(DatabricksTable.class);
    private volatile boolean additionalInfoLoaded = false;
    private String owner;
    private String location;
    private String createdTime;
    private String tableProperties;
    private String storageProperties;
    private String description;

    public DatabricksTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    @Property(viewable=true, order=2)
    public String getOwner(@NotNull DBRProgressMonitor monitor) {
        this.checkExtraInfo(monitor);
        return this.owner;
    }

    @Property(viewable=true, order=3)
    public String getLocation(@NotNull DBRProgressMonitor monitor) {
        this.checkExtraInfo(monitor);
        return this.location;
    }

    @Property(viewable=true, order=4)
    public String getCreatedTime(@NotNull DBRProgressMonitor monitor) {
        this.checkExtraInfo(monitor);
        return this.createdTime;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=98)
    public String getTableProperties(@NotNull DBRProgressMonitor monitor) {
        this.checkExtraInfo(monitor);
        return this.tableProperties;
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=99)
    public String getStorageProperties(@NotNull DBRProgressMonitor monitor) {
        this.checkExtraInfo(monitor);
        return this.storageProperties;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void checkExtraInfo(@NotNull DBRProgressMonitor monitor) {
        if (!this.additionalInfoLoaded) {
            this.loadAdditionalInfo(monitor);
        }
    }

    private void loadAdditionalInfo(@NotNull DBRProgressMonitor monitor) {
        if (!this.isPersisted()) {
            this.additionalInfoLoaded = true;
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table extra info");){
                try {
                    Throwable throwable2 = null;
                    Object var6_11 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("DESCRIBE TABLE EXTENDED " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));){
                        Throwable throwable3 = null;
                        Object var9_16 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            while (dbResult.next()) {
                                String key = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"col_name");
                                String value = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"data_type");
                                if (!CommonUtils.isNotEmpty((String)key)) continue;
                                switch (key) {
                                    case "Comment": {
                                        this.description = value;
                                        break;
                                    }
                                    case "Location": {
                                        this.location = value;
                                        break;
                                    }
                                    case "Owner": {
                                        this.owner = value;
                                        break;
                                    }
                                    case "Created Time": {
                                        this.createdTime = value;
                                        break;
                                    }
                                    case "Table Properties": {
                                        this.tableProperties = value;
                                        break;
                                    }
                                    case "Storage Properties": {
                                        this.storageProperties = value;
                                    }
                                }
                            }
                            this.additionalInfoLoaded = true;
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"Can't read additional table info", (Throwable)e);
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (DBCException e) {
            log.error((Object)"Can't read additional table info", (Throwable)e);
        }
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this.getSchema(), this});
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.additionalInfoLoaded = false;
        return super.refreshObject(monitor);
    }
}

