/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.ui.editors;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLGrant;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPrivilege;
import org.jkiss.dbeaver.ext.mysql.model.MySQLUser;
import org.jkiss.dbeaver.ext.mysql.ui.config.MySQLCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.mysql.ui.config.MySQLUserManager;
import org.jkiss.dbeaver.ext.mysql.ui.config.UserPropertyHandler;
import org.jkiss.dbeaver.ext.mysql.ui.controls.PrivilegeTableControl;
import org.jkiss.dbeaver.ext.mysql.ui.editors.MySQLUserEditorAbstract;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.DBECommandReflector;
import org.jkiss.dbeaver.model.edit.prop.DBEPropertyHandler;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAdapter;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ProgressPageControl;
import org.jkiss.dbeaver.ui.editors.AbstractDatabaseObjectEditor;
import org.jkiss.dbeaver.ui.editors.ControlPropertyCommandListener;

public class MySQLUserEditorGeneral
extends MySQLUserEditorAbstract {
    public static final String DEF_PASSWORD_VALUE = "**********";
    private PageControl pageControl;
    private boolean isLoaded;
    private PrivilegeTableControl privTable;
    private boolean newUser;
    private Text userNameText;
    private Text hostText;
    private CommandListener commandlistener;

    public void createPartControl(Composite parent) {
        this.pageControl = new PageControl(parent);
        Composite container = UIUtils.createPlaceholder((Composite)this.pageControl, (int)2, (int)5);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.newUser = !((MySQLUser)this.getDatabaseObject()).isPersisted();
        Group loginGroup = UIUtils.createControlGroup((Composite)container, (String)MySQLUIMessages.editors_user_editor_general_group_login, (int)2, (int)768, (int)0);
        this.userNameText = UIUtils.createLabelText((Composite)loginGroup, (String)MySQLUIMessages.editors_user_editor_general_label_user_name, (String)((MySQLUser)this.getDatabaseObject()).getUserName());
        this.userNameText.setEditable(this.newUser);
        if (this.newUser) {
            ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)this.userNameText, (DBEPropertyHandler)UserPropertyHandler.NAME);
        }
        this.hostText = UIUtils.createLabelText((Composite)loginGroup, (String)MySQLUIMessages.editors_user_editor_general_label_host, (String)((MySQLUser)this.getDatabaseObject()).getHost());
        this.hostText.setEditable(this.newUser);
        if (this.newUser) {
            ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)this.hostText, (DBEPropertyHandler)UserPropertyHandler.HOST);
        }
        String password = this.newUser ? "" : DEF_PASSWORD_VALUE;
        Text passwordText = UIUtils.createLabelText((Composite)loginGroup, (String)MySQLUIMessages.editors_user_editor_general_label_password, (String)password, (int)0x400800);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)passwordText, (DBEPropertyHandler)UserPropertyHandler.PASSWORD);
        Text confirmText = UIUtils.createLabelText((Composite)loginGroup, (String)MySQLUIMessages.editors_user_editor_general_label_confirm, (String)password, (int)0x400800);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)confirmText, (DBEPropertyHandler)UserPropertyHandler.PASSWORD_CONFIRM);
        Group limitsGroup = UIUtils.createControlGroup((Composite)container, (String)MySQLUIMessages.editors_user_editor_general_group_limits, (int)2, (int)768, (int)0);
        Spinner maxQueriesText = UIUtils.createLabelSpinner((Composite)limitsGroup, (String)MySQLUIMessages.editors_user_editor_general_spinner_max_queries, (int)((MySQLUser)this.getDatabaseObject()).getMaxQuestions(), (int)0, (int)Integer.MAX_VALUE);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)maxQueriesText, (DBEPropertyHandler)UserPropertyHandler.MAX_QUERIES);
        Spinner maxUpdatesText = UIUtils.createLabelSpinner((Composite)limitsGroup, (String)MySQLUIMessages.editors_user_editor_general_spinner_max_updates, (int)((MySQLUser)this.getDatabaseObject()).getMaxUpdates(), (int)0, (int)Integer.MAX_VALUE);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)maxUpdatesText, (DBEPropertyHandler)UserPropertyHandler.MAX_UPDATES);
        Spinner maxConnectionsText = UIUtils.createLabelSpinner((Composite)limitsGroup, (String)MySQLUIMessages.editors_user_editor_general_spinner_max_connections, (int)((MySQLUser)this.getDatabaseObject()).getMaxConnections(), (int)0, (int)Integer.MAX_VALUE);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)maxConnectionsText, (DBEPropertyHandler)UserPropertyHandler.MAX_CONNECTIONS);
        Spinner maxUserConnectionsText = UIUtils.createLabelSpinner((Composite)limitsGroup, (String)MySQLUIMessages.editors_user_editor_general_spinner_max_user_connections, (int)((MySQLUser)this.getDatabaseObject()).getMaxUserConnections(), (int)0, (int)Integer.MAX_VALUE);
        ControlPropertyCommandListener.create((AbstractDatabaseObjectEditor)this, (Widget)maxUserConnectionsText, (DBEPropertyHandler)UserPropertyHandler.MAX_USER_CONNECTIONS);
        this.privTable = new PrivilegeTableControl(container, MySQLUIMessages.editors_user_editor_general_control_dba_privileges, true);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.privTable.setLayoutData(gd);
        this.privTable.addListener(24, event -> {
            final MySQLPrivilege privilege = (MySQLPrivilege)event.data;
            final boolean grant = event.detail >= 1;
            boolean withGrantOption = event.detail == 2;
            this.addChangeCommand((DBECommand)new MySQLCommandGrantPrivilege((MySQLUser)this.getDatabaseObject(), grant, withGrantOption, null, null, privilege), (DBECommandReflector)new DBECommandReflector<MySQLUser, MySQLCommandGrantPrivilege>(){

                public void redoCommand(MySQLCommandGrantPrivilege mySQLCommandGrantPrivilege) {
                    if (!MySQLUserEditorGeneral.this.privTable.isDisposed()) {
                        MySQLUserEditorGeneral.this.privTable.checkPrivilege(privilege, grant);
                    }
                }

                public void undoCommand(MySQLCommandGrantPrivilege mySQLCommandGrantPrivilege) {
                    if (!MySQLUserEditorGeneral.this.privTable.isDisposed()) {
                        MySQLUserEditorGeneral.this.privTable.checkPrivilege(privilege, !grant);
                    }
                }
            });
        });
        this.pageControl.createProgressPanel();
        this.commandlistener = new CommandListener();
        DBECommandContext context = this.getEditorInput().getCommandContext();
        if (context != null) {
            context.addCommandListener((DBECommandListener)this.commandlistener);
        }
        if (this.newUser) {
            this.triggerModifyEvent(this.userNameText);
        }
    }

    public void dispose() {
        DBECommandContext commandContext = this.getEditorInput().getCommandContext();
        if (this.commandlistener != null && commandContext != null) {
            commandContext.removeCommandListener((DBECommandListener)this.commandlistener);
        }
        super.dispose();
    }

    public void activatePart() {
        if (this.isLoaded) {
            return;
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext == null) {
            return;
        }
        this.isLoaded = true;
        LoadingJob.createService((ILoadService)new DatabaseLoadService<List<MySQLPrivilege>>(MySQLUIMessages.editors_user_editor_general_service_load_catalog_privileges, executionContext){

            public List<MySQLPrivilege> evaluate(@NotNull DBRProgressMonitor monitor) throws InvocationTargetException {
                MySQLUser user;
                block3: {
                    try {
                        user = (MySQLUser)MySQLUserEditorGeneral.this.getDatabaseObject();
                        if (user != null) break block3;
                        MySQLUserEditorGeneral.this.isLoaded = false;
                        return null;
                    }
                    catch (DBException e) {
                        MySQLUserEditorGeneral.this.isLoaded = false;
                        throw new InvocationTargetException(e);
                    }
                }
                return user.getDataSource().getPrivilegesByKind(monitor, MySQLPrivilege.Kind.ADMIN).stream().filter(p -> !p.getName().equalsIgnoreCase("proxy")).toList();
            }
        }, this.pageControl.createLoadVisualizer()).schedule();
    }

    @Override
    protected PageControl getPageControl() {
        return this.pageControl;
    }

    @Override
    protected void processGrants(List<MySQLGrant> grants) {
        this.privTable.fillGrants(grants);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    private void triggerModifyEvent(Text text) {
        Event event = new Event();
        event.widget = text;
        text.notifyListeners(24, event);
    }

    private class CommandListener
    extends DBECommandAdapter {
        private CommandListener() {
        }

        public void onSave() {
            if (MySQLUserEditorGeneral.this.newUser && ((MySQLUser)MySQLUserEditorGeneral.this.getDatabaseObject()).isPersisted()) {
                MySQLUserEditorGeneral.this.newUser = false;
                UIUtils.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ((CommandListener)CommandListener.this).MySQLUserEditorGeneral.this.userNameText.setEditable(false);
                        ((CommandListener)CommandListener.this).MySQLUserEditorGeneral.this.hostText.setEditable(false);
                    }
                });
            }
        }

        public void onCommandChange(DBECommand<?> command) {
            if (command instanceof MySQLUserManager.CommandRenameUser) {
                MySQLUserManager.CommandRenameUser mysqlCommand = (MySQLUserManager.CommandRenameUser)command;
                this.setUsernameAndHost(mysqlCommand.getNewUserName(), mysqlCommand.getNewHost());
            }
        }

        public void onReset() {
            MySQLUser user = (MySQLUser)MySQLUserEditorGeneral.this.getDatabaseObject();
            this.setUsernameAndHost(user.getUserName(), user.getHost());
        }

        private void setUsernameAndHost(@NotNull String username, @NotNull String host) {
            UIUtils.asyncExec(() -> {
                if (!MySQLUserEditorGeneral.this.privTable.isDisposed()) {
                    MySQLUserEditorGeneral.this.userNameText.setText(username);
                    MySQLUserEditorGeneral.this.hostText.setText(host);
                }
            });
        }
    }

    private class PageControl
    extends MySQLUserEditorAbstract.UserPageControl {
        public PageControl(Composite parent) {
            super(MySQLUserEditorGeneral.this, parent);
        }

        public ProgressPageControl.ProgressVisualizer<List<MySQLPrivilege>> createLoadVisualizer() {
            return new ProgressPageControl.ProgressVisualizer<List<MySQLPrivilege>>((ProgressPageControl)this){

                public void completeLoading(List<MySQLPrivilege> privs) {
                    super.completeLoading(privs);
                    ((PageControl)PageControl.this).MySQLUserEditorGeneral.this.privTable.fillPrivileges(privs);
                    MySQLUserEditorGeneral.this.loadGrants();
                }
            };
        }
    }
}

