/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Set;

public class StreamDecoder {
    private static final int INPUT_BUFFER_SIZE = 8192;
    private final Charset charset;
    private final CharsetDecoder decoder;
    private final ByteBuffer inputBuffer;
    private final CharBuffer outputBuffer;
    private volatile boolean finished;
    Set<String> singlebyteCharsetNames = Set.of("ISO_8859_1", "US_ASCII", "windows-1250", "windows-1251", "windows-1252", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258");

    public StreamDecoder(Charset charset) {
        this.charset = charset;
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPLACE);
        d.onUnmappableCharacter(CodingErrorAction.REPLACE);
        boolean unbuffered = this.singlebyteCharsetNames.contains(charset.name());
        this.decoder = unbuffered ? null : d;
        this.inputBuffer = unbuffered ? null : ByteBuffer.allocate(8192).flip();
        this.outputBuffer = unbuffered ? null : CharBuffer.allocate((int)(8192.0f * d.maxCharsPerByte()));
        this.finished = false;
    }

    private void consume(StringBuilder consumer) {
        this.outputBuffer.flip();
        consumer.append(this.outputBuffer);
        this.outputBuffer.clear();
    }

    private void internalDecode(StringBuilder consumer, byte[] buffer, int offset, int length) {
        assert (offset >= 0);
        assert (length >= 0);
        int position = offset;
        int end = offset + length;
        assert (end <= buffer.length);
        boolean finishedReading = false;
        do {
            CoderResult result;
            if ((result = this.decoder.decode(this.inputBuffer, this.outputBuffer, false)).isOverflow()) {
                this.consume(consumer);
                continue;
            }
            if (result.isUnderflow()) {
                this.inputBuffer.compact();
                int remaining = this.inputBuffer.remaining();
                assert (remaining > 0);
                int read = Math.min(remaining, end - position);
                if (read > 0) {
                    this.inputBuffer.put(buffer, position, read);
                    position += read;
                } else {
                    finishedReading = true;
                }
                this.inputBuffer.flip();
                continue;
            }
            assert (false);
        } while (!finishedReading);
    }

    public String decode(byte[] buffer, int offset, int length) {
        if (this.decoder == null) {
            return new String(buffer, offset, length, this.charset);
        }
        StringBuilder builder = new StringBuilder();
        this.decode(builder, buffer, offset, length);
        return builder.toString();
    }

    private void decode(StringBuilder consumer, byte[] buffer, int offset, int length) {
        this.internalDecode(consumer, buffer, offset, length);
        this.consume(consumer);
    }

    public String finish() {
        if (this.decoder == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.finish(builder);
        return builder.toString();
    }

    private void finish(StringBuilder consumer) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        CoderResult result = this.decoder.decode(this.inputBuffer, this.outputBuffer, true);
        assert (result.isOverflow() || result.isUnderflow());
        do {
            if ((result = this.decoder.flush(this.outputBuffer)).isOverflow()) {
                this.consume(consumer);
                continue;
            }
            assert (result.isUnderflow());
        } while (!result.isUnderflow());
        this.consume(consumer);
    }
}

