/*
    SPDX-FileCopyrightText: 2006, 2008-2009, 2019 Friedrich W. H. Kossebau <kossebau@kde.org>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#include "viewmanager.hpp"
#include "viewmanager_p.hpp"

// Std
#include <utility>

namespace Kasten {

ViewManager::ViewManager()
    : d_ptr(std::make_unique<ViewManagerPrivate>(this))
{
}

ViewManager::~ViewManager() = default;

ModelCodecViewManager* ViewManager::codecViewManager() const
{
    Q_D(const ViewManager);

    return d->codecViewManager();
}

void ViewManager::setViewFactory(std::unique_ptr<AbstractViewFactory>&& factory)
{
    Q_D(ViewManager);

    d->setViewFactory(std::move(factory));
}

QList<AbstractView*> ViewManager::views() const
{
    Q_D(const ViewManager);

    return d->views();
}

AbstractView* ViewManager::viewByWidget(QWidget* widget) const
{
    Q_D(const ViewManager);

    return d->viewByWidget(widget);
}

void ViewManager::createCopyOfView(AbstractView* view, Qt::Alignment alignment)
{
    Q_D(ViewManager);

    d->createCopyOfView(view, alignment);
}

void ViewManager::createViewsFor(const QList<Kasten::AbstractDocument*>& documents)
{
    Q_D(ViewManager);

    d->createViewsFor(documents);
}

void ViewManager::removeViewsFor(const QList<Kasten::AbstractDocument*>& documents)
{
    Q_D(ViewManager);

    d->removeViewsFor(documents);
}

void ViewManager::removeViews(const QList<AbstractView*>& views)
{
    Q_D(ViewManager);

    d->removeViews(views);
}

}

#include "moc_viewmanager.cpp"
