//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgnullwindowid?language=objc)
pub const kCGNullWindowID: CGWindowID = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgwindowid?language=objc)
pub type CGWindowID = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgwindowsharingtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGWindowSharingType(pub u32);
impl CGWindowSharingType {
    #[doc(alias = "kCGWindowSharingNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "kCGWindowSharingReadOnly")]
    pub const ReadOnly: Self = Self(1);
    #[doc(alias = "kCGWindowSharingReadWrite")]
    pub const ReadWrite: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGWindowSharingType {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGWindowSharingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgwindowbackingtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGWindowBackingType(pub u32);
impl CGWindowBackingType {
    #[doc(alias = "kCGBackingStoreRetained")]
    pub const BackingStoreRetained: Self = Self(0);
    #[doc(alias = "kCGBackingStoreNonretained")]
    pub const BackingStoreNonretained: Self = Self(1);
    #[doc(alias = "kCGBackingStoreBuffered")]
    pub const BackingStoreBuffered: Self = Self(2);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGWindowBackingType {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGWindowBackingType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindownumber?language=objc)
    pub static kCGWindowNumber: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowstoretype?language=objc)
    pub static kCGWindowStoreType: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowlayer?language=objc)
    pub static kCGWindowLayer: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowbounds?language=objc)
    pub static kCGWindowBounds: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowsharingstate?language=objc)
    pub static kCGWindowSharingState: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowalpha?language=objc)
    pub static kCGWindowAlpha: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowownerpid?language=objc)
    pub static kCGWindowOwnerPID: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowmemoryusage?language=objc)
    pub static kCGWindowMemoryUsage: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowworkspace?language=objc)
    #[deprecated = "No longer supported"]
    pub static kCGWindowWorkspace: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowownername?language=objc)
    pub static kCGWindowOwnerName: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowname?language=objc)
    pub static kCGWindowName: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowisonscreen?language=objc)
    pub static kCGWindowIsOnscreen: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/kcgwindowbackinglocationvideomemory?language=objc)
    pub static kCGWindowBackingLocationVideoMemory: &'static CFString;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgwindowlistoption?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGWindowListOption(pub u32);
bitflags::bitflags! {
    impl CGWindowListOption: u32 {
        #[doc(alias = "kCGWindowListOptionAll")]
        const OptionAll = 0;
        #[doc(alias = "kCGWindowListOptionOnScreenOnly")]
        const OptionOnScreenOnly = 1<<0;
        #[doc(alias = "kCGWindowListOptionOnScreenAboveWindow")]
        const OptionOnScreenAboveWindow = 1<<1;
        #[doc(alias = "kCGWindowListOptionOnScreenBelowWindow")]
        const OptionOnScreenBelowWindow = 1<<2;
        #[doc(alias = "kCGWindowListOptionIncludingWindow")]
        const OptionIncludingWindow = 1<<3;
        #[doc(alias = "kCGWindowListExcludeDesktopElements")]
        const ExcludeDesktopElements = 1<<4;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGWindowListOption {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGWindowListOption {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[inline]
pub extern "C-unwind" fn CGWindowListCopyWindowInfo(
    option: CGWindowListOption,
    relative_to_window: CGWindowID,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGWindowListCopyWindowInfo(
            option: CGWindowListOption,
            relative_to_window: CGWindowID,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGWindowListCopyWindowInfo(option, relative_to_window) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub extern "C-unwind" fn CGWindowListCreate(
    option: CGWindowListOption,
    relative_to_window: CGWindowID,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGWindowListCreate(
            option: CGWindowListOption,
            relative_to_window: CGWindowID,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGWindowListCreate(option, relative_to_window) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// `window_array` generic must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn CGWindowListCreateDescriptionFromArray(
    window_array: Option<&CFArray>,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CGWindowListCreateDescriptionFromArray(
            window_array: Option<&CFArray>,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CGWindowListCreateDescriptionFromArray(window_array) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgwindowimageoption?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGWindowImageOption(pub u32);
bitflags::bitflags! {
    impl CGWindowImageOption: u32 {
        #[doc(alias = "kCGWindowImageDefault")]
        const Default = 0;
        #[doc(alias = "kCGWindowImageBoundsIgnoreFraming")]
        const BoundsIgnoreFraming = 1<<0;
        #[doc(alias = "kCGWindowImageShouldBeOpaque")]
        const ShouldBeOpaque = 1<<1;
        #[doc(alias = "kCGWindowImageOnlyShadows")]
        const OnlyShadows = 1<<2;
        #[doc(alias = "kCGWindowImageBestResolution")]
        const BestResolution = 1<<3;
        #[doc(alias = "kCGWindowImageNominalResolution")]
        const NominalResolution = 1<<4;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGWindowImageOption {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGWindowImageOption {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "CGImage")]
#[deprecated = "Please use ScreenCaptureKit instead."]
#[inline]
pub extern "C-unwind" fn CGWindowListCreateImage(
    screen_bounds: CGRect,
    list_option: CGWindowListOption,
    window_id: CGWindowID,
    image_option: CGWindowImageOption,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGWindowListCreateImage(
            screen_bounds: CGRect,
            list_option: CGWindowListOption,
            window_id: CGWindowID,
            image_option: CGWindowImageOption,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret =
        unsafe { CGWindowListCreateImage(screen_bounds, list_option, window_id, image_option) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// # Safety
///
/// `window_array` generic must be of the correct type.
#[cfg(feature = "CGImage")]
#[deprecated = "Please use ScreenCaptureKit instead."]
#[inline]
pub unsafe extern "C-unwind" fn CGWindowListCreateImageFromArray(
    screen_bounds: CGRect,
    window_array: &CFArray,
    image_option: CGWindowImageOption,
) -> Option<CFRetained<CGImage>> {
    extern "C-unwind" {
        fn CGWindowListCreateImageFromArray(
            screen_bounds: CGRect,
            window_array: &CFArray,
            image_option: CGWindowImageOption,
        ) -> Option<NonNull<CGImage>>;
    }
    let ret =
        unsafe { CGWindowListCreateImageFromArray(screen_bounds, window_array, image_option) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub extern "C-unwind" fn CGPreflightScreenCaptureAccess() -> bool {
    extern "C-unwind" {
        fn CGPreflightScreenCaptureAccess() -> bool;
    }
    unsafe { CGPreflightScreenCaptureAccess() }
}

#[inline]
pub extern "C-unwind" fn CGRequestScreenCaptureAccess() -> bool {
    extern "C-unwind" {
        fn CGRequestScreenCaptureAccess() -> bool;
    }
    unsafe { CGRequestScreenCaptureAccess() }
}
