/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_cv extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_generic_AmPmMarkers = new String[] {
            "к. у.",
            "к. х.",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
        };
        final String metaValue_generic_DateFormatItem_yyyyMMMd = "G y, MMM, d";
        final String metaValue_generic_DateFormatItem_yyyyMEd = "G y.MM.dd (E)";
        final String metaValue_generic_DateFormatItem_yyyyMd = "G y.MM.dd";
        final String metaValue_generic_DateFormatItem_yyyyMMMEd = "G y, MMM, d, E";
        final String metaValue_generic_DateFormatItem_yyyyM = "G y.MM";
        final String metaValue_generic_DateFormatItem_yyyyMMM = "G y, MMM";
        final String[] metaValue_MonthNames = new String[] {
            "кӑрлач",
            "нарӑс",
            "пуш",
            "ака",
            "ҫу",
            "ҫӗртме",
            "утӑ",
            "ҫурла",
            "авӑн",
            "юпа",
            "чӳк",
            "раштав",
            "",
        };
        final String[] metaValue_MonthAbbreviations = new String[] {
            "кӑр.",
            "нар.",
            "пуш",
            "ака",
            "ҫу",
            "ҫӗрт.",
            "утӑ",
            "ҫур.",
            "авӑн",
            "юпа",
            "чӳк",
            "раш.",
            "",
        };
        final String[] metaValue_MonthNarrows = new String[] {
            "К",
            "Н",
            "П",
            "А",
            "Ҫ",
            "Ҫ",
            "У",
            "Ҫ",
            "А",
            "Ю",
            "Ч",
            "Р",
            "",
        };
        final String[] metaValue_generic_DayNames = new String[] {
            "вырсарни кун",
            "тунти кун",
            "ытлари кун",
            "юн кун",
            "кӗҫнерни кун",
            "эрне кун",
            "шӑмат кун",
        };
        final String[] metaValue_generic_DayAbbreviations = new String[] {
            "вр",
            "тн",
            "ыт",
            "юн",
            "кҫ",
            "эр",
            "шм",
        };
        final String[] metaValue_generic_DayNarrows = new String[] {
            "В",
            "Т",
            "Ы",
            "Ю",
            "К",
            "Э",
            "Ш",
        };
        final String[] metaValue_generic_QuarterNames = new String[] {
            "1-мӗш чӗрӗк",
            "2-мӗш чӗрӗк",
            "3-мӗш чӗрӗк",
            "4-мӗш чӗрӗк",
        };
        final String[] metaValue_generic_QuarterAbbreviations = new String[] {
            "1-мӗш чӗр.",
            "2-мӗш чӗр.",
            "3-мӗш чӗр.",
            "4-мӗш чӗр.",
        };
        final String[] metaValue_java_time_long_Eras = new String[] {
            "хальхи саманачченхи",
            "хальхи саманари",
        };
        final String[] metaValue_java_time_Eras = new String[] {
            "х. с-ч.",
            "х. с.",
        };
        final String[] metaValue_generic_TimePatterns = new String[] {
            "HH:mm:ss (zzzz)",
            "HH:mm:ss (z)",
            "HH:mm:ss",
            "HH:mm",
        };
        final String[] metaValue_generic_DateTimePatterns = new String[] {
            "{1}, {0}",
            "{1}, {0}",
            "{1}, {0}",
            "{1}, {0}",
        };
        final String metaValue_generic_DateFormatItem_hm = "a h:mm";
        final String metaValue_generic_DateFormatItem_yMMMEd = "y, MMM, d, E";
        final String metaValue_generic_DateFormatItem_Ehms = "E, a h:mm:ss";
        final String metaValue_generic_DateFormatItem_Ehm = "E, a h:mm";
        final String metaValue_generic_DateFormatItem_yMEd = "y.MM.dd (ccc)";
        final String metaValue_generic_DateFormatItem_hv = "a h (v)";
        final String metaValue_generic_DateFormatItem_hms = "a h:mm:ss";
        final String metaValue_generic_DateFormatItem_hmv = "a h:mm (v)";
        final String metaValue_generic_DateFormatItem_Bhms = "B h:mm:ss";
        final String metaValue_generic_DateFormatItem_hmsv = "a h:mm:ss (v)";
        final String metaValue_generic_DateFormatItem_yMMMd = "y, MMM, d";
        final String metaValue_generic_DateFormatItem_yw = "Y, w-'мӗш' 'эрне'";
        final String metaValue_generic_DateFormatItem_yQQQ = "y, QQQ";
        final String metaValue_generic_DateFormatItem_EHms = "E, HH:mm:ss";
        final String metaValue_generic_DateFormatItem_EHm = "E, HH:mm";
        final String metaValue_generic_DateFormatItem_yMMM = "y, MMM";
        final String metaValue_generic_DateFormatItem_Hv = "HH 'сех' (v)";
        final String metaValue_generic_DateFormatItem_Md = "MM.dd";
        final String metaValue_generic_DateFormatItem_EBhms = "ccc, B h:mm:ss";
        final String metaValue_generic_DateFormatItem_Ed = "d, ccc";
        final String metaValue_generic_DateFormatItem_EBhm = "ccc, B h:mm";
        final String metaValue_generic_DateFormatItem_Eh = "E, a h";
        final String metaValue_generic_DateFormatItem_MMMMd = "MMMM, d";
        final String metaValue_generic_DateFormatItem_Bhm = "B h:mm";
        final String metaValue_generic_DateFormatItem_H = "HH 'сех'";
        final String metaValue_generic_DateFormatItem_MEd = "MM.dd (E)";
        final String metaValue_generic_DateFormatItem_MMMEd = "MMM, d, E";
        final String metaValue_generic_DateFormatItem_Bh = "B h";
        final String metaValue_generic_DateFormatItem_h = "a h";
        final String metaValue_generic_DateFormatItem_EBh = "E, B h";
        final String metaValue_generic_DateFormatItem_Hmsv = "HH:mm:ss (v)";
        final String metaValue_generic_DateFormatItem_Hmv = "HH:mm (v)";
        final String metaValue_generic_DateFormatItem_yMd = "y.MM.dd";
        final String metaValue_generic_DateFormatItem_MMMd = "MMM, d";
        final String metaValue_generic_DateFormatItem_yM = "y.MM";
        final String metaValue_generic_DateFormatItem_yMMMM = "y, MMMM";
        final String metaValue_generic_DateFormatItem_MMMMW = "MMMM, W-'мӗш' 'эрне'";
        final String metaValue_generic_DateFormatItem_yQQQQ = "y, QQQQ";
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
            "BC",
            "буддизм саманири",
        };
        final String[] metaValue_java_time_buddhist_Eras = new String[] {
            "BC",
            "б. с.",
        };
        final String metaValue_generic_DateFormatItem_yyyyMMMM = "G y, MMMM";
        final String metaValue_generic_DateFormatItem_yyyyQQQQ = "G y, QQQQ";
        final String metaValue_generic_DateFormatItem_yyyyQQQ = "G y, QQQ";
        final String metaValue_buddhist_DateFormatItem_Gy = "G y";
        final String[] metaValue_java_time_japanese_long_Eras = new String[] {
            "хальхи саманари",
            "Мэйдзи",
            "Тайсё",
            "Сёва",
            "Хэйсэй",
            "Рэйва",
        };
        final String[] metaValue_java_time_japanese_Eras = new String[] {
            "х. с.",
            "Мэйдзи",
            "Тайсё",
            "Сёва",
            "Хэйсэй",
            "Рэйва",
        };
        final String metaValue_japanese_DateFormatItem_Gy = "G, y";
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
            "Китай Республики йӗркеличченхи",
            "Китай Республики йӗркеленӗрен",
        };
        final String[] metaValue_java_time_roc_Eras = new String[] {
            "респ. й-ч.",
            "респ. й-р.",
        };
        final String[] metaValue_java_time_roc_narrow_Eras = new String[] {
            "р. й-ч.",
            "р. й-р.",
        };
        final String[] metaValue_java_time_generic_DatePatterns = new String[] {
            "G y, MMMM, d, EEEE",
            "G y, MMMM, d",
            "G y, MMM, d",
            "GGGGG y.MM.dd",
        };
        final String[] metaValue_generic_DatePatterns = new String[] {
            "GGGG y, MMMM, d, EEEE",
            "GGGG y, MMMM, d",
            "GGGG y, MMM, d",
            "G y.MM.dd",
        };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
            "",
            "хиджра хыҫҫӑнхи",
        };
        final String[] metaValue_java_time_islamic_Eras = new String[] {
            "",
            "х. х.",
        };
        final String metaValue_calendarname_gregorian = "грегориан календарӗ";
        final String[] metaValue_adlm_NumberElements = new String[] {
            ".",
            ",",
            ";",
            "%",
            "0",
            "#",
            "-",
            "E",
            "‰",
            "∞",
            "хисеп мар",
            "",
            "",
            "-－﹣‐‑‒–−⁻₋➖",
        };
        final String[] metaValue_adlm_NumberPatterns = new String[] {
            "#,##0.###",
            "¤ #,##0.00",
            "#,##0%",
            "#,##0.00 ¤;(#,##0.00 ¤)",
        };
        final String[] metaValue_arab_NumberPatterns = new String[] {
            "#,##0.###",
            "#,##0.00 ¤",
            "#,##0 %",
            "#,##0.00 ¤;(#,##0.00 ¤)",
        };
        final String[] metaValue_ListPatterns_standard = new String[] {
            "",
            "",
            "{0} тата {1}",
            "{0} тата {1}",
            "",
        };
        final String[] metaValue_ListPatterns_or = new String[] {
            "",
            "",
            "{0} е {1}",
            "{0} е {1}",
            "",
        };
        final Object[][] data = new Object[][] {
            { "generic.DayNames", metaValue_generic_DayNames },
            { "generic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "generic.DayNarrows", metaValue_generic_DayNarrows },
            { "generic.QuarterNames", metaValue_generic_QuarterNames },
            { "generic.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "generic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.narrow.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "generic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.generic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "generic.DatePatterns", metaValue_generic_DatePatterns },
            { "generic.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "generic.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "generic.DateFormatItem.yyyyMMMM", metaValue_generic_DateFormatItem_yyyyMMMM },
            { "generic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "generic.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "generic.DateFormatItem.yyyyQQQQ", metaValue_generic_DateFormatItem_yyyyQQQQ },
            { "generic.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "generic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "generic.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "generic.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "generic.DateFormatItem.yyyyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "generic.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "generic.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "generic.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "generic.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "generic.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "generic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "generic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "generic.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "generic.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "generic.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "generic.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "generic.DateFormatItem.yyyyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "generic.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "generic.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "generic.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "generic.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "generic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "generic.DateFormatItem.yyyyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "generic.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "generic.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "generic.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "generic.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "generic.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "generic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "generic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "generic.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "generic.DateFormatItem.yyyyQQQ", metaValue_generic_DateFormatItem_yyyyQQQ },
            { "generic.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "generic.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "generic.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "generic.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "generic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "generic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "generic.DateFormatItem.yyyyM", metaValue_generic_DateFormatItem_yyyyM },
            { "generic.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "generic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "generic.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "generic.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "generic.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "generic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "generic.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "generic.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "generic.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "MonthNames", metaValue_MonthNames },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "DayNames", metaValue_generic_DayNames },
            { "standalone.DayNames", metaValue_generic_DayNames },
            { "DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "standalone.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "DayNarrows", metaValue_generic_DayNarrows },
            { "standalone.DayNarrows", metaValue_generic_DayNarrows },
            { "QuarterNames", metaValue_generic_QuarterNames },
            { "standalone.QuarterNames", metaValue_generic_QuarterNames },
            { "QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "standalone.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "narrow.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "java.time.long.Eras", metaValue_java_time_long_Eras },
            { "long.Eras", metaValue_java_time_long_Eras },
            { "java.time.Eras", metaValue_java_time_Eras },
            { "Eras", metaValue_java_time_Eras },
            { "java.time.narrow.Eras", metaValue_java_time_Eras },
            { "narrow.Eras", metaValue_java_time_Eras },
            { "field.era", "самана" },
            { "field.year", "ҫул" },
            { "field.month", "уйӑх" },
            { "field.week", "эрне" },
            { "field.weekday", "эрнен кунӗ" },
            { "field.dayperiod", "к. у./к. х." },
            { "field.hour", "сехет" },
            { "timezone.regionFormat", "{0} вӑхӑчӗ" },
            { "timezone.regionFormat.daylight", "{0} ҫуллахи вӑхӑчӗ" },
            { "timezone.regionFormat.standard", "{0} стандартлӑ вӑхӑчӗ" },
            { "field.minute", "минут" },
            { "field.second", "ҫеккунт" },
            { "field.zone", "вӑхӑт тӑрӑхӗ" },
            { "TimePatterns", metaValue_generic_TimePatterns },
            { "DatePatterns",
                new String[] {
                    "y, MMMM, d, EEEE",
                    "y, MMMM, d",
                    "y, MMM, d",
                    "y.MM.dd",
                }
            },
            { "DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "PluralRules", "zero:n = 0;one:n = 1" },
            { "DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.DayNames", metaValue_generic_DayNames },
            { "buddhist.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "buddhist.QuarterNames", metaValue_generic_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "buddhist.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "buddhist.narrow.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.Eras", metaValue_java_time_buddhist_Eras },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_Eras },
            { "buddhist.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.buddhist.DatePatterns",
                new String[] {
                    "G y, MMMM, d, EEEE",
                    "G y, MMMM, d",
                    "G y, MMM, d",
                    "G y.MM.dd",
                }
            },
            { "buddhist.DatePatterns",
                new String[] {
                    "GGGG y, MMMM, d, EEEE",
                    "GGGG y, MMMM, d",
                    "GGGG y, MMM, d",
                    "GGGG y.MM.dd",
                }
            },
            { "buddhist.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "buddhist.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "buddhist.DateFormatItem.yyyyMMMM", metaValue_generic_DateFormatItem_yyyyMMMM },
            { "buddhist.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "buddhist.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "buddhist.DateFormatItem.yyyyQQQQ", metaValue_generic_DateFormatItem_yyyyQQQQ },
            { "buddhist.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "buddhist.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "buddhist.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "buddhist.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "buddhist.DateFormatItem.yyyyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "buddhist.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "buddhist.DateFormatItem.Gy", metaValue_buddhist_DateFormatItem_Gy },
            { "buddhist.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "buddhist.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "buddhist.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "buddhist.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "buddhist.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "buddhist.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "buddhist.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "buddhist.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "buddhist.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "buddhist.DateFormatItem.yyyyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "buddhist.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "buddhist.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "buddhist.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "buddhist.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "buddhist.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "buddhist.DateFormatItem.yyyyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "buddhist.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "buddhist.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "buddhist.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "buddhist.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "buddhist.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "buddhist.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "buddhist.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "buddhist.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "buddhist.DateFormatItem.yyyyQQQ", metaValue_generic_DateFormatItem_yyyyQQQ },
            { "buddhist.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "buddhist.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "buddhist.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "buddhist.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "buddhist.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "buddhist.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "buddhist.DateFormatItem.yyyyM", metaValue_generic_DateFormatItem_yyyyM },
            { "buddhist.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "buddhist.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "buddhist.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "buddhist.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "buddhist.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "buddhist.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "buddhist.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "buddhist.DateFormatItem.yyyy", metaValue_buddhist_DateFormatItem_Gy },
            { "buddhist.DateFormatItem.y", metaValue_buddhist_DateFormatItem_Gy },
            { "buddhist.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "buddhist.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "japanese.DayNames", metaValue_generic_DayNames },
            { "japanese.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "japanese.QuarterNames", metaValue_generic_QuarterNames },
            { "japanese.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "japanese.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "japanese.narrow.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "japanese.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "java.time.japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "japanese.long.Eras", metaValue_java_time_japanese_long_Eras },
            { "java.time.japanese.Eras", metaValue_java_time_japanese_Eras },
            { "japanese.Eras", metaValue_java_time_japanese_Eras },
            { "java.time.japanese.narrow.Eras", metaValue_java_time_japanese_Eras },
            { "japanese.narrow.Eras", metaValue_java_time_japanese_Eras },
            { "japanese.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.japanese.DatePatterns",
                new String[] {
                    "G, y, MMMM, d, EEEE",
                    "G, y, MMMM, d",
                    "G, y, MMM, d",
                    "GGGGG, y.MM.dd",
                }
            },
            { "japanese.DatePatterns",
                new String[] {
                    "GGGG, yyyy, MMMM, d, EEEE",
                    "GGGG, yyyy, MMMM, d",
                    "GGGG, y, MMM, d",
                    "G, y.MM.dd",
                }
            },
            { "japanese.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "japanese.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "japanese.DateFormatItem.yyyyMMMM", "G, y, MMMM" },
            { "japanese.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "japanese.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "japanese.DateFormatItem.yyyyQQQQ", "G, y, QQQQ" },
            { "japanese.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "japanese.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "japanese.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "japanese.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "japanese.DateFormatItem.yyyyMMMd", "G, y, MMM, d" },
            { "japanese.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "japanese.DateFormatItem.Gy", metaValue_japanese_DateFormatItem_Gy },
            { "japanese.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "japanese.DateFormatItem.yyyyMMMEd", "G, y, MMM, d, E" },
            { "japanese.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "japanese.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "japanese.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "japanese.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "japanese.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "japanese.DateFormatItem.yyyyMEd", "G, y.MM.dd (E)" },
            { "japanese.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "japanese.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "japanese.DateFormatItem.yyyyMd", "G, y.MM.dd" },
            { "japanese.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "japanese.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "japanese.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "japanese.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "japanese.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "japanese.DateFormatItem.yyyyMMM", "G, y, MMM" },
            { "japanese.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "japanese.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "japanese.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "japanese.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "japanese.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "japanese.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "japanese.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "japanese.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "japanese.DateFormatItem.yyyyQQQ", "G, y, QQQ" },
            { "japanese.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "japanese.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "japanese.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "japanese.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "japanese.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "japanese.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "japanese.DateFormatItem.yyyyM", "G, y.MM" },
            { "japanese.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "japanese.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "japanese.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "japanese.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "japanese.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "japanese.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "japanese.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "japanese.DateFormatItem.yyyy", metaValue_japanese_DateFormatItem_Gy },
            { "japanese.DateFormatItem.y", metaValue_japanese_DateFormatItem_Gy },
            { "japanese.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "japanese.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "roc.MonthNames", metaValue_MonthNames },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "roc.DayNames", metaValue_generic_DayNames },
            { "roc.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "roc.DayNarrows", metaValue_generic_DayNarrows },
            { "roc.QuarterNames", metaValue_generic_QuarterNames },
            { "roc.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "roc.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "roc.narrow.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "roc.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "java.time.roc.Eras", metaValue_java_time_roc_Eras },
            { "roc.Eras", metaValue_java_time_roc_Eras },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_narrow_Eras },
            { "roc.narrow.Eras", metaValue_java_time_roc_narrow_Eras },
            { "roc.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.roc.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "roc.DatePatterns", metaValue_generic_DatePatterns },
            { "roc.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "roc.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "roc.DateFormatItem.yyyyMMMM", metaValue_generic_DateFormatItem_yyyyMMMM },
            { "roc.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "roc.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "roc.DateFormatItem.yyyyQQQQ", metaValue_generic_DateFormatItem_yyyyQQQQ },
            { "roc.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "roc.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "roc.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "roc.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "roc.DateFormatItem.yyyyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "roc.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "roc.DateFormatItem.Gy", metaValue_buddhist_DateFormatItem_Gy },
            { "roc.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "roc.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "roc.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "roc.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "roc.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "roc.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "roc.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "roc.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "roc.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "roc.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "roc.DateFormatItem.yyyyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "roc.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "roc.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "roc.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "roc.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "roc.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "roc.DateFormatItem.yyyyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "roc.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "roc.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "roc.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "roc.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "roc.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "roc.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "roc.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "roc.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "roc.DateFormatItem.yyyyQQQ", metaValue_generic_DateFormatItem_yyyyQQQ },
            { "roc.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "roc.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "roc.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "roc.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "roc.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "roc.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "roc.DateFormatItem.yyyyM", metaValue_generic_DateFormatItem_yyyyM },
            { "roc.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "roc.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "roc.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "roc.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "roc.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "roc.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "roc.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "roc.DateFormatItem.yyyy", metaValue_buddhist_DateFormatItem_Gy },
            { "roc.DateFormatItem.y", metaValue_buddhist_DateFormatItem_Gy },
            { "roc.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "roc.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic.MonthNames",
                new String[] {
                    "мухаррам",
                    "сафар",
                    "раби-уль-авваль",
                    "раби-уль-ахир",
                    "джумад-уль-авваль",
                    "джумад-уль-ахир",
                    "раджаб",
                    "шаабан",
                    "рамадан",
                    "шавваль",
                    "зуль-каада",
                    "зуль-хиджжа",
                    "",
                }
            },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "мух.",
                    "саф.",
                    "раб. I",
                    "раб. II",
                    "джум. I",
                    "джум. II",
                    "радж.",
                    "шааб.",
                    "рам.",
                    "шав.",
                    "зуль-к.",
                    "зуль-х.",
                    "",
                }
            },
            { "islamic.DayNames", metaValue_generic_DayNames },
            { "islamic.DayAbbreviations", metaValue_generic_DayAbbreviations },
            { "islamic.QuarterNames", metaValue_generic_QuarterNames },
            { "islamic.QuarterAbbreviations", metaValue_generic_QuarterAbbreviations },
            { "islamic.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "islamic.narrow.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "islamic.abbreviated.AmPmMarkers", metaValue_generic_AmPmMarkers },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_Eras },
            { "islamic.Eras", metaValue_java_time_islamic_Eras },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_Eras },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_Eras },
            { "islamic.TimePatterns", metaValue_generic_TimePatterns },
            { "java.time.islamic.DatePatterns", metaValue_java_time_generic_DatePatterns },
            { "islamic.DatePatterns", metaValue_generic_DatePatterns },
            { "islamic.DateTimePatterns", metaValue_generic_DateTimePatterns },
            { "islamic.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "islamic.DateFormatItem.yyyyMMMM", metaValue_generic_DateFormatItem_yyyyMMMM },
            { "islamic.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "islamic.DateFormatItem.yyyyQQQQ", metaValue_generic_DateFormatItem_yyyyQQQQ },
            { "islamic.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "islamic.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "islamic.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "islamic.DateFormatItem.yyyyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "islamic.DateFormatItem.Gy", metaValue_buddhist_DateFormatItem_Gy },
            { "islamic.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "islamic.DateFormatItem.yyyyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "islamic.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic.DateFormatItem.yyyyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "islamic.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "islamic.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "islamic.DateFormatItem.yyyyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "islamic.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "islamic.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic.DateFormatItem.yyyyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "islamic.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "islamic.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "islamic.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "islamic.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "islamic.DateFormatItem.yyyyQQQ", metaValue_generic_DateFormatItem_yyyyQQQ },
            { "islamic.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "islamic.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "islamic.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "islamic.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "islamic.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic.DateFormatItem.yyyyM", metaValue_generic_DateFormatItem_yyyyM },
            { "islamic.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "islamic.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "islamic.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "islamic.DateFormatItem.yyyy", metaValue_buddhist_DateFormatItem_Gy },
            { "islamic.DateFormatItem.y", metaValue_buddhist_DateFormatItem_Gy },
            { "islamic.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "islamic.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic-civil.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "islamic-civil.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-civil.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "islamic-civil.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "islamic-civil.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-civil.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "islamic-civil.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "islamic-civil.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "islamic-civil.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "islamic-civil.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "islamic-civil.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic-civil.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-civil.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-civil.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic-civil.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "islamic-civil.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "islamic-civil.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic-civil.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "islamic-civil.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-civil.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "islamic-civil.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-civil.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "islamic-civil.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "islamic-civil.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic-civil.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "islamic-civil.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "islamic-civil.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-civil.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic-civil.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "islamic-civil.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "islamic-civil.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "islamic-civil.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "islamic-civil.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "islamic-civil.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic-civil.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-civil.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "islamic-civil.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-civil.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-civil.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "islamic-civil.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic-civil.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-civil.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "islamic-civil.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "islamic-civil.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "islamic-umalqura.DateFormatItem.hm", metaValue_generic_DateFormatItem_hm },
            { "islamic-umalqura.DateFormatItem.yMMMEd", metaValue_generic_DateFormatItem_yMMMEd },
            { "islamic-umalqura.DateFormatItem.Ehms", metaValue_generic_DateFormatItem_Ehms },
            { "islamic-umalqura.DateFormatItem.Ehm", metaValue_generic_DateFormatItem_Ehm },
            { "islamic-umalqura.DateFormatItem.yMEd", metaValue_generic_DateFormatItem_yMEd },
            { "islamic-umalqura.DateFormatItem.hv", metaValue_generic_DateFormatItem_hv },
            { "islamic-umalqura.DateFormatItem.hms", metaValue_generic_DateFormatItem_hms },
            { "islamic-umalqura.DateFormatItem.hmv", metaValue_generic_DateFormatItem_hmv },
            { "islamic-umalqura.DateFormatItem.Bhms", metaValue_generic_DateFormatItem_Bhms },
            { "islamic-umalqura.DateFormatItem.hmsv", metaValue_generic_DateFormatItem_hmsv },
            { "islamic-umalqura.DateFormatItem.GyMMMd", metaValue_generic_DateFormatItem_yyyyMMMd },
            { "islamic-umalqura.DateFormatItem.yMMMd", metaValue_generic_DateFormatItem_yMMMd },
            { "islamic-umalqura.DateFormatItem.yw", metaValue_generic_DateFormatItem_yw },
            { "islamic-umalqura.DateFormatItem.yQQQ", metaValue_generic_DateFormatItem_yQQQ },
            { "islamic-umalqura.DateFormatItem.EHms", metaValue_generic_DateFormatItem_EHms },
            { "islamic-umalqura.DateFormatItem.EHm", metaValue_generic_DateFormatItem_EHm },
            { "islamic-umalqura.DateFormatItem.yMMM", metaValue_generic_DateFormatItem_yMMM },
            { "islamic-umalqura.DateFormatItem.Hv", metaValue_generic_DateFormatItem_Hv },
            { "islamic-umalqura.DateFormatItem.Md", metaValue_generic_DateFormatItem_Md },
            { "islamic-umalqura.DateFormatItem.EBhms", metaValue_generic_DateFormatItem_EBhms },
            { "islamic-umalqura.DateFormatItem.Ed", metaValue_generic_DateFormatItem_Ed },
            { "islamic-umalqura.DateFormatItem.EBhm", metaValue_generic_DateFormatItem_EBhm },
            { "islamic-umalqura.DateFormatItem.Eh", metaValue_generic_DateFormatItem_Eh },
            { "islamic-umalqura.DateFormatItem.MMMMd", metaValue_generic_DateFormatItem_MMMMd },
            { "islamic-umalqura.DateFormatItem.Bhm", metaValue_generic_DateFormatItem_Bhm },
            { "islamic-umalqura.DateFormatItem.H", metaValue_generic_DateFormatItem_H },
            { "islamic-umalqura.DateFormatItem.MEd", metaValue_generic_DateFormatItem_MEd },
            { "islamic-umalqura.DateFormatItem.MMMEd", metaValue_generic_DateFormatItem_MMMEd },
            { "islamic-umalqura.DateFormatItem.GyMEd", metaValue_generic_DateFormatItem_yyyyMEd },
            { "islamic-umalqura.DateFormatItem.Bh", metaValue_generic_DateFormatItem_Bh },
            { "islamic-umalqura.DateFormatItem.h", metaValue_generic_DateFormatItem_h },
            { "islamic-umalqura.DateFormatItem.EBh", metaValue_generic_DateFormatItem_EBh },
            { "islamic-umalqura.DateFormatItem.Hmsv", metaValue_generic_DateFormatItem_Hmsv },
            { "islamic-umalqura.DateFormatItem.GyMd", metaValue_generic_DateFormatItem_yyyyMd },
            { "islamic-umalqura.DateFormatItem.GyMMMEd", metaValue_generic_DateFormatItem_yyyyMMMEd },
            { "islamic-umalqura.DateFormatItem.Hmv", metaValue_generic_DateFormatItem_Hmv },
            { "islamic-umalqura.DateFormatItem.yMd", metaValue_generic_DateFormatItem_yMd },
            { "islamic-umalqura.DateFormatItem.MMMd", metaValue_generic_DateFormatItem_MMMd },
            { "islamic-umalqura.DateFormatItem.yM", metaValue_generic_DateFormatItem_yM },
            { "islamic-umalqura.DateFormatItem.yMMMM", metaValue_generic_DateFormatItem_yMMMM },
            { "islamic-umalqura.DateFormatItem.MMMMW", metaValue_generic_DateFormatItem_MMMMW },
            { "islamic-umalqura.DateFormatItem.yQQQQ", metaValue_generic_DateFormatItem_yQQQQ },
            { "islamic-umalqura.DateFormatItem.GyM", metaValue_generic_DateFormatItem_yyyyM },
            { "islamic-umalqura.DateFormatItem.GyMMM", metaValue_generic_DateFormatItem_yyyyMMM },
            { "calendarname.islamic-civil", "хиджра календарӗ (таблицӑллӑ, граждан)" },
            { "calendarname.buddhist", "буддистсен календарӗ" },
            { "calendarname.japanese", "япон календарӗ" },
            { "calendarname.roc", "Миньго календарӗ" },
            { "calendarname.islamic-umalqura", "хиджра календарӗ (Умм аль-Кура)" },
            { "calendarname.islamic", "хиджра календарӗ" },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
            { "adlm.NumberElements", metaValue_adlm_NumberElements },
            { "adlm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "ahom.NumberElements", metaValue_adlm_NumberElements },
            { "ahom.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "arab.NumberElements",
                new String[] {
                    "٫",
                    "٬",
                    "؛",
                    "٪؜",
                    "٠",
                    "#",
                    "؜-",
                    "اس",
                    "؉",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "arab.NumberPatterns", metaValue_arab_NumberPatterns },
            { "arabext.NumberElements",
                new String[] {
                    "٫",
                    "٬",
                    "؛",
                    "٪",
                    "۰",
                    "#",
                    "‎-‎",
                    "×۱۰^",
                    "؉",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "arabext.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "bali.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᭐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "bali.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "beng.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "০",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "beng.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "bhks.NumberElements", metaValue_adlm_NumberElements },
            { "bhks.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "brah.NumberElements", metaValue_adlm_NumberElements },
            { "brah.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "cakm.NumberElements", metaValue_adlm_NumberElements },
            { "cakm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "cham.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꩐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "cham.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "deva.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "०",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "deva.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "diak.NumberElements", metaValue_adlm_NumberElements },
            { "diak.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "fullwide.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "０",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "fullwide.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gara.NumberElements", metaValue_adlm_NumberElements },
            { "gara.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gong.NumberElements", metaValue_adlm_NumberElements },
            { "gong.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gonm.NumberElements", metaValue_adlm_NumberElements },
            { "gonm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gujr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "૦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "gujr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "gukh.NumberElements", metaValue_adlm_NumberElements },
            { "gukh.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "guru.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "੦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "guru.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "hmng.NumberElements", metaValue_adlm_NumberElements },
            { "hmng.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "hmnp.NumberElements", metaValue_adlm_NumberElements },
            { "hmnp.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "java.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꧐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "java.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "kali.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꤀",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "kali.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "kawi.NumberElements", metaValue_adlm_NumberElements },
            { "kawi.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "khmr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "០",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "khmr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "knda.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "೦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "knda.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "krai.NumberElements", metaValue_adlm_NumberElements },
            { "krai.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "lana.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᪀",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "lana.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "lanatham.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᪐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "lanatham.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "laoo.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "໐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "laoo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "latn.NumberElements",
                new String[] {
                    ",",
                    " ",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "latn.NumberPatterns", metaValue_arab_NumberPatterns },
            { "lepc.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᱀",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "lepc.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "limb.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᥆",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "limb.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mathbold.NumberElements", metaValue_adlm_NumberElements },
            { "mathbold.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mathdbl.NumberElements", metaValue_adlm_NumberElements },
            { "mathdbl.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mathmono.NumberElements", metaValue_adlm_NumberElements },
            { "mathmono.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mathsanb.NumberElements", metaValue_adlm_NumberElements },
            { "mathsanb.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mathsans.NumberElements", metaValue_adlm_NumberElements },
            { "mathsans.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mlym.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "൦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "mlym.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "modi.NumberElements", metaValue_adlm_NumberElements },
            { "modi.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mong.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᠐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "mong.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mroo.NumberElements", metaValue_adlm_NumberElements },
            { "mroo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mtei.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꯰",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "mtei.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "၀",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "mymr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymrepka.NumberElements", metaValue_adlm_NumberElements },
            { "mymrepka.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymrpao.NumberElements", metaValue_adlm_NumberElements },
            { "mymrpao.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymrshan.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "႐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "mymrshan.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymrtlng.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꧰",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "mymrtlng.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "nagm.NumberElements", metaValue_adlm_NumberElements },
            { "nagm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "newa.NumberElements", metaValue_adlm_NumberElements },
            { "newa.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "nkoo.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "߀",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "nkoo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "olck.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᱐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "olck.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "onao.NumberElements", metaValue_adlm_NumberElements },
            { "onao.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "orya.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "୦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "orya.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "osma.NumberElements", metaValue_adlm_NumberElements },
            { "osma.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "outlined.NumberElements", metaValue_adlm_NumberElements },
            { "outlined.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "rohg.NumberElements", metaValue_adlm_NumberElements },
            { "rohg.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "saur.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꣐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "saur.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "segment.NumberElements", metaValue_adlm_NumberElements },
            { "segment.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "shrd.NumberElements", metaValue_adlm_NumberElements },
            { "shrd.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sind.NumberElements", metaValue_adlm_NumberElements },
            { "sind.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sinh.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "෦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "sinh.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sora.NumberElements", metaValue_adlm_NumberElements },
            { "sora.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sund.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᮰",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "sund.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "sunu.NumberElements", metaValue_adlm_NumberElements },
            { "sunu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "takr.NumberElements", metaValue_adlm_NumberElements },
            { "takr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "talu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "᧐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "talu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tamldec.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "௦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "tamldec.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "telu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "౦",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "telu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "thai.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "๐",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "thai.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tibt.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "༠",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "tibt.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tirh.NumberElements", metaValue_adlm_NumberElements },
            { "tirh.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tnsa.NumberElements", metaValue_adlm_NumberElements },
            { "tnsa.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tols.NumberElements", metaValue_adlm_NumberElements },
            { "tols.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "vaii.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "꘠",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "хисеп мар",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "vaii.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "wara.NumberElements", metaValue_adlm_NumberElements },
            { "wara.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "wcho.NumberElements", metaValue_adlm_NumberElements },
            { "wcho.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "hanidec.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "‰",
                    "∞",
                    "NaN",
                    "",
                    "",
                    "-－﹣‐‑‒–−⁻₋➖",
                }
            },
            { "hanidec.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0 пин other:0 пин}",
                    "{one:00 пин other:00 пин}",
                    "{one:000 пин other:000 пин}",
                    "{one:0 млн other:0 млн}",
                    "{one:00 млн other:00 млн}",
                    "{one:000 млн other:000 млн}",
                    "{one:0 млрд other:0 млрд}",
                    "{one:00 млрд other:00 млрд}",
                    "{one:000 млрд other:000 млрд}",
                    "{one:0 трлн other:0 трлн}",
                    "{one:00 трлн other:00 трлн}",
                    "{one:000 трлн other:000 трлн}",
                }
            },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{zero:0' 'пин one:0' 'пин other:0' 'пин}",
                    "{zero:00' 'пин one:00' 'пин other:00' 'пин}",
                    "{zero:000' 'пин one:000' 'пин other:000' 'пин}",
                    "{zero:0' 'млн one:0' 'млн other:0' 'млн}",
                    "{zero:00' 'млн one:00' 'млн other:00' 'млн}",
                    "{zero:000' 'млн one:000' 'млн other:000' 'млн}",
                    "{zero:0' 'млрд one:0' 'млрд other:0' 'млрд}",
                    "{zero:00' 'млрд one:00' 'млрд other:00' 'млрд}",
                    "{zero:000' 'млрд one:000' 'млрд other:000' 'млрд}",
                    "{zero:0' 'трлн one:0' 'трлн other:0' 'трлн}",
                    "{zero:00' 'трлн one:00' 'трлн other:00' 'трлн}",
                    "{zero:000' 'трлн one:000' 'трлн other:000' 'трлн}",
                }
            },
            { "ListPatterns_standard", metaValue_ListPatterns_standard },
            { "ListPatterns_standard-short", metaValue_ListPatterns_standard },
            { "ListPatterns_standard-narrow",
                new String[] {
                    "",
                    "",
                    "{0}, {1}",
                    "{0}, {1}",
                    "",
                }
            },
            { "ListPatterns_or", metaValue_ListPatterns_or },
            { "ListPatterns_or-short", metaValue_ListPatterns_or },
            { "ListPatterns_or-narrow", metaValue_ListPatterns_or },
            { "ListPatterns_unit", metaValue_ListPatterns_standard },
            { "ListPatterns_unit-short",
                new String[] {
                    "{0} {1}",
                    "{0} {1}",
                    "{0} {1}",
                    "{0} {1}",
                    "",
                }
            },
            { "ListPatterns_unit-narrow", metaValue_ListPatterns_standard },
        };
        return data;
    }
}
