// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
)

type DescribeUserViewIPRequest struct {
	core.JDCloudRequest

	/* 地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 自定义线路ID  */
	ViewId int `json:"viewId"`

	/* 自定义线路名称, 最多64个字节，允许：数字、字母、下划线，-，中文 (Optional) */
	ViewName *string `json:"viewName"`

	/* 分页参数，页的序号, 默认为1  */
	PageNumber int `json:"pageNumber"`

	/* 分页参数，每页含有的结果的数目，默认为10  */
	PageSize int `json:"pageSize"`
}

/*
 * param regionId: 地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param viewId: 自定义线路ID (Required)
 * param pageNumber: 分页参数，页的序号, 默认为1 (Required)
 * param pageSize: 分页参数，每页含有的结果的数目，默认为10 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeUserViewIPRequest(
	regionId string,
	domainId string,
	viewId int,
	pageNumber int,
	pageSize int,
) *DescribeUserViewIPRequest {

	return &DescribeUserViewIPRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/UserViewIP",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		ViewId:     viewId,
		PageNumber: pageNumber,
		PageSize:   pageSize,
	}
}

/*
 * param regionId: 地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param viewId: 自定义线路ID (Required)
 * param viewName: 自定义线路名称, 最多64个字节，允许：数字、字母、下划线，-，中文 (Optional)
 * param pageNumber: 分页参数，页的序号, 默认为1 (Required)
 * param pageSize: 分页参数，每页含有的结果的数目，默认为10 (Required)
 */
func NewDescribeUserViewIPRequestWithAllParams(
	regionId string,
	domainId string,
	viewId int,
	viewName *string,
	pageNumber int,
	pageSize int,
) *DescribeUserViewIPRequest {

	return &DescribeUserViewIPRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/UserViewIP",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:   regionId,
		DomainId:   domainId,
		ViewId:     viewId,
		ViewName:   viewName,
		PageNumber: pageNumber,
		PageSize:   pageSize,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeUserViewIPRequestWithoutParam() *DescribeUserViewIPRequest {

	return &DescribeUserViewIPRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/UserViewIP",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 地域ID(Required) */
func (r *DescribeUserViewIPRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *DescribeUserViewIPRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param viewId: 自定义线路ID(Required) */
func (r *DescribeUserViewIPRequest) SetViewId(viewId int) {
	r.ViewId = viewId
}

/* param viewName: 自定义线路名称, 最多64个字节，允许：数字、字母、下划线，-，中文(Optional) */
func (r *DescribeUserViewIPRequest) SetViewName(viewName string) {
	r.ViewName = &viewName
}

/* param pageNumber: 分页参数，页的序号, 默认为1(Required) */
func (r *DescribeUserViewIPRequest) SetPageNumber(pageNumber int) {
	r.PageNumber = pageNumber
}

/* param pageSize: 分页参数，每页含有的结果的数目，默认为10(Required) */
func (r *DescribeUserViewIPRequest) SetPageSize(pageSize int) {
	r.PageSize = pageSize
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeUserViewIPRequest) GetRegionId() string {
	return r.RegionId
}

type DescribeUserViewIPResponse struct {
	RequestID string                   `json:"requestId"`
	Error     core.ErrorResponse       `json:"error"`
	Result    DescribeUserViewIPResult `json:"result"`
}

type DescribeUserViewIPResult struct {
	DataList     []string `json:"dataList"`
	CurrentCount int      `json:"currentCount"`
	TotalCount   int      `json:"totalCount"`
	TotalPage    int      `json:"totalPage"`
}
