/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// StopTime : departure or arrival event at a stop
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct StopTime {
    /// information about the stop place and time
    #[serde(rename = "place")]
    pub place: Box<models::Place>,
    /// Transport mode for this leg
    #[serde(rename = "mode")]
    pub mode: models::Mode,
    /// Whether there is real-time data about this leg
    #[serde(rename = "realTime")]
    pub real_time: bool,
    /// The headsign of the bus or train being used. For non-transit legs, null 
    #[serde(rename = "headsign")]
    pub headsign: String,
    /// final stop of this trip
    #[serde(rename = "tripTo")]
    pub trip_to: Box<models::Place>,
    #[serde(rename = "agencyId")]
    pub agency_id: String,
    #[serde(rename = "agencyName")]
    pub agency_name: String,
    #[serde(rename = "agencyUrl")]
    pub agency_url: String,
    #[serde(rename = "routeColor", skip_serializing_if = "Option::is_none")]
    pub route_color: Option<String>,
    #[serde(rename = "routeTextColor", skip_serializing_if = "Option::is_none")]
    pub route_text_color: Option<String>,
    #[serde(rename = "tripId")]
    pub trip_id: String,
    #[serde(rename = "routeType", skip_serializing_if = "Option::is_none")]
    pub route_type: Option<i32>,
    #[serde(rename = "routeShortName")]
    pub route_short_name: String,
    #[serde(rename = "routeLongName")]
    pub route_long_name: String,
    #[serde(rename = "tripShortName")]
    pub trip_short_name: String,
    #[serde(rename = "displayName")]
    pub display_name: String,
    /// Experimental. Expect unannounced breaking changes (without version bumps).  Stops on the trips before this stop. Returned only if `fetchStop` and `arriveBy` are `true`. 
    #[serde(rename = "previousStops", skip_serializing_if = "Option::is_none")]
    pub previous_stops: Option<Vec<models::Place>>,
    /// Experimental. Expect unannounced breaking changes (without version bumps).  Stops on the trips after this stop. Returned only if `fetchStop` is `true` and `arriveBy` is `false`. 
    #[serde(rename = "nextStops", skip_serializing_if = "Option::is_none")]
    pub next_stops: Option<Vec<models::Place>>,
    /// Type of pickup (for departures) or dropoff (for arrivals), may be disallowed either due to schedule, skipped stops or cancellations
    #[serde(rename = "pickupDropoffType")]
    pub pickup_dropoff_type: models::PickupDropoffType,
    /// Whether the departure/arrival is cancelled due to the realtime situation (either because the stop is skipped or because the entire trip is cancelled).
    #[serde(rename = "cancelled")]
    pub cancelled: bool,
    /// Whether the entire trip is cancelled due to the realtime situation.
    #[serde(rename = "tripCancelled")]
    pub trip_cancelled: bool,
    /// Filename and line number where this trip is from
    #[serde(rename = "source")]
    pub source: String,
}

impl StopTime {
    /// departure or arrival event at a stop
    pub fn new(place: models::Place, mode: models::Mode, real_time: bool, headsign: String, trip_to: models::Place, agency_id: String, agency_name: String, agency_url: String, trip_id: String, route_short_name: String, route_long_name: String, trip_short_name: String, display_name: String, pickup_dropoff_type: models::PickupDropoffType, cancelled: bool, trip_cancelled: bool, source: String) -> StopTime {
        StopTime {
            place: Box::new(place),
            mode,
            real_time,
            headsign,
            trip_to: Box::new(trip_to),
            agency_id,
            agency_name,
            agency_url,
            route_color: None,
            route_text_color: None,
            trip_id,
            route_type: None,
            route_short_name,
            route_long_name,
            trip_short_name,
            display_name,
            previous_stops: None,
            next_stops: None,
            pickup_dropoff_type,
            cancelled,
            trip_cancelled,
            source,
        }
    }
}

