use v6.e.PREVIEW;
#BEGIN %*ENV<PERL6_TEST_DIE_ON_FAIL> = True;
use Test;

# Test combinations of flags for "%d" and "%i".  The @info array is intialized
# with the flags (as a string), the size/precision specification (either a
# string or a # number), and the expected strings for the values 0, 1, 314 and
# -314.  The flags values will be expanded to all possible permutations to
# ensure that the order of the flags is irrelevant.  Each flag permutation is
# combined with the size/permutation value to create a proper format string.
# Each test will be done twice: once with a lowercase "d" and once with "i".

#                        0 ,         1 ,       314 ,      -314 ;
my @info = ( # |-----------|-----------|-----------|-----------|
             # no size or size explicitely 0
       '',   '',        "0",        "1",      "314",     "-314",
      ' ',   '',       " 0",       " 1",     " 314",     "-314",
      '0',   '',        "0",        "1",      "314",     "-314",
     '0 ',   '',       " 0",       " 1",     " 314",     "-314",
      '+',   '',       "+0",       "+1",     "+314",     "-314",
     '+ ',   '',       "+0",       "+1",     "+314",     "-314",
     '+0',   '',       "+0",       "+1",     "+314",     "-314",
    '+0 ',   '',       "+0",       "+1",     "+314",     "-314",
      '-',   '',        "0",        "1",      "314",     "-314",
     '-+',   '',       "+0",       "+1",     "+314",     "-314",
     '- ',   '',       " 0",       " 1",     " 314",     "-314",
    '-+ ',   '',       "+0",       "+1",     "+314",     "-314",
     '-0',   '',        "0",        "1",      "314",     "-314",
    '-+0',   '',       "+0",       "+1",     "+314",     "-314",
    '-0 ',   '',       " 0",       " 1",     " 314",     "-314",
   '-+0 ',   '',       "+0",       "+1",     "+314",     "-314",

             # no size, precision 0
       '', '.0',         "",        "1",      "314",     "-314",
      ' ', '.0',        " ",       " 1",     " 314",     "-314",
      '0', '.0',         "",        "1",      "314",     "-314",
     '0 ', '.0',        " ",       " 1",     " 314",     "-314",
      '+', '.0',        "+",       "+1",     "+314",     "-314",
     '+ ', '.0',        "+",       "+1",     "+314",     "-314",
     '+0', '.0',        "+",       "+1",     "+314",     "-314",
    '+0 ', '.0',        "+",       "+1",     "+314",     "-314",
      '-', '.0',         "",        "1",      "314",     "-314",
     '-+', '.0',        "+",       "+1",     "+314",     "-314",
     '- ', '.0',        " ",       " 1",     " 314",     "-314",
    '-+ ', '.0',        "+",       "+1",     "+314",     "-314",
     '-0', '.0',         "",        "1",      "314",     "-314",
    '-+0', '.0',        "+",       "+1",     "+314",     "-314",
    '-0 ', '.0',        " ",       " 1",     " 314",     "-314",
   '-+0 ', '.0',        "+",       "+1",     "+314",     "-314",

             # 2 positions, usually doesn't fit
       '',    2,       " 0",       " 1",      "314",     "-314",
      ' ',    2,       " 0",       " 1",     " 314",     "-314",
      '0',    2,       "00",       "01",      "314",     "-314",
     '0 ',    2,       " 0",       " 1",     " 314",     "-314",
      '+',    2,       "+0",       "+1",     "+314",     "-314",
     '+ ',    2,       "+0",       "+1",     "+314",     "-314",
     '+0',    2,       "+0",       "+1",     "+314",     "-314",
    '+0 ',    2,       "+0",       "+1",     "+314",     "-314",
      '-',    2,       "0 ",       "1 ",      "314",     "-314",
     '-+',    2,       "+0",       "+1",     "+314",     "-314",
     '- ',    2,       " 0",       " 1",     " 314",     "-314",
    '-+ ',    2,       "+0",       "+1",     "+314",     "-314",
     '-0',    2,       "0 ",       "1 ",      "314",     "-314",
    '-+0',    2,       "+0",       "+1",     "+314",     "-314",
    '-0 ',    2,       " 0",       " 1",     " 314",     "-314",
   '-+0 ',    2,       "+0",       "+1",     "+314",     "-314",

             # 8 positions, should always fit
       '',    8, "       0", "       1", "     314", "    -314",
      ' ',    8, "       0", "       1", "     314", "    -314",
      '0',    8, "00000000", "00000001", "00000314", "-0000314",
     '0 ',    8, " 0000000", " 0000001", " 0000314", "-0000314",
      '+',    8, "      +0", "      +1", "    +314", "    -314",
     '+ ',    8, "      +0", "      +1", "    +314", "    -314",
     '+0',    8, "+0000000", "+0000001", "+0000314", "-0000314",
    '+0 ',    8, "+0000000", "+0000001", "+0000314", "-0000314",
      '-',    8, "0       ", "1       ", "314     ", "-314    ",
     '-+',    8, "+0      ", "+1      ", "+314    ", "-314    ",
     '- ',    8, " 0      ", " 1      ", " 314    ", "-314    ",
    '-+ ',    8, "+0      ", "+1      ", "+314    ", "-314    ",
     '-0',    8, "0       ", "1       ", "314     ", "-314    ",
    '-+0',    8, "+0      ", "+1      ", "+314    ", "-314    ",
    '-0 ',    8, " 0      ", " 1      ", " 314    ", "-314    ",
   '-+0 ',    8, "+0      ", "+1      ", "+314    ", "-314    ",

             # 8 positions with precision, precision fits sometimes
       '',  8.2, "      00", "      01", "     314", "    -314",
      ' ',  8.2, "      00", "      01", "     314", "    -314",
      '0',  8.2, "      00", "      01", "     314", "    -314",
     '0 ',  8.2, "      00", "      01", "     314", "    -314",
      '+',  8.2, "     +00", "     +01", "    +314", "    -314",
     '+ ',  8.2, "     +00", "     +01", "    +314", "    -314",
     '+0',  8.2, "     +00", "     +01", "    +314", "    -314",
    '+0 ',  8.2, "     +00", "     +01", "    +314", "    -314",
      '-',  8.2, "00      ", "01      ", "314     ", "-314    ",
     '-+',  8.2, "+00     ", "+01     ", "+314    ", "-314    ",
     '- ',  8.2, " 00     ", " 01     ", " 314    ", "-314    ",
    '-+ ',  8.2, "+00     ", "+01     ", "+314    ", "-314    ",
     '-0',  8.2, "00      ", "01      ", "314     ", "-314    ",
    '-+0',  8.2, "+00     ", "+01     ", "+314    ", "-314    ",
    '-0 ',  8.2, " 00     ", " 01     ", " 314    ", "-314    ",
   '-+0 ',  8.2, "+00     ", "+01     ", "+314    ", "-314    ",

).map: -> $flags, $size, $r0, $r1, $r4, $rm {
    my @flat;
    for $flags.comb.permutations>>.join -> $permuted {
        @flat.append(
          '%' ~ $permuted ~ $size ~ $_,
          ($r0 => 0, $r1 => 1, $r4 => 314, $rm => -314)
        ) for <d i>;
    }
    for "#$flags".comb.permutations>>.join -> $permuted {
        @flat.append(
          '%' ~ $permuted ~ $size ~ $_,
          ($r0 => 0, $r1 => 1, $r4 => 314, $rm => -314)
        ) for <d i>;
    }
    |@flat
}

# tests using variable precision 0
@info.append( (
             # no size, precision 0
       '', '.*',         "",        "1",      "314",     "-314",
      ' ', '.*',        " ",       " 1",     " 314",     "-314",
      '0', '.*',         "",        "1",      "314",     "-314",
     '0 ', '.*',        " ",       " 1",     " 314",     "-314",
      '+', '.*',        "+",       "+1",     "+314",     "-314",
     '+ ', '.*',        "+",       "+1",     "+314",     "-314",
     '+0', '.*',        "+",       "+1",     "+314",     "-314",
    '+0 ', '.*',        "+",       "+1",     "+314",     "-314",
      '-', '.*',         "",        "1",      "314",     "-314",
     '-+', '.*',        "+",       "+1",     "+314",     "-314",
     '- ', '.*',        " ",       " 1",     " 314",     "-314",
    '-+ ', '.*',        "+",       "+1",     "+314",     "-314",
     '-0', '.*',         "",        "1",      "314",     "-314",
    '-+0', '.*',        "+",       "+1",     "+314",     "-314",
    '-0 ', '.*',        " ",       " 1",     " 314",     "-314",
   '-+0 ', '.*',        "+",       "+1",     "+314",     "-314",

).map: -> $flags, $size, $r0, $r1, $r4, $rm {
    my @flat;
    for $flags.comb.permutations>>.join -> $permuted {
        @flat.append(
          '%' ~ $permuted ~ $size ~ $_,
          ($r0 => (0,0), $r1 => (0,1), $r4 => (0,314), $rm => (0,-314))
        ) for <d i>;
    }
    for "#$flags".comb.permutations>>.join -> $permuted {
        @flat.append(
          '%' ~ $permuted ~ $size ~ $_,
          ($r0 => (0,0), $r1 => (0,1), $r4 => (0,314), $rm => (0,-314))
        ) for <d i>;
    }
    |@flat
} );

# tests using variable precision 2
@info.append( (
             # 8 positions with precision, precision fits sometimes
       '', '8.*', "      00", "      01", "     314", "    -314",
      ' ', '8.*', "      00", "      01", "     314", "    -314",
      '0', '8.*', "      00", "      01", "     314", "    -314",
     '0 ', '8.*', "      00", "      01", "     314", "    -314",
      '+', '8.*', "     +00", "     +01", "    +314", "    -314",
     '+ ', '8.*', "     +00", "     +01", "    +314", "    -314",
     '+0', '8.*', "     +00", "     +01", "    +314", "    -314",
    '+0 ', '8.*', "     +00", "     +01", "    +314", "    -314",
      '-', '8.*', "00      ", "01      ", "314     ", "-314    ",
     '-+', '8.*', "+00     ", "+01     ", "+314    ", "-314    ",
     '- ', '8.*', " 00     ", " 01     ", " 314    ", "-314    ",
    '-+ ', '8.*', "+00     ", "+01     ", "+314    ", "-314    ",
     '-0', '8.*', "00      ", "01      ", "314     ", "-314    ",
    '-+0', '8.*', "+00     ", "+01     ", "+314    ", "-314    ",
    '-0 ', '8.*', " 00     ", " 01     ", " 314    ", "-314    ",
   '-+0 ', '8.*', "+00     ", "+01     ", "+314    ", "-314    ",

).map: -> $flags, $size, $r0, $r1, $r4, $rm {
    my @flat;
    for $flags.comb.permutations>>.join -> $permuted {
        @flat.append(
          '%' ~ $permuted ~ $size ~ $_,
          ($r0 => (2,0), $r1 => (2,1), $r4 => (2,314), $rm => (2,-314))
        ) for <d i>;
    }
    for "#$flags".comb.permutations>>.join -> $permuted {
        @flat.append(
          '%' ~ $permuted ~ $size ~ $_,
          ($r0 => (2,0), $r1 => (2,1), $r4 => (2,314), $rm => (2,-314))
        ) for <d i>;
    }
    |@flat
} );

# additional tests: key = expected result, value is the value to test
@info.append(
  "%d", (
    Pair.new(
      "453973694165307953197296969697410619233826",
       453973694165307953197296969697410619233826
    ),
    Pair.new(
      "-453973694165307953197296969697410619233826",
       -453973694165307953197296969697410619233826
    ),
    Pair.new(
      "453973694165307953197296969697410619233826",
       453973694165307953197296969697410619233826 + .1
    ),
    Pair.new(
      "-453973694165307953197296969697410619233826",
       -453973694165307953197296969697410619233826 - .1
    ),
    Pair.new(
      "453973694165307953197296969697410619233826",
      (453973694165307953197296969697410619233826 + .1).FatRat
    ),
    Pair.new(
      "-453973694165307953197296969697410619233826",
      (-453973694165307953197296969697410619233826 - .1).FatRat
    ),
    Pair.new(
      "291733167875766667063796853374976",
      42**20
    ),
  ),
);

plan @info/2;

for @info -> $format, @tests {
    subtest {
        plan +@tests;

        is-deeply zprintf($format, |.value), .key,
          qq/zprintf("$format",{.value.list.join(",")}) eq '{.key}'/
          for @tests;
    }, "Tested '$format'";
}

# vim: expandtab shiftwidth=4
